/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.lexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.gjt.sp.jedit.bsh.Interpreter;
import superabbrevs.lexer.TemplateLexer;
import superabbrevs.lexer.Token;
import superabbrevs.template.EndField;
import superabbrevs.template.Field;
import superabbrevs.template.TempField;
import superabbrevs.template.TempTranformationField;
import superabbrevs.template.Template;
import superabbrevs.template.TextField;
import superabbrevs.template.TransformationField;
import superabbrevs.template.VariableField;
import superabbrevs.template.VariableFieldPointer;

public class TemplateParser {
    private TemplateLexer lexer;
    private List template = new ArrayList();
    private TreeMap fieldMap;
    private boolean endFound = false;
    private Interpreter interpreter;

    public TemplateParser(TemplateLexer lexer, Interpreter interpreter) {
        this.lexer = lexer;
        this.interpreter = interpreter;
    }

    public Template parse() throws IOException {
        Token t;
        this.fieldMap = new TreeMap();
        while (null != (t = this.lexer.nextToken())) {
            switch (t.getType()) {
                case 1: {
                    this.textField((String)t.getValue(0));
                    break;
                }
                case 4: {
                    this.field((Integer)t.getValue(0), (String)t.getValue(1));
                    break;
                }
                case 5: {
                    this.fieldPointer((Integer)t.getValue(0));
                    break;
                }
                case 7: {
                    this.transformationField((Integer)t.getValue(0), (String)t.getValue(1));
                    break;
                }
                case 6: {
                    this.endField();
                }
            }
        }
        if (!this.endFound) {
            this.addEndField();
        }
        this.replaceTempFields();
        List fieldList = this.buildFieldList();
        return new Template(this.template, fieldList);
    }

    public void textField(String text) {
        this.addTextField(text);
    }

    public void field(Integer number, String value) {
        if (this.isDefined(number)) {
            this.addFieldPointer(this.getVariableField(number));
        } else {
            this.addVariableField(number, value);
        }
    }

    public void fieldPointer(Integer number) {
        if (this.isDefined(number)) {
            this.addFieldPointer(this.getVariableField(number));
        } else {
            this.addTempField(number);
        }
    }

    public void endField() {
        this.addEndField();
        this.endFound = true;
    }

    public void transformationField(Integer number, String code) {
        if (this.isDefined(number)) {
            this.addTransformationField(this.getVariableField(number), code);
        } else {
            this.addTempField(number, code);
        }
    }

    private boolean isDefined(Integer number) {
        return this.fieldMap.containsKey(number);
    }

    private VariableField getVariableField(Integer number) {
        return (VariableField)this.fieldMap.get(number);
    }

    private void addTempField(Integer number) {
        this.template.add(new TempField(number));
    }

    private void addTempField(Integer number, String code) {
        this.template.add(new TempTranformationField(number, code));
    }

    private void addVariableField(Integer number, String value) {
        VariableField field = new VariableField(value);
        this.fieldMap.put(number, field);
        this.template.add(field);
    }

    private void addFieldPointer(VariableField field) {
        this.template.add(new VariableFieldPointer(field));
    }

    private void addTransformationField(VariableField field, String code) {
        this.template.add(new TransformationField(field, code, this.interpreter));
    }

    private void addTextField(String text) {
        TextField textField = new TextField(text);
        this.template.add(textField);
    }

    private void addEndField() {
        EndField endField = new EndField();
        Integer endFieldNumber = new Integer(Integer.MAX_VALUE);
        this.fieldMap.put(endFieldNumber, endField);
        this.template.add(endField);
    }

    private List buildFieldList() {
        ArrayList fieldList = new ArrayList();
        Iterator iter = this.fieldMap.values().iterator();
        while (iter.hasNext()) {
            fieldList.add(iter.next());
        }
        return fieldList;
    }

    private void replaceTempFields() {
        for (int i = 0; i < this.template.size(); ++i) {
            VariableField variableField;
            Integer number;
            Field tempField;
            Field field = (Field)this.template.get(i);
            if (field instanceof TempField) {
                tempField = (TempField)field;
                number = ((TempField)tempField).getNumber();
                variableField = this.getVariableField(number);
                if (variableField == null) {
                    variableField = new VariableField("");
                    this.fieldMap.put(number, variableField);
                    this.template.set(i, variableField);
                    continue;
                }
                this.template.set(i, new VariableFieldPointer(variableField));
                continue;
            }
            if (!(field instanceof TempTranformationField)) continue;
            tempField = (TempTranformationField)field;
            number = ((TempTranformationField)tempField).getNumber();
            variableField = this.getVariableField(number);
            if (variableField == null) {
                this.template.remove(i);
                --i;
                continue;
            }
            String code = ((TempTranformationField)tempField).getCode();
            this.template.set(i, new TransformationField(variableField, code, this.interpreter));
        }
    }
}

