/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.lexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import superabbrevs.lexer.Token;

public class TemplateLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int VARIABLE_START = 2;
    public static final int YYINITIAL = 0;
    public static final int TRANSFORMATION_FIELD = 3;
    public static final int FIELD = 1;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0006\u0001\u0005\u0002\u0000\u0001\u0007\u000e\u0000\b\u0000\u0001\u0004\u000b\u0000\u0001\u0001\t\u0002\u0001\r\u0002\u0000\u0001\u000e\u0003\u0000\u001a\u0000\u0001\u0000\u0001\u0003\u0002\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0001\n\u0001\b\b\u0000\u0001\t\f\u0000\u0001\u000b\u0001\u0000\u0001\f\u0001\u0000!\u0000\u0002\u0000\u0004\u0000\u0004\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0004\u0000\u0001\u0000\u0005\u0000\u0017\u0000\u0001\u0000\u001f\u0000\u0001\u0000\u013f\u0000\u0019\u0000r\u0000\u0004\u0000\f\u0000\u000e\u0000\u0005\u0000\t\u0000\u0001\u0000\u0011\u0000X\u0000\u0005\u0000\u0013\u0000\n\u0000\u0001\u0000\u000b\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0014\u0000\u0001\u0000,\u0000\u0001\u0000&\u0000\u0001\u0000\u0005\u0000\u0004\u0000\u0082\u0000\u0001\u0000\u0004\u0000\u0003\u0000E\u0000\u0001\u0000&\u0000\u0002\u0000\u0002\u0000\u0006\u0000\u0010\u0000!\u0000&\u0000\u0002\u0000\u0001\u0000\u0007\u0000'\u0000\t\u0000\u0011\u0000\u0001\u0000\u0017\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u000b\u0000\u001b\u0000\u0005\u0000\u0003\u0000\r\u0000\u0004\u0000\f\u0000\u0006\u0000\u000b\u0000\u001a\u0000\u0005\u0000\u000b\u0000\u000e\u0000\u0007\u0000\n\u0000\u0004\u0000\u0002\u0000\u0001\u0000c\u0000\u0001\u0000\u0001\u0000\b\u0000\u0001\u0000\u0006\u0000\u0002\u0000\u0002\u0000\u0001\u0000\u0004\u0000\u0002\u0000\n\u0000\u0003\u0000\u0002\u0000\u0001\u0000\u000f\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u001e\u0000\u001b\u0000\u0002\u0000\u0003\u00000\u0000&\u0000\u000b\u0000\u0001\u0000\u014f\u0000\u0003\u00006\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0010\u0000\u0002\u0000\u0001\u0000\u0004\u0000\u0003\u0000\n\u0000\u0002\u0000\u0002\u0000\n\u0000\u0011\u0000\u0003\u0000\u0001\u0000\b\u0000\u0002\u0000\u0002\u0000\u0002\u0000\u0016\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0004\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0007\u0000\u0002\u0000\u0002\u0000\u0002\u0000\u0003\u0000\t\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u0001\u0000\u0003\u0000\u0002\u0000\u0002\u0000\n\u0000\u0004\u0000\r\u0000\u0003\u0000\u0001\u0000\u0006\u0000\u0004\u0000\u0002\u0000\u0002\u0000\u0016\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0002\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0005\u0000\u0004\u0000\u0002\u0000\u0002\u0000\u0003\u0000\u000b\u0000\u0004\u0000\u0001\u0000\u0001\u0000\u0007\u0000\f\u0000\u0003\u0000\f\u0000\u0003\u0000\u0001\u0000\t\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0016\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0005\u0000\u0002\u0000\u0001\u0000\u0001\u0000\b\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0003\u0000\u0002\u0000\u0001\u0000\u000f\u0000\u0002\u0000\u0002\u0000\u0002\u0000\n\u0000\u0001\u0000\u0001\u0000\u000f\u0000\u0003\u0000\u0001\u0000\b\u0000\u0002\u0000\u0002\u0000\u0002\u0000\u0016\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0005\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0006\u0000\u0003\u0000\u0002\u0000\u0002\u0000\u0003\u0000\b\u0000\u0002\u0000\u0004\u0000\u0002\u0000\u0001\u0000\u0003\u0000\u0004\u0000\n\u0000\u0001\u0000\u0001\u0000\u0010\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0006\u0000\u0003\u0000\u0003\u0000\u0001\u0000\u0004\u0000\u0003\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0003\u0000\u0002\u0000\u0003\u0000\u0003\u0000\u0003\u0000\b\u0000\u0001\u0000\u0003\u0000\u0004\u0000\u0005\u0000\u0003\u0000\u0003\u0000\u0001\u0000\u0004\u0000\t\u0000\u0001\u0000\u000f\u0000\t\u0000\t\u0000\u0001\u0000\u0007\u0000\u0003\u0000\u0001\u0000\b\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0017\u0000\u0001\u0000\n\u0000\u0001\u0000\u0005\u0000\u0004\u0000\u0007\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0004\u0000\u0007\u0000\u0002\u0000\t\u0000\u0002\u0000\u0004\u0000\n\u0000\u0012\u0000\u0002\u0000\u0001\u0000\b\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0017\u0000\u0001\u0000\n\u0000\u0001\u0000\u0005\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0004\u0000\u0007\u0000\u0002\u0000\u0007\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0004\u0000\n\u0000\u0012\u0000\u0002\u0000\u0001\u0000\b\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0017\u0000\u0001\u0000\u0010\u0000\u0004\u0000\u0006\u0000\u0002\u0000\u0003\u0000\u0001\u0000\u0004\u0000\t\u0000\u0001\u0000\b\u0000\u0002\u0000\u0004\u0000\n\u0000\u0012\u0000\u0002\u0000\u0001\u0000\u0012\u0000\u0003\u0000\u0018\u0000\u0001\u0000\t\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0007\u0000\u0003\u0000\u0001\u0000\u0004\u0000\u0006\u0000\u0001\u0000\u0001\u0000\u0001\u0000\b\u0000\u0012\u0000\u0002\u0000\r\u00000\u0000\u0001\u0000\u0002\u0000\u0007\u0000\u0004\u0000\b\u0000\b\u0000\u0001\u0000\n\u0000'\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0006\u0000\u0004\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0002\u0000\u0001\u0000\u0004\u0000\u0001\u0000\u0002\u0000\u0006\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0002\u0000\u0005\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0006\u0000\u0002\u0000\n\u0000\u0002\u0000\u0002\u0000\"\u0000\u0001\u0000\u0017\u0000\u0002\u0000\u0006\u0000\n\u0000\u000b\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\b\u0000\u0001\u0000\"\u0000\u0006\u0000\u0014\u0000\u0001\u0000\u0002\u0000\u0004\u0000\u0004\u0000\b\u0000\u0001\u0000$\u0000\t\u0000\u0001\u00009\u0000\"\u0000\u0001\u0000\u0005\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0007\u0000\u0003\u0000\u0004\u0000\u0006\u0000\n\u0000\u0006\u0000\u0006\u0000\u0004\u0000F\u0000&\u0000\n\u0000)\u0000\u0007\u0000Z\u0000\u0005\u0000D\u0000\u0005\u0000R\u0000\u0006\u0000\u0007\u0000\u0001\u0000?\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u0007\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000'\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u001f\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u0007\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u0007\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0017\u0000\u0001\u0000\u001f\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u0007\u0000\u0001\u0000'\u0000\u0001\u0000\u0013\u0000\u000e\u0000\t\u0000.\u0000U\u0000\f\u0000\u026c\u0000\u0002\u0000\b\u0000\n\u0000\u001a\u0000\u0005\u0000K\u0000\u0003\u0000\u0003\u0000\u000f\u0000\r\u0000\u0001\u0000\u0004\u0000\u0003\u0000\u000b\u0000\u0012\u0000\u0003\u0000\u000b\u0000\u0012\u0000\u0002\u0000\f\u0000\r\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0002\u0000\f\u00004\u0000 \u0000\u0003\u0000\u0001\u0000\u0003\u0000\u0002\u0000\u0001\u0000\u0002\u0000\n\u0000!\u0000\u0003\u0000\u0002\u0000\n\u0000\u0006\u0000X\u0000\b\u0000)\u0000\u0001\u0000V\u0000\u001d\u0000\u0003\u0000\f\u0000\u0004\u0000\f\u0000\n\u0000\n\u0000\u001e\u0000\u0002\u0000\u0005\u0000\u038b\u0000l\u0000\u0094\u0000\u009c\u0000\u0004\u0000Z\u0000\u0006\u0000\u0016\u0000\u0002\u0000\u0006\u0000\u0002\u0000&\u0000\u0002\u0000\u0006\u0000\u0002\u0000\b\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u001f\u0000\u0002\u00005\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0003\u0000\u0001\u0000\u0007\u0000\u0003\u0000\u0004\u0000\u0002\u0000\u0006\u0000\u0004\u0000\r\u0000\u0005\u0000\u0003\u0000\u0001\u0000\u0007\u0000\u000f\u0000\u0004\u0000\u001a\u0000\u0005\u0000\u0010\u0000\u0002\u0000\u0013\u0000\u0001\u0000\u000b\u0000\u0004\u0000\u0006\u0000\u0006\u0000\u0001\u0000\u0001\u0000\r\u0000\u0001\u0000 \u0000\u0012\u0000\u001e\u0000\r\u0000\u0004\u0000\u0001\u0000\u0003\u0000\u0006\u0000\u0017\u0000\u0001\u0000\u0004\u0000\u0001\u0000\u0002\u0000\n\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0005\u0000\u0006\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0007\u0000\u0003\u0000\u0003\u0000\u0005\u0000\u0005\u0000\u0016\u0000$\u0000\u0e81\u0000\u0003\u0000\u0019\u0000\t\u0000\u0006\u0000\u0001\u0000\u0005\u0000\u0002\u0000\u0005\u0000\u0004\u0000V\u0000\u0002\u0000\u0002\u0000\u0002\u0000\u0003\u0000\u0001\u0000_\u0000\u0005\u0000(\u0000\u0004\u0000^\u0000\u0011\u0000\u0018\u00008\u0000\u0010\u0000\u0200\u0000\u19b6\u0000J\u0000\u51a6\u0000Z\u0000\u048d\u0000\u0773\u0000\u2ba4\u0000\u215c\u0000\u012e\u0000\u0002\u0000;\u0000\u0095\u0000\u0007\u0000\f\u0000\u0005\u0000\u0005\u0000\u0001\u0000\u0001\u0000\n\u0000\u0001\u0000\r\u0000\u0001\u0000\u0005\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0002\u0000\u0001\u0000l\u0000!\u0000\u016b\u0000\u0012\u0000@\u0000\u0002\u00006\u0000(\u0000\r\u0000\u0003\u0000\u0010\u0000\u0010\u0000\u0004\u0000\u000f\u0000\u0002\u0000\u0018\u0000\u0003\u0000\u0019\u0000\u0001\u0000\u0006\u0000\u0005\u0000\u0001\u0000\u0087\u0000\u0002\u0000\u0001\u0000\u0004\u0000\u0001\u0000\u000b\u0000\n\u0000\u0007\u0000\u001a\u0000\u0004\u0000\u0001\u0000\u0001\u0000\u001a\u0000\n\u0000Z\u0000\u0003\u0000\u0006\u0000\u0002\u0000\u0006\u0000\u0002\u0000\u0006\u0000\u0002\u0000\u0003\u0000\u0003\u0000\u0002\u0000\u0003\u0000\u0002\u0000\u0012\u0000\u0003\u0000\u0004\u0000";
    private static final char[] ZZ_CMAP = TemplateLexer.zzUnpackCMap("\t\u0000\u0001\u0006\u0001\u0005\u0002\u0000\u0001\u0007\u000e\u0000\b\u0000\u0001\u0004\u000b\u0000\u0001\u0001\t\u0002\u0001\r\u0002\u0000\u0001\u000e\u0003\u0000\u001a\u0000\u0001\u0000\u0001\u0003\u0002\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0001\n\u0001\b\b\u0000\u0001\t\f\u0000\u0001\u000b\u0001\u0000\u0001\f\u0001\u0000!\u0000\u0002\u0000\u0004\u0000\u0004\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0004\u0000\u0001\u0000\u0005\u0000\u0017\u0000\u0001\u0000\u001f\u0000\u0001\u0000\u013f\u0000\u0019\u0000r\u0000\u0004\u0000\f\u0000\u000e\u0000\u0005\u0000\t\u0000\u0001\u0000\u0011\u0000X\u0000\u0005\u0000\u0013\u0000\n\u0000\u0001\u0000\u000b\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0014\u0000\u0001\u0000,\u0000\u0001\u0000&\u0000\u0001\u0000\u0005\u0000\u0004\u0000\u0082\u0000\u0001\u0000\u0004\u0000\u0003\u0000E\u0000\u0001\u0000&\u0000\u0002\u0000\u0002\u0000\u0006\u0000\u0010\u0000!\u0000&\u0000\u0002\u0000\u0001\u0000\u0007\u0000'\u0000\t\u0000\u0011\u0000\u0001\u0000\u0017\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u000b\u0000\u001b\u0000\u0005\u0000\u0003\u0000\r\u0000\u0004\u0000\f\u0000\u0006\u0000\u000b\u0000\u001a\u0000\u0005\u0000\u000b\u0000\u000e\u0000\u0007\u0000\n\u0000\u0004\u0000\u0002\u0000\u0001\u0000c\u0000\u0001\u0000\u0001\u0000\b\u0000\u0001\u0000\u0006\u0000\u0002\u0000\u0002\u0000\u0001\u0000\u0004\u0000\u0002\u0000\n\u0000\u0003\u0000\u0002\u0000\u0001\u0000\u000f\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u001e\u0000\u001b\u0000\u0002\u0000\u0003\u00000\u0000&\u0000\u000b\u0000\u0001\u0000\u014f\u0000\u0003\u00006\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0010\u0000\u0002\u0000\u0001\u0000\u0004\u0000\u0003\u0000\n\u0000\u0002\u0000\u0002\u0000\n\u0000\u0011\u0000\u0003\u0000\u0001\u0000\b\u0000\u0002\u0000\u0002\u0000\u0002\u0000\u0016\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0004\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0007\u0000\u0002\u0000\u0002\u0000\u0002\u0000\u0003\u0000\t\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u0001\u0000\u0003\u0000\u0002\u0000\u0002\u0000\n\u0000\u0004\u0000\r\u0000\u0003\u0000\u0001\u0000\u0006\u0000\u0004\u0000\u0002\u0000\u0002\u0000\u0016\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0002\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0005\u0000\u0004\u0000\u0002\u0000\u0002\u0000\u0003\u0000\u000b\u0000\u0004\u0000\u0001\u0000\u0001\u0000\u0007\u0000\f\u0000\u0003\u0000\f\u0000\u0003\u0000\u0001\u0000\t\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0016\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0005\u0000\u0002\u0000\u0001\u0000\u0001\u0000\b\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0003\u0000\u0002\u0000\u0001\u0000\u000f\u0000\u0002\u0000\u0002\u0000\u0002\u0000\n\u0000\u0001\u0000\u0001\u0000\u000f\u0000\u0003\u0000\u0001\u0000\b\u0000\u0002\u0000\u0002\u0000\u0002\u0000\u0016\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0005\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0006\u0000\u0003\u0000\u0002\u0000\u0002\u0000\u0003\u0000\b\u0000\u0002\u0000\u0004\u0000\u0002\u0000\u0001\u0000\u0003\u0000\u0004\u0000\n\u0000\u0001\u0000\u0001\u0000\u0010\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0006\u0000\u0003\u0000\u0003\u0000\u0001\u0000\u0004\u0000\u0003\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0003\u0000\u0002\u0000\u0003\u0000\u0003\u0000\u0003\u0000\b\u0000\u0001\u0000\u0003\u0000\u0004\u0000\u0005\u0000\u0003\u0000\u0003\u0000\u0001\u0000\u0004\u0000\t\u0000\u0001\u0000\u000f\u0000\t\u0000\t\u0000\u0001\u0000\u0007\u0000\u0003\u0000\u0001\u0000\b\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0017\u0000\u0001\u0000\n\u0000\u0001\u0000\u0005\u0000\u0004\u0000\u0007\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0004\u0000\u0007\u0000\u0002\u0000\t\u0000\u0002\u0000\u0004\u0000\n\u0000\u0012\u0000\u0002\u0000\u0001\u0000\b\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0017\u0000\u0001\u0000\n\u0000\u0001\u0000\u0005\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0004\u0000\u0007\u0000\u0002\u0000\u0007\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0004\u0000\n\u0000\u0012\u0000\u0002\u0000\u0001\u0000\b\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0017\u0000\u0001\u0000\u0010\u0000\u0004\u0000\u0006\u0000\u0002\u0000\u0003\u0000\u0001\u0000\u0004\u0000\t\u0000\u0001\u0000\b\u0000\u0002\u0000\u0004\u0000\n\u0000\u0012\u0000\u0002\u0000\u0001\u0000\u0012\u0000\u0003\u0000\u0018\u0000\u0001\u0000\t\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0007\u0000\u0003\u0000\u0001\u0000\u0004\u0000\u0006\u0000\u0001\u0000\u0001\u0000\u0001\u0000\b\u0000\u0012\u0000\u0002\u0000\r\u00000\u0000\u0001\u0000\u0002\u0000\u0007\u0000\u0004\u0000\b\u0000\b\u0000\u0001\u0000\n\u0000'\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0002\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0006\u0000\u0004\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0002\u0000\u0001\u0000\u0004\u0000\u0001\u0000\u0002\u0000\u0006\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0002\u0000\u0005\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0006\u0000\u0002\u0000\n\u0000\u0002\u0000\u0002\u0000\"\u0000\u0001\u0000\u0017\u0000\u0002\u0000\u0006\u0000\n\u0000\u000b\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\b\u0000\u0001\u0000\"\u0000\u0006\u0000\u0014\u0000\u0001\u0000\u0002\u0000\u0004\u0000\u0004\u0000\b\u0000\u0001\u0000$\u0000\t\u0000\u0001\u00009\u0000\"\u0000\u0001\u0000\u0005\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0007\u0000\u0003\u0000\u0004\u0000\u0006\u0000\n\u0000\u0006\u0000\u0006\u0000\u0004\u0000F\u0000&\u0000\n\u0000)\u0000\u0007\u0000Z\u0000\u0005\u0000D\u0000\u0005\u0000R\u0000\u0006\u0000\u0007\u0000\u0001\u0000?\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u0007\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000'\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u001f\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u0007\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u0007\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0017\u0000\u0001\u0000\u001f\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0002\u0000\u0007\u0000\u0001\u0000'\u0000\u0001\u0000\u0013\u0000\u000e\u0000\t\u0000.\u0000U\u0000\f\u0000\u026c\u0000\u0002\u0000\b\u0000\n\u0000\u001a\u0000\u0005\u0000K\u0000\u0003\u0000\u0003\u0000\u000f\u0000\r\u0000\u0001\u0000\u0004\u0000\u0003\u0000\u000b\u0000\u0012\u0000\u0003\u0000\u000b\u0000\u0012\u0000\u0002\u0000\f\u0000\r\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0002\u0000\f\u00004\u0000 \u0000\u0003\u0000\u0001\u0000\u0003\u0000\u0002\u0000\u0001\u0000\u0002\u0000\n\u0000!\u0000\u0003\u0000\u0002\u0000\n\u0000\u0006\u0000X\u0000\b\u0000)\u0000\u0001\u0000V\u0000\u001d\u0000\u0003\u0000\f\u0000\u0004\u0000\f\u0000\n\u0000\n\u0000\u001e\u0000\u0002\u0000\u0005\u0000\u038b\u0000l\u0000\u0094\u0000\u009c\u0000\u0004\u0000Z\u0000\u0006\u0000\u0016\u0000\u0002\u0000\u0006\u0000\u0002\u0000&\u0000\u0002\u0000\u0006\u0000\u0002\u0000\b\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u001f\u0000\u0002\u00005\u0000\u0001\u0000\u0007\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0003\u0000\u0001\u0000\u0007\u0000\u0003\u0000\u0004\u0000\u0002\u0000\u0006\u0000\u0004\u0000\r\u0000\u0005\u0000\u0003\u0000\u0001\u0000\u0007\u0000\u000f\u0000\u0004\u0000\u001a\u0000\u0005\u0000\u0010\u0000\u0002\u0000\u0013\u0000\u0001\u0000\u000b\u0000\u0004\u0000\u0006\u0000\u0006\u0000\u0001\u0000\u0001\u0000\r\u0000\u0001\u0000 \u0000\u0012\u0000\u001e\u0000\r\u0000\u0004\u0000\u0001\u0000\u0003\u0000\u0006\u0000\u0017\u0000\u0001\u0000\u0004\u0000\u0001\u0000\u0002\u0000\n\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0005\u0000\u0006\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0004\u0000\u0001\u0000\u0003\u0000\u0001\u0000\u0007\u0000\u0003\u0000\u0003\u0000\u0005\u0000\u0005\u0000\u0016\u0000$\u0000\u0e81\u0000\u0003\u0000\u0019\u0000\t\u0000\u0006\u0000\u0001\u0000\u0005\u0000\u0002\u0000\u0005\u0000\u0004\u0000V\u0000\u0002\u0000\u0002\u0000\u0002\u0000\u0003\u0000\u0001\u0000_\u0000\u0005\u0000(\u0000\u0004\u0000^\u0000\u0011\u0000\u0018\u00008\u0000\u0010\u0000\u0200\u0000\u19b6\u0000J\u0000\u51a6\u0000Z\u0000\u048d\u0000\u0773\u0000\u2ba4\u0000\u215c\u0000\u012e\u0000\u0002\u0000;\u0000\u0095\u0000\u0007\u0000\f\u0000\u0005\u0000\u0005\u0000\u0001\u0000\u0001\u0000\n\u0000\u0001\u0000\r\u0000\u0001\u0000\u0005\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0002\u0000\u0001\u0000\u0002\u0000\u0001\u0000l\u0000!\u0000\u016b\u0000\u0012\u0000@\u0000\u0002\u00006\u0000(\u0000\r\u0000\u0003\u0000\u0010\u0000\u0010\u0000\u0004\u0000\u000f\u0000\u0002\u0000\u0018\u0000\u0003\u0000\u0019\u0000\u0001\u0000\u0006\u0000\u0005\u0000\u0001\u0000\u0087\u0000\u0002\u0000\u0001\u0000\u0004\u0000\u0001\u0000\u000b\u0000\n\u0000\u0007\u0000\u001a\u0000\u0004\u0000\u0001\u0000\u0001\u0000\u001a\u0000\n\u0000Z\u0000\u0003\u0000\u0006\u0000\u0002\u0000\u0006\u0000\u0002\u0000\u0006\u0000\u0002\u0000\u0003\u0000\u0003\u0000\u0002\u0000\u0003\u0000\u0002\u0000\u0012\u0000\u0003\u0000\u0004\u0000");
    private static final int[] ZZ_ACTION = TemplateLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0004\u0000\u0002\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0002\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0002\f\u0001\r\u0001\u000e\u0001\u000f\u0002\u000b\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0004\u0000\u0001\u0014\u0001\u0015\u0001\u0016\u0002\u0000";
    private static final int[] ZZ_ROWMAP = TemplateLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u000f\u0000\u001e\u0000-\u0000<\u0000K\u0000<\u0000<\u0000<\u0000<\u0000<\u0000Z\u0000<\u0000<\u0000<\u0000<\u0000<\u0000<\u0000i\u0000<\u0000<\u0000<\u0000x\u0000\u0087\u0000<\u0000<\u0000<\u0000<\u0000\u0096\u0000\u00a5\u0000\u00b4\u0000\u00c3\u0000<\u0000<\u0000<\u0000\u00d2\u0000\u00e1";
    private static final int[] ZZ_TRANS = TemplateLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0003\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0007\u0005\u0003\u000b\u0001\f\u0001\u000b\u0001\r\u0001\u000e\u0001\u000f\u0004\u000b\u0001\u0010\u0002\u000b\u0001\u0011\u0001\u0012\u0001\u0013\u0002\u0011\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0002\u0011\u0001\u0018\u0003\u0011\u0005\u000b\u0001\u0000\u0005\u000b\u0001\u0019\u0001\u001a\u0002\u000b\u0012\u0000\u0002\u001b\r\u0000\u0001\u001c\u0007\u0000\u0002\u001c\u0003\u0000\u0002\u0013\u0015\u0000\u0001\u001d\u0006\u0000\u0001\u001e\u0001\u001f\u0005\u0000\u0001 \u0010\u0000\u0001!\u0011\u0000\u0001\"\u0001#\u0001\u0000\u0002\u001f\n\u0000\u0001\"\u0001#\t\u0000\u0001$\u000f\u0000\u0001%\u0010\u0000\u0001!\u0002\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = TemplateLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0004\u0000\u0001\t\u0001\u0001\u0005\t\u0001\u0001\u0006\t\u0001\u0001\u0003\t\u0002\u0001\u0004\t\u0004\u0000\u0003\t\u0002\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    StringBuffer field = new StringBuffer();
    Integer fieldNumber;
    StringBuffer text = new StringBuffer();
    int braceCount = 0;
    boolean end = false;

    private static int[] zzUnpackAction() {
        int[] result = new int[37];
        int offset = 0;
        offset = TemplateLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[37];
        int offset = 0;
        offset = TemplateLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[240];
        int offset = 0;
        offset = TemplateLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[37];
        int offset = 0;
        offset = TemplateLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private Integer readInteger(String s, int prefixLength, int suffixLength) {
        int length = s.length();
        s = s.substring(prefixLength, length - suffixLength);
        return new Integer(s);
    }

    private Token token(int type) {
        Token t = new Token(type);
        return t;
    }

    private Token token(int type, Object value) {
        Token t = new Token(type);
        t.addValue(value);
        return t;
    }

    private Token token(int type, Object value1, Object value2) {
        Token t = new Token(type);
        t.addValue(value1);
        t.addValue(value2);
        return t;
    }

    private String unEscape(String escaped) {
        return escaped.substring(1);
    }

    public TemplateLexer(Reader in) {
        this.zzReader = in;
    }

    public TemplateLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 1682) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public Token nextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block61: while (true) {
            int zzInput;
            int zzCurrentPosL;
            int zzMarkedPosL = this.zzMarkedPos;
            boolean zzR = false;
            block62: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; ++zzCurrentPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = false;
                        continue block62;
                    }
                    case '\r': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = true;
                        continue block62;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            continue block62;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block62;
                    }
                    default: {
                        zzR = false;
                        ++this.yycolumn;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    boolean eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 4: {
                    this.text.append("\t");
                }
                case 23: {
                    continue block61;
                }
                case 21: {
                    this.fieldNumber = this.readInteger(this.yytext(), 1, 1);
                    this.field.setLength(0);
                    this.yybegin(1);
                }
                case 24: {
                    continue block61;
                }
                case 1: {
                    this.text.append(this.yytext());
                }
                case 25: {
                    continue block61;
                }
                case 17: {
                    if (this.braceCount == 0) {
                        this.yybegin(0);
                        return this.token(7, this.fieldNumber, this.field.toString());
                    }
                    this.field.append("}");
                    --this.braceCount;
                }
                case 26: {
                    continue block61;
                }
                case 3: {
                    this.text.append("\n");
                }
                case 27: {
                    continue block61;
                }
                case 9: {
                    this.field.append("\r");
                }
                case 28: {
                    continue block61;
                }
                case 6: {
                    this.field.append(this.yytext());
                }
                case 29: {
                    continue block61;
                }
                case 14: {
                    this.text.append("$\t");
                }
                case 30: {
                    continue block61;
                }
                case 18: {
                    this.text.append(this.unEscape(this.yytext()));
                }
                case 31: {
                    continue block61;
                }
                case 10: {
                    this.yybegin(0);
                    return this.token(4, this.fieldNumber, this.field.toString());
                }
                case 32: {
                    continue block61;
                }
                case 13: {
                    this.text.append("$\n");
                    this.yybegin(0);
                }
                case 33: {
                    continue block61;
                }
                case 8: {
                    this.field.append("\t");
                }
                case 34: {
                    continue block61;
                }
                case 7: {
                    this.field.append("\n");
                }
                case 35: {
                    continue block61;
                }
                case 12: {
                    this.yybegin(0);
                    return this.token(5, new Integer(this.yytext()));
                }
                case 36: {
                    continue block61;
                }
                case 2: {
                    this.yybegin(2);
                    if (this.text.length() != 0) {
                        Token t = this.token(1, this.text.toString());
                        this.text.setLength(0);
                        return t;
                    }
                    this.text.setLength(0);
                }
                case 37: {
                    continue block61;
                }
                case 5: {
                    this.text.append("\r");
                }
                case 38: {
                    continue block61;
                }
                case 22: {
                    this.fieldNumber = this.readInteger(this.yytext(), 1, 1);
                    this.field.setLength(0);
                    this.yybegin(3);
                }
                case 39: {
                    continue block61;
                }
                case 16: {
                    ++this.braceCount;
                    this.field.append("{");
                }
                case 40: {
                    continue block61;
                }
                case 11: {
                    this.text.append("$" + this.yytext());
                    this.yybegin(0);
                }
                case 41: {
                    continue block61;
                }
                case 20: {
                    this.yybegin(0);
                    return this.token(6);
                }
                case 42: {
                    continue block61;
                }
                case 15: {
                    this.text.append("$\r");
                }
                case 43: {
                    continue block61;
                }
                case 19: {
                    this.field.append(this.unEscape(this.yytext()));
                }
                case 44: {
                    continue block61;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                switch (this.zzLexicalState) {
                    case 2: {
                        if (this.end) {
                            return null;
                        }
                        this.end = true;
                        this.text.append("$");
                        return this.token(1, this.text.toString());
                    }
                    case 38: {
                        continue block61;
                    }
                    case 0: {
                        if (this.end || this.text.length() == 0) {
                            return null;
                        }
                        this.end = true;
                        return this.token(1, this.text.toString());
                    }
                    case 39: {
                        continue block61;
                    }
                    case 3: {
                        if (this.end || this.field.length() == 0) {
                            return null;
                        }
                        this.end = true;
                        return this.token(7, this.fieldNumber, this.field.toString());
                    }
                    case 40: {
                        continue block61;
                    }
                    case 1: {
                        if (this.end || this.field.length() == 0) {
                            return null;
                        }
                        this.end = true;
                        return this.token(4, this.fieldNumber, this.field.toString());
                    }
                    case 41: {
                        continue block61;
                    }
                }
                return null;
            }
            this.zzScanError(1);
        }
    }
}

