/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.lexer;

import java.io.IOException;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.ParseException;
import org.gjt.sp.jedit.bsh.TargetError;
import superabbrevs.SuperAbbrevsIO;
import superabbrevs.TextUtil;
import superabbrevs.lexer.TemplateGeneratorLexer;
import superabbrevs.lexer.Token;

public class TemplateGeneratorParser {
    private TemplateGeneratorLexer lexer;
    private Interpreter interpreter;

    public TemplateGeneratorParser(TemplateGeneratorLexer lexer, Interpreter interpreter) {
        this.lexer = lexer;
        this.interpreter = interpreter;
    }

    public String parse() throws TargetError, ParseException, EvalError, IOException {
        Token t;
        StringBuffer code = new StringBuffer();
        this.interpreter.source(SuperAbbrevsIO.getAbbrevsFunctionPath());
        this.interpreter.source(SuperAbbrevsIO.getTemplateGenerationFunctionPath());
        StringBuffer out = new StringBuffer();
        this.interpreter.set("_out", (Object)out);
        while (null != (t = this.lexer.nextToken())) {
            switch (t.getType()) {
                case 2: {
                    String outputField = t.getStringValue(0);
                    String whiteSpace = t.getStringValue(1);
                    if (whiteSpace != null) {
                        whiteSpace = TextUtil.escape(whiteSpace);
                        code.append("_out.append(_indent(\"" + whiteSpace + "\"," + outputField + "));\n");
                        break;
                    }
                    code.append("_out.append(" + outputField + ");\n");
                    break;
                }
                case 3: {
                    code.append(t.getValue(0) + "\n");
                    break;
                }
                case 1: {
                    code.append("_out.append(\"" + TextUtil.escape((String)t.getValue(0)) + "\");\n");
                }
            }
        }
        this.interpreter.eval(code.toString());
        return out.toString();
    }
}

