/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import superabbrevs.SuperAbbrevs;
import superabbrevs.gui.VariablesModel;

public class VariablesOptionPane
extends AbstractOptionPane {
    private JComboBox setsComboBox;
    private JTable variablesTable;
    private VariablesModel variablesModel;
    private JButton add;
    private JButton remove;
    private View view;

    public VariablesOptionPane(View view) {
        super("superabbrevs.variables");
        this.view = view;
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        ActionHandler actionHandler = new ActionHandler();
        this.variablesModel = new VariablesModel(SuperAbbrevs.loadVariables());
        this.variablesTable = new JTable(this.variablesModel);
        this.variablesTable.getColumnModel().getColumn(1).setCellRenderer(new Renderer());
        this.variablesTable.getTableHeader().setReorderingAllowed(false);
        this.variablesTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.variablesTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.variablesTable.getSelectionModel().setSelectionMode(0);
        Dimension d = this.variablesTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.variablesTable);
        scroller.setPreferredSize(d);
        this.add("Center", scroller);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(6, 0, 0, 0));
        this.add = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        this.add.setToolTipText(jEdit.getProperty((String)"options.abbrevs.add"));
        this.add.addActionListener(actionHandler);
        buttons.add(this.add);
        this.remove = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty((String)"options.abbrevs.remove"));
        this.remove.addActionListener(actionHandler);
        buttons.add(this.remove);
        buttons.add(Box.createGlue());
        this.add("South", buttons);
        this.variablesTable.getColumnModel().getColumn(0).setMinWidth(100);
        this.variablesTable.getColumnModel().getColumn(1).setPreferredWidth(550);
        this.updateEnabled();
    }

    protected void _save() {
        if (this.variablesTable.getCellEditor() != null) {
            this.variablesTable.getCellEditor().stopCellEditing();
        }
        SuperAbbrevs.saveVariables(this.variablesModel.toHashtable());
    }

    private void updateEnabled() {
        int selectedRow = this.variablesTable.getSelectedRow();
        this.remove.setEnabled(selectedRow != -1);
    }

    private void add(VariablesModel variablesModel, String name, String value) {
        for (int i = 0; i < variablesModel.getRowCount(); ++i) {
            if (!variablesModel.getValueAt(i, 0).equals(name)) continue;
            variablesModel.remove(i);
            break;
        }
        variablesModel.add(name, value);
        this.updateEnabled();
    }

    static class Renderer
    extends DefaultTableCellRenderer {
        Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
            String valueStr = value.toString();
            if (valueStr.toLowerCase().startsWith("<html>")) {
                valueStr = " " + valueStr;
            }
            return super.getTableCellRendererComponent(table, valueStr, isSelected, cellHasFocus, row, col);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            VariablesModel variablesModel = (VariablesModel)VariablesOptionPane.this.variablesTable.getModel();
            Object source = evt.getSource();
            if (source == VariablesOptionPane.this.add) {
                VariablesOptionPane.this.add(variablesModel, "", "");
            } else if (source == VariablesOptionPane.this.remove) {
                int selectedRow = VariablesOptionPane.this.variablesTable.getSelectedRow();
                variablesModel.remove(selectedRow);
                VariablesOptionPane.this.updateEnabled();
            }
        }
    }

    class SelectionHandler
    implements ListSelectionListener {
        SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            VariablesOptionPane.this.updateEnabled();
        }
    }

    class HeaderMouseHandler
    extends MouseAdapter {
        HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            switch (VariablesOptionPane.this.variablesTable.getTableHeader().columnAtPoint(evt.getPoint())) {
                case 0: {
                    ((VariablesModel)VariablesOptionPane.this.variablesTable.getModel()).sort(0);
                    break;
                }
                case 1: {
                    ((VariablesModel)VariablesOptionPane.this.variablesTable.getModel()).sort(1);
                }
            }
        }
    }
}

