/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.gui;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;
import superabbrevs.gui.Variable;

class VariablesModel
extends AbstractTableModel {
    Vector variables = new Vector();
    int lastSort;

    VariablesModel(Hashtable variablesHash) {
        if (variablesHash != null) {
            Enumeration nameEnum = variablesHash.keys();
            Enumeration valueEnum = variablesHash.elements();
            while (nameEnum.hasMoreElements()) {
                this.variables.addElement(new Variable((String)nameEnum.nextElement(), (String)valueEnum.nextElement()));
            }
            this.sort(0);
        }
    }

    public Class getColumnClass(int columnIndex) {
        return "String".getClass();
    }

    void sort(int col) {
        this.lastSort = col;
        Collections.sort(this.variables, new VariableCompare(col));
        this.fireTableDataChanged();
    }

    void add(String name, String value) {
        this.variables.addElement(new Variable(name, value));
        this.sort(this.lastSort);
    }

    void remove(int index) {
        this.variables.removeElementAt(index);
        this.fireTableStructureChanged();
    }

    public Hashtable toHashtable() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable = (Variable)this.variables.elementAt(i);
            if (variable.name.length() <= 0 || variable.value.length() <= 0) continue;
            hash.put(variable.name, variable.value);
        }
        return hash;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.variables.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Variable variable = (Variable)this.variables.elementAt(row);
        switch (col) {
            case 0: {
                return variable.name;
            }
            case 1: {
                return variable.value;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            value = "";
        }
        Variable variable = (Variable)this.variables.elementAt(row);
        if (col == 0) {
            variable.name = (String)value;
        } else {
            variable.value = (String)value;
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty((String)"options.superabbrevs.variables.variable");
            }
            case 1: {
                return jEdit.getProperty((String)"options.superabbrevs.variables.value");
            }
        }
        return null;
    }

    class VariableCompare
    implements Comparator {
        private int col;

        public int getCol() {
            return this.col;
        }

        VariableCompare(int col) {
            this.col = col;
        }

        public int compare(Object obj1, Object obj2) {
            Variable v1 = (Variable)obj1;
            Variable v2 = (Variable)obj2;
            if (this.col == 0) {
                String name1 = v1.name.toLowerCase();
                String name2 = v2.name.toLowerCase();
                return StandardUtilities.compareStrings((String)name1, (String)name2, (boolean)true);
            }
            String value1 = v1.value.toLowerCase();
            String value2 = v2.value.toLowerCase();
            return StandardUtilities.compareStrings((String)value1, (String)value2, (boolean)true);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof VariableCompare)) {
                return false;
            }
            VariableCompare variableCompare = (VariableCompare)obj;
            return this.col == variableCompare.col;
        }
    }
}

