/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;
import superabbrevs.gui.AbbrevEditor;

public class EditAbbrevDialog
extends JDialog {
    private AbbrevEditor editor;
    private JButton ok;
    private JButton cancel;
    private boolean isOK;
    private String originalAbbrev;
    private Map abbrevs;

    public EditAbbrevDialog(Frame frame, String abbrev, String expansion, Map abbrevs) {
        super(frame, jEdit.getProperty((String)"edit-abbrev.title"), true);
        this.init(abbrev, expansion, abbrevs);
    }

    public EditAbbrevDialog(Dialog dialog, String abbrev, String expansion, Map abbrevs) {
        super(dialog, jEdit.getProperty((String)"edit-abbrev.title"), true);
        this.init(abbrev, expansion, abbrevs);
    }

    public String getAbbrev() {
        if (!this.isOK) {
            return null;
        }
        return this.editor.getAbbrev();
    }

    public String getExpansion() {
        if (!this.isOK) {
            return null;
        }
        return this.editor.getExpansion();
    }

    private void init(String abbrev, String expansion, Map abbrevs) {
        this.abbrevs = abbrevs;
        this.originalAbbrev = abbrev;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        this.editor = new AbbrevEditor();
        this.editor.setAbbrev(abbrev);
        this.editor.setExpansion(expansion);
        this.editor.setBorder(new EmptyBorder(0, 0, 12, 0));
        content.add("Center", this.editor);
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty((String)"common.ok"));
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        box.add(this.ok);
        box.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        box.add(this.cancel);
        box.add(Box.createGlue());
        content.add("South", box);
        KeyHandler listener = new KeyHandler();
        this.addKeyListener(listener);
        this.editor.getTemplateTextArea().addKeyListener(listener);
        this.ok.setMnemonic(79);
        this.cancel.setMnemonic(67);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private boolean checkForExistingAbbrev() {
        String abbrev = this.editor.getAbbrev();
        if (this.abbrevs.get(abbrev) != null) {
            if (abbrev.equals(this.originalAbbrev)) {
                return true;
            }
            int result = GUIUtilities.confirm((Component)this, (String)"edit-abbrev.duplicate", null, (int)0, (int)2);
            return result == 0;
        }
        return true;
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 27) {
                EditAbbrevDialog.this.dispose();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == EditAbbrevDialog.this.ok) {
                if (EditAbbrevDialog.this.editor.getAbbrev() == null || EditAbbrevDialog.this.editor.getAbbrev().length() == 0) {
                    EditAbbrevDialog.this.getToolkit().beep();
                    return;
                }
                if (!EditAbbrevDialog.this.checkForExistingAbbrev()) {
                    return;
                }
                EditAbbrevDialog.this.isOK = true;
            }
            EditAbbrevDialog.this.dispose();
        }
    }
}

