/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import superabbrevs.SuperAbbrevs;
import superabbrevs.gui.AbbrevEditor;

public class AddAbbrevDialog
extends JDialog {
    private View view;
    private AbbrevEditor editor;
    private JButton global;
    private JButton modeSpecific;
    private JButton cancel;
    private String abbrev;

    public AddAbbrevDialog(View view, String abbrev, String expandsion) {
        super((Frame)view, jEdit.getProperty((String)"add-abbrev.title"), true);
        this.abbrev = abbrev;
        this.view = view;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        this.editor = new AbbrevEditor();
        this.editor.setAbbrev(abbrev);
        this.editor.setBorder(new EmptyBorder(6, 0, 12, 0));
        this.editor.setExpansion(expandsion);
        content.add("Center", this.editor);
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.global = new JButton(jEdit.getProperty((String)"add-abbrev.global"));
        this.global.addActionListener(new ActionHandler());
        box.add(this.global);
        box.add(Box.createHorizontalStrut(6));
        this.modeSpecific = new JButton(jEdit.getProperty((String)"add-abbrev.mode"));
        this.modeSpecific.addActionListener(new ActionHandler());
        box.add(this.modeSpecific);
        box.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        box.add(this.cancel);
        box.add(Box.createGlue());
        content.add("South", box);
        KeyHandler listener = new KeyHandler();
        this.addKeyListener(listener);
        this.editor.getTemplateTextArea().addKeyListener(listener);
        this.setDefaultCloseOperation(2);
        if (abbrev == null) {
            GUIUtilities.requestFocus((Window)this, (Component)this.editor.getAbbrevField());
        } else {
            GUIUtilities.requestFocus((Window)this, (Component)this.editor.getTemplateTextArea());
        }
        this.modeSpecific.setMnemonic(77);
        this.global.setMnemonic(71);
        this.cancel.setMnemonic(67);
        this.pack();
        this.setLocationRelativeTo((Component)view);
        this.setVisible(true);
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 27) {
                AddAbbrevDialog.this.dispose();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == AddAbbrevDialog.this.cancel) {
                AddAbbrevDialog.this.dispose();
                return;
            }
            String _abbrev = AddAbbrevDialog.this.editor.getAbbrev();
            if (_abbrev == null || _abbrev.length() == 0) {
                AddAbbrevDialog.this.getToolkit().beep();
                return;
            }
            if (source == AddAbbrevDialog.this.global) {
                SuperAbbrevs.addGlobalAbbrev(_abbrev, AddAbbrevDialog.this.editor.getExpansion());
            } else if (source == AddAbbrevDialog.this.modeSpecific) {
                SuperAbbrevs.addModeAbbrev(AddAbbrevDialog.this.view.getBuffer().getMode().getName(), _abbrev, AddAbbrevDialog.this.editor.getExpansion());
            }
            if (_abbrev.equals(AddAbbrevDialog.this.abbrev)) {
                SuperAbbrevs.expandAbbrev(AddAbbrevDialog.this.view);
            }
            AddAbbrevDialog.this.dispose();
        }
    }
}

