/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import superabbrevs.SuperAbbrevs;
import superabbrevs.SuperAbbrevsIO;
import superabbrevs.gui.Abbrev;
import superabbrevs.gui.AbbrevsModel;
import superabbrevs.gui.EditAbbrevDialog;

public class AbbrevsOptionPane
extends AbstractOptionPane {
    private JComboBox setsComboBox;
    private JTable abbrevsTable;
    private Hashtable modeAbbrevs;
    private JButton add;
    private JButton edit;
    private JButton remove;
    private JButton importFromFile;
    private JButton exportToFile;
    private JButton importAbbrevs;
    private View view;

    public AbbrevsOptionPane(View view) {
        super("superabbrevs.abbreviations");
        this.view = view;
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        JPanel abbrevsSetPanel = new JPanel();
        JLabel label = new JLabel(jEdit.getProperty((String)"options.superabbrevs.mode"));
        label.setDisplayedMnemonic('S');
        label.setBorder(new EmptyBorder(0, 0, 0, 12));
        abbrevsSetPanel.add(label);
        this.modeAbbrevs = new Hashtable();
        Mode[] modes = jEdit.getModes();
        Arrays.sort(modes, new StandardUtilities.StringCompare(true));
        String[] sets = new String[modes.length + 1];
        sets[0] = "global";
        this.modeAbbrevs.put(sets[0], new AbbrevsModel(SuperAbbrevs.loadAbbrevs(sets[0])));
        int selectedIndex = 0;
        String mode = this.view.getBuffer().getMode().getName();
        for (int i = 0; i < modes.length; ++i) {
            String name;
            sets[i + 1] = name = modes[i].getName();
            this.modeAbbrevs.put(name, new AbbrevsModel(SuperAbbrevs.loadAbbrevs(name)));
            if (!name.equals(mode)) continue;
            selectedIndex = i + 1;
        }
        this.setsComboBox = new JComboBox<String>(sets);
        label.setLabelFor(this.setsComboBox);
        ActionHandler actionHandler = new ActionHandler();
        this.setsComboBox.addActionListener(actionHandler);
        abbrevsSetPanel.add(this.setsComboBox);
        this.add("North", abbrevsSetPanel);
        this.abbrevsTable = new JTable((AbbrevsModel)this.modeAbbrevs.get("global"));
        this.abbrevsTable.getColumnModel().getColumn(1).setCellRenderer(new Renderer());
        this.abbrevsTable.getTableHeader().setReorderingAllowed(false);
        this.abbrevsTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.abbrevsTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.abbrevsTable.getSelectionModel().setSelectionMode(2);
        this.abbrevsTable.addMouseListener(new TableMouseHandler());
        Dimension d = this.abbrevsTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.abbrevsTable);
        scroller.setPreferredSize(d);
        this.add("Center", scroller);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(6, 0, 0, 0));
        this.add = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        this.add.setToolTipText(jEdit.getProperty((String)"options.abbrevs.add"));
        this.add.addActionListener(actionHandler);
        buttons.add(this.add);
        this.remove = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty((String)"options.abbrevs.remove"));
        this.remove.addActionListener(actionHandler);
        buttons.add(this.remove);
        this.edit = new RolloverButton(GUIUtilities.loadIcon((String)"ButtonProperties.png"));
        this.edit.setToolTipText(jEdit.getProperty((String)"options.abbrevs.edit"));
        this.edit.addActionListener(actionHandler);
        buttons.add(this.edit);
        buttons.add(Box.createGlue());
        this.importFromFile = new RolloverButton(GUIUtilities.loadIcon((String)"PreviousFile.png"));
        this.importFromFile.setToolTipText("Import from file");
        this.importFromFile.addActionListener(actionHandler);
        buttons.add(this.importFromFile);
        this.exportToFile = new RolloverButton(GUIUtilities.loadIcon((String)"NextFile.png"));
        this.exportToFile.setToolTipText("Export to file");
        this.exportToFile.addActionListener(actionHandler);
        buttons.add(this.exportToFile);
        this.importAbbrevs = new JButton("Import normal abbrevs");
        this.importAbbrevs.addActionListener(actionHandler);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add("West", buttons);
        bottomPanel.add("East", new JPanel().add(this.importAbbrevs));
        this.add("South", bottomPanel);
        this.setsComboBox.setSelectedIndex(selectedIndex);
        this.abbrevsTable.getColumnModel().getColumn(0).setMinWidth(100);
        this.abbrevsTable.getColumnModel().getColumn(1).setPreferredWidth(550);
        this.updateEnabled();
    }

    protected void _save() {
        if (this.abbrevsTable.getCellEditor() != null) {
            this.abbrevsTable.getCellEditor().stopCellEditing();
        }
        Enumeration keys = this.modeAbbrevs.keys();
        Enumeration values = this.modeAbbrevs.elements();
        while (keys.hasMoreElements()) {
            SuperAbbrevs.saveAbbrevs((String)keys.nextElement(), ((AbbrevsModel)values.nextElement()).toHashtable());
        }
    }

    private void updateEnabled() {
        int selectedRow = this.abbrevsTable.getSelectedRow();
        this.edit.setEnabled(selectedRow != -1);
        this.remove.setEnabled(selectedRow != -1);
        this.exportToFile.setEnabled(selectedRow != -1);
    }

    private void edit() {
        AbbrevsModel abbrevsModel = (AbbrevsModel)this.abbrevsTable.getModel();
        int row = this.abbrevsTable.getSelectedRow();
        String abbrev = (String)abbrevsModel.getValueAt(row, 0);
        String expansion = (String)abbrevsModel.getValueAt(row, 1);
        String oldAbbrev = abbrev;
        EditAbbrevDialog dialog = new EditAbbrevDialog((Dialog)GUIUtilities.getParentDialog((Component)((Object)this)), abbrev, expansion, (Map)abbrevsModel.toHashtable());
        abbrev = dialog.getAbbrev();
        expansion = dialog.getExpansion();
        if (abbrev != null && expansion != null) {
            for (int i = 0; i < abbrevsModel.getRowCount(); ++i) {
                if (!abbrevsModel.getValueAt(i, 0).equals(oldAbbrev)) continue;
                abbrevsModel.remove(i);
                break;
            }
            this.add(abbrevsModel, abbrev, expansion);
        }
    }

    private void add(AbbrevsModel abbrevsModel, String abbrev, String expansion) {
        for (int i = 0; i < abbrevsModel.getRowCount(); ++i) {
            if (!abbrevsModel.getValueAt(i, 0).equals(abbrev)) continue;
            abbrevsModel.remove(i);
            break;
        }
        abbrevsModel.add(abbrev, expansion);
        this.updateEnabled();
    }

    private void importAbbrevs() {
        if (this.abbrevsTable.getCellEditor() != null) {
            this.abbrevsTable.getCellEditor().stopCellEditing();
        }
        Enumeration modes = Abbrevs.getModeAbbrevs().keys();
        while (modes.hasMoreElements()) {
            String mode = (String)modes.nextElement();
            this.importAbbrevs(mode);
        }
        this.importAbbrevs("global");
        String selectedMode = (String)this.setsComboBox.getSelectedItem();
        this.abbrevsTable.setModel((AbbrevsModel)this.modeAbbrevs.get(selectedMode));
    }

    private void importAbbrevs(String mode) {
        Hashtable<String, String> superModeAbbrevs = ((AbbrevsModel)this.modeAbbrevs.get(mode)).toHashtable();
        if (superModeAbbrevs == null) {
            superModeAbbrevs = new Hashtable<String, String>();
        }
        Hashtable normalModeAbbrevs = mode.equals("global") ? Abbrevs.getGlobalAbbrevs() : (Hashtable)Abbrevs.getModeAbbrevs().get(mode);
        Enumeration abbrevs = normalModeAbbrevs.keys();
        while (abbrevs.hasMoreElements()) {
            String abbrev = (String)abbrevs.nextElement();
            if (superModeAbbrevs.containsKey(abbrev)) continue;
            String abbrevExpand = (String)normalModeAbbrevs.get(abbrev);
            abbrevExpand = abbrevExpand.replaceFirst("\\\\[|]", "\\$end");
            abbrevExpand = abbrevExpand.replaceAll("\\\\n", "\n");
            abbrevExpand = abbrevExpand.replaceAll("\\\\t", "\t");
            superModeAbbrevs.put(abbrev, abbrevExpand);
        }
        AbbrevsModel model = new AbbrevsModel(superModeAbbrevs);
        this.modeAbbrevs.put(mode, model);
    }

    private void importFromFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileHidingEnabled(false);
        int returnValue = fileChooser.showOpenDialog((Component)jEdit.getActiveView());
        if (returnValue == 0) {
            File file = fileChooser.getSelectedFile();
            Hashtable importedAbbrevs = SuperAbbrevsIO.readObjectFile(file);
            AbbrevsModel abbrevsModel = (AbbrevsModel)this.abbrevsTable.getModel();
            Iterator iter = importedAbbrevs.keySet().iterator();
            while (iter.hasNext()) {
                String abbrev = iter.next().toString();
                String expansion = (String)importedAbbrevs.get(abbrev);
                this.add(abbrevsModel, abbrev, expansion);
            }
        }
    }

    private void exportToFile(int[] index) {
        Log.log((int)1, (Object)((Object)this), (Object)"Exporting Abbrevs");
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileHidingEnabled(false);
        int returnValue = fileChooser.showSaveDialog((Component)jEdit.getActiveView());
        if (returnValue == 0) {
            Hashtable<String, String> hashTable = new Hashtable<String, String>();
            AbbrevsModel abbrevsModel = (AbbrevsModel)this.abbrevsTable.getModel();
            for (int i = 0; i < index.length; ++i) {
                Abbrev abbrev = (Abbrev)abbrevsModel.abbrevs.get(i);
                hashTable.put(abbrev.abbrev, abbrev.expand);
            }
            File file = fileChooser.getSelectedFile();
            SuperAbbrevsIO.writeObjectFile(file, hashTable);
        }
    }

    static class Renderer
    extends DefaultTableCellRenderer {
        Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
            String valueStr = value.toString();
            if (valueStr.toLowerCase().startsWith("<html>")) {
                valueStr = " " + valueStr;
            }
            return super.getTableCellRendererComponent(table, valueStr, isSelected, cellHasFocus, row, col);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbbrevsModel abbrevsModel = (AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel();
            Object source = evt.getSource();
            if (source == AbbrevsOptionPane.this.setsComboBox) {
                String selected = (String)AbbrevsOptionPane.this.setsComboBox.getSelectedItem();
                AbbrevsOptionPane.this.abbrevsTable.setModel((AbbrevsModel)AbbrevsOptionPane.this.modeAbbrevs.get(selected));
                AbbrevsOptionPane.this.updateEnabled();
            } else if (source == AbbrevsOptionPane.this.add) {
                EditAbbrevDialog dialog = new EditAbbrevDialog((Dialog)GUIUtilities.getParentDialog((Component)((Object)AbbrevsOptionPane.this)), null, null, (Map)abbrevsModel.toHashtable());
                String abbrev = dialog.getAbbrev();
                String expansion = dialog.getExpansion();
                if (abbrev != null && abbrev.length() != 0 && expansion != null && expansion.length() != 0) {
                    AbbrevsOptionPane.this.add(abbrevsModel, abbrev, expansion);
                }
            } else if (source == AbbrevsOptionPane.this.edit) {
                AbbrevsOptionPane.this.edit();
            } else if (source == AbbrevsOptionPane.this.remove) {
                abbrevsModel.remove(AbbrevsOptionPane.this.abbrevsTable.getSelectedRows());
                AbbrevsOptionPane.this.updateEnabled();
            } else if (source == AbbrevsOptionPane.this.importAbbrevs) {
                AbbrevsOptionPane.this.importAbbrevs();
            } else if (source == AbbrevsOptionPane.this.importFromFile) {
                AbbrevsOptionPane.this.importFromFile();
                AbbrevsOptionPane.this.updateEnabled();
            } else if (source == AbbrevsOptionPane.this.exportToFile) {
                AbbrevsOptionPane.this.exportToFile(AbbrevsOptionPane.this.abbrevsTable.getSelectedRows());
                AbbrevsOptionPane.this.updateEnabled();
            }
        }
    }

    class SelectionHandler
    implements ListSelectionListener {
        SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            AbbrevsOptionPane.this.updateEnabled();
        }
    }

    class TableMouseHandler
    extends MouseAdapter {
        TableMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                AbbrevsOptionPane.this.edit();
            }
        }
    }

    class HeaderMouseHandler
    extends MouseAdapter {
        HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            switch (AbbrevsOptionPane.this.abbrevsTable.getTableHeader().columnAtPoint(evt.getPoint())) {
                case 0: {
                    ((AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel()).sort(0);
                    break;
                }
                case 1: {
                    ((AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel()).sort(1);
                }
            }
        }
    }
}

