/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.gui;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;
import superabbrevs.gui.Abbrev;

class AbbrevsModel
extends AbstractTableModel {
    Vector abbrevs = new Vector();
    int lastSort;

    AbbrevsModel(Hashtable abbrevHash) {
        if (abbrevHash != null) {
            Enumeration abbrevEnum = abbrevHash.keys();
            Enumeration expandEnum = abbrevHash.elements();
            while (abbrevEnum.hasMoreElements()) {
                this.abbrevs.addElement(new Abbrev((String)abbrevEnum.nextElement(), (String)expandEnum.nextElement()));
            }
            this.sort(0);
        }
    }

    void sort(int col) {
        this.lastSort = col;
        Collections.sort(this.abbrevs, new AbbrevCompare(col));
        this.fireTableDataChanged();
    }

    void add(String abbrev, String expansion) {
        this.abbrevs.addElement(new Abbrev(abbrev, expansion));
        this.sort(this.lastSort);
    }

    void remove(int[] index) {
        int shiftet = 0;
        for (int i = 0; i < index.length; ++i) {
            this.abbrevs.removeElementAt(index[i] - shiftet);
            ++shiftet;
        }
        this.fireTableStructureChanged();
    }

    void remove(int index) {
        this.abbrevs.removeElementAt(index);
        this.fireTableStructureChanged();
    }

    public Hashtable toHashtable() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (int i = 0; i < this.abbrevs.size(); ++i) {
            Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(i);
            if (abbrev.abbrev.length() <= 0 || abbrev.expand.length() <= 0) continue;
            hash.put(abbrev.abbrev, abbrev.expand);
        }
        return hash;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.abbrevs.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(row);
        switch (col) {
            case 0: {
                return abbrev.abbrev;
            }
            case 1: {
                return abbrev.expand;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            value = "";
        }
        Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(row);
        if (col == 0) {
            abbrev.abbrev = (String)value;
        } else {
            abbrev.expand = (String)value;
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty((String)"options.superabbrevs.abbreviations.abbrev");
            }
            case 1: {
                return jEdit.getProperty((String)"options.superabbrevs.abbreviations.expand");
            }
        }
        return null;
    }

    class AbbrevCompare
    implements Comparator {
        private int col;

        public int getCol() {
            return this.col;
        }

        AbbrevCompare(int col) {
            this.col = col;
        }

        public int compare(Object obj1, Object obj2) {
            Abbrev a1 = (Abbrev)obj1;
            Abbrev a2 = (Abbrev)obj2;
            if (this.col == 0) {
                String abbrev1 = a1.abbrev.toLowerCase();
                String abbrev2 = a2.abbrev.toLowerCase();
                return StandardUtilities.compareStrings((String)abbrev1, (String)abbrev2, (boolean)true);
            }
            String expand1 = a1.expand.toLowerCase();
            String expand2 = a2.expand.toLowerCase();
            return StandardUtilities.compareStrings((String)expand1, (String)expand2, (boolean)true);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof AbbrevCompare)) {
                return false;
            }
            AbbrevCompare abbrevCompare = (AbbrevCompare)obj;
            return this.col == abbrevCompare.col;
        }
    }
}

