/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs;

import java.util.Hashtable;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import superabbrevs.Handler;
import superabbrevs.template.SelectableField;
import superabbrevs.template.Template;

public class TemplateCaretListener
implements CaretListener {
    private static Hashtable caretListeners = new Hashtable();

    @Override
    public void caretUpdate(CaretEvent e) {
        JEditTextArea textArea = (JEditTextArea)e.getSource();
        View view = textArea.getView();
        Buffer buffer = view.getBuffer();
        Handler handler = Handler.getHandler((JEditBuffer)buffer);
        if (handler != null) {
            if (!handler.isDisabled()) {
                int caret;
                Template template = handler.getTemplate();
                if (handler.justEdited()) {
                    handler.postEdit();
                }
                if (!template.inCurrentField(caret = textArea.getCaretPosition())) {
                    SelectableField f = template.getCurrentField();
                    Handler.removeHandler((JEditBuffer)buffer);
                    TemplateCaretListener.removeCaretListener(textArea);
                }
            }
        } else {
            TemplateCaretListener.removeCaretListener(textArea);
        }
    }

    public static void putCaretListener(JEditTextArea textArea, TemplateCaretListener l) {
        textArea.removeCaretListener((CaretListener)TemplateCaretListener.getCaretListener(textArea));
        caretListeners.put(textArea, l);
        textArea.addCaretListener((CaretListener)l);
    }

    public static TemplateCaretListener getCaretListener(JEditTextArea textArea) {
        return (TemplateCaretListener)caretListeners.get(textArea);
    }

    public static TemplateCaretListener removeCaretListener(JEditTextArea textArea) {
        TemplateCaretListener l = TemplateCaretListener.getCaretListener(textArea);
        textArea.removeCaretListener((CaretListener)l);
        caretListeners.remove(textArea);
        return l;
    }
}

