/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Hashtable;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class SuperAbbrevsIO {
    private static final String ABBREVS_DIR = MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"SuperAbbrevs");
    private static final String MACRO_DIR = MiscUtilities.constructPath((String)MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"macros"), (String)"SuperAbbrevs");
    private static final String RESOURCE_DIR = "resources";
    public static final String ABBREVS_FUNCTION_FILE = "abbrev_functions.bsh";
    public static final String TEMPLATE_GENERATION_FUNCTION_FILE = "template_generation_functions.bsh";
    public static final String VARIABLES_FILE = "global.variables";

    public static Hashtable readModeFile(String name) {
        return SuperAbbrevsIO.readObjectFile(SuperAbbrevsIO.getModeFile(name));
    }

    public static void writeModeFile(String mode, Hashtable data) {
        File modeFile = SuperAbbrevsIO.getModeFile(mode);
        if (data != null && (!data.isEmpty() || modeFile.exists())) {
            SuperAbbrevsIO.writeObjectFile(modeFile, data);
        }
    }

    private static File getModeFile(String name) {
        File modeDir = new File(ABBREVS_DIR);
        if (!modeDir.exists()) {
            modeDir.mkdir();
        }
        File modeFile = new File(MiscUtilities.constructPath((String)modeDir.toString(), (String)name));
        return modeFile;
    }

    private static void copy(URL url, File f) {
        try {
            InputStream in = url.openStream();
            FileOutputStream out = new FileOutputStream(f);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                out.write(buf, 0, i);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            Log.log((int)9, SuperAbbrevsIO.class, (Object)e);
        }
    }

    public static void removeOldMacros() {
        File macrosDir = new File(MACRO_DIR);
        if (macrosDir.exists()) {
            File tabFile = new File(MiscUtilities.constructPath((String)MACRO_DIR, (String)"tab.bsh"));
            tabFile.delete();
            File shiftTabFile = new File(MiscUtilities.constructPath((String)MACRO_DIR, (String)"shift-tab.bsh"));
            shiftTabFile.delete();
            macrosDir.delete();
        }
    }

    private static void copyFileFromResourceDir(String filename, boolean override) {
        URL url = SuperAbbrevsIO.getResource("resources/" + filename);
        String path = MiscUtilities.constructPath((String)ABBREVS_DIR, (String)filename);
        File file = new File(path);
        if (url != null && (override || !file.exists())) {
            SuperAbbrevsIO.copy(url, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeAbbrevs(String name, long lastModified) {
        File modeFile = SuperAbbrevsIO.getModeFile(name);
        if (!modeFile.exists()) {
            return;
        }
        if (modeFile.lastModified() < lastModified) {
            Hashtable hashtable = SuperAbbrevsIO.readModeFile(name);
            URL url = SuperAbbrevsIO.getResource("resources/" + name);
            if (url == null) {
                return;
            }
            ObjectInput input = null;
            try {
                InputStream in = url.openStream();
                input = new ObjectInputStream(in);
                Hashtable newTable = (Hashtable)input.readObject();
                hashtable.putAll(newTable);
                SuperAbbrevsIO.writeModeFile(name, hashtable);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void writeDefaultAbbrevs() {
        EditPlugin plugin = jEdit.getPlugin((String)"SuperAbbrevsPlugin");
        String path = plugin.getPluginJAR().getPath();
        File jar = new File(path);
        long lastModified = jar.lastModified();
        Mode[] modes = jEdit.getModes();
        for (int i = 0; i < modes.length; ++i) {
            String name = modes[i].getName();
            SuperAbbrevsIO.copyFileFromResourceDir(name, false);
            SuperAbbrevsIO.mergeAbbrevs(name, lastModified);
        }
    }

    public static void writeDefaultVariables() {
        SuperAbbrevsIO.copyFileFromResourceDir(VARIABLES_FILE, false);
    }

    public static void writeDefaultAbbrevFunctions() {
        SuperAbbrevsIO.copyFileFromResourceDir(ABBREVS_FUNCTION_FILE, false);
    }

    public static void writeDefaultTemplateGenerationFunctions() {
        SuperAbbrevsIO.copyFileFromResourceDir(TEMPLATE_GENERATION_FUNCTION_FILE, true);
    }

    public static String getAbbrevsFunctionPath() {
        return MiscUtilities.constructPath((String)ABBREVS_DIR, (String)TEMPLATE_GENERATION_FUNCTION_FILE);
    }

    public static String getTemplateGenerationFunctionPath() {
        return MiscUtilities.constructPath((String)ABBREVS_DIR, (String)ABBREVS_FUNCTION_FILE);
    }

    private static URL getResource(String filename) {
        return SuperAbbrevsIO.class.getClassLoader().getResource(filename);
    }

    public static boolean abbrevsDirExists() {
        File abbrevsDir = new File(ABBREVS_DIR);
        return abbrevsDir.exists();
    }

    public static void createAbbrevsDir() {
        if (!SuperAbbrevsIO.abbrevsDirExists()) {
            File abbrevsDir = new File(ABBREVS_DIR);
            abbrevsDir.mkdir();
        }
    }

    public static Hashtable readObjectFile(File file) {
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file);
                ObjectInputStream s = new ObjectInputStream(in);
                return (Hashtable)s.readObject();
            }
            catch (FileNotFoundException e) {
                Log.log((int)9, SuperAbbrevsIO.class, (Object)e);
            }
            catch (IOException e) {
                Log.log((int)9, SuperAbbrevsIO.class, (Object)e);
            }
            catch (ClassNotFoundException e) {
                Log.log((int)9, SuperAbbrevsIO.class, (Object)e);
            }
        }
        return null;
    }

    public static void writeObjectFile(File file, Object data) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            ObjectOutputStream s = new ObjectOutputStream(out);
            s.writeObject(data);
            s.flush();
        }
        catch (FileNotFoundException e) {
            Log.log((int)9, SuperAbbrevsIO.class, (Object)e);
        }
        catch (IOException e) {
            Log.log((int)9, SuperAbbrevsIO.class, (Object)e);
        }
    }
}

