/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs;

import java.awt.Component;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.ParseException;
import org.gjt.sp.jedit.bsh.TargetError;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import superabbrevs.Handler;
import superabbrevs.SuperAbbrevsIO;
import superabbrevs.TemplateCaretListener;
import superabbrevs.TemplateFactory;
import superabbrevs.gui.AddAbbrevDialog;
import superabbrevs.template.SelectableField;
import superabbrevs.template.Template;
import superabbrevs.zencoding.html.HTMLZenParser;
import superabbrevs.zencoding.html.MLSerializer;
import superabbrevs.zencoding.html.TokenMgrError;

public class SuperAbbrevs {
    private static Hashtable modeAbbrevs = new Hashtable();
    private static Hashtable variables = null;

    public static void addGlobalAbbrev(String abbrev, String expansion) {
        SuperAbbrevs.addModeAbbrev("global", abbrev, expansion);
    }

    public static void addModeAbbrev(String mode, String abbrev, String expansion) {
        Hashtable abbrevs = (Hashtable)modeAbbrevs.get(mode);
        if (abbrevs == null) {
            abbrevs = SuperAbbrevsIO.readModeFile(mode);
            if (abbrevs == null) {
                abbrevs = new Hashtable();
            }
            modeAbbrevs.put(mode, abbrevs);
        }
        abbrevs.put(abbrev, expansion);
        SuperAbbrevsIO.writeModeFile(mode, abbrevs);
    }

    public static void saveAbbrevs(String mode, Hashtable abbrevs) {
        modeAbbrevs.put(mode, abbrevs);
        SuperAbbrevsIO.writeModeFile(mode, abbrevs);
    }

    public static Hashtable loadAbbrevs(String mode) {
        Hashtable abbrevs = (Hashtable)modeAbbrevs.get(mode);
        if (abbrevs == null && (abbrevs = SuperAbbrevsIO.readModeFile(mode)) != null) {
            modeAbbrevs.put(mode, abbrevs);
        }
        return abbrevs;
    }

    private static String getTemplateString(String mode, String abbrev) {
        Hashtable abbrevs = SuperAbbrevs.loadAbbrevs(mode);
        if (abbrevs == null || !abbrevs.containsKey(abbrev)) {
            abbrevs = SuperAbbrevs.loadAbbrevs("global");
        }
        if (abbrevs != null) {
            return (String)abbrevs.get(abbrev);
        }
        return null;
    }

    public static void saveVariables(Hashtable variables) {
        SuperAbbrevs.variables = variables;
        SuperAbbrevsIO.writeModeFile("global.variables", variables);
    }

    public static Hashtable loadVariables() {
        if (variables == null) {
            variables = SuperAbbrevsIO.readModeFile("global.variables");
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tab(View view, JEditTextArea textArea, Buffer buffer) {
        if (!textArea.isEditable()) {
            textArea.getToolkit().beep();
        } else if (Handler.enabled(buffer)) {
            SuperAbbrevs.nextAbbrev(textArea, buffer);
        } else if (0 < textArea.getSelectionCount()) {
            textArea.insertTabAndIndent();
        } else {
            String mode = SuperAbbrevs.getMode(textArea, buffer);
            String abbrev = SuperAbbrevs.getAbbrev(textArea, buffer);
            String template = null;
            if (abbrev.trim().isEmpty()) {
                abbrev = SuperAbbrevs.getZenCodingAbbrevs((TextArea)textArea, buffer, mode);
                if (!abbrev.isEmpty() && (template = SuperAbbrevs.getZenCodingTemplate(abbrev, mode)) == null) {
                    textArea.insertTabAndIndent();
                    return;
                }
            } else {
                template = SuperAbbrevs.getTemplateString(mode, abbrev);
            }
            if (template == null && !(abbrev = SuperAbbrevs.getZenCodingAbbrevs((TextArea)textArea, buffer, mode)).isEmpty()) {
                template = SuperAbbrevs.getZenCodingTemplate(abbrev, mode);
            }
            if (template != null) {
                if (buffer.getBooleanProperty("noTabs")) {
                    int tabSize = buffer.getTabSize();
                    template = template.replaceAll("\t", SuperAbbrevs.spaces(tabSize));
                }
                try {
                    buffer.beginCompoundEdit();
                    SuperAbbrevs.removeAbbrev(textArea, buffer, abbrev);
                    Hashtable modeVariables = SuperAbbrevs.loadVariables();
                    SuperAbbrevs.expandAbbrev(view, template, modeVariables);
                }
                finally {
                    buffer.endCompoundEdit();
                }
            } else {
                textArea.insertTabAndIndent();
            }
        }
    }

    private static String getZenCodingTemplate(String abbrev, String mode) {
        String template = null;
        HTMLZenParser zenParser = new HTMLZenParser(new StringReader(abbrev));
        try {
            template = zenParser.parse(new MLSerializer(mode, jEdit.getProperties()));
        }
        catch (TokenMgrError e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return template;
    }

    @Nonnull
    private static String getZenCodingAbbrevs(TextArea textArea, Buffer buffer, CharSequence mode) {
        if (jEdit.getBooleanProperty((String)"options.superabbrevs.zencoding") && jEdit.getProperty((String)"options.superabbrevs.zencoding.modes").contains(mode)) {
            int caretLine = textArea.getCaretLine();
            int lineStartOffset = textArea.getLineStartOffset(caretLine);
            String abbrev = buffer.getText(lineStartOffset, textArea.getCaretPosition() - lineStartOffset).trim();
            for (int i = abbrev.length() - 1; i >= 0; --i) {
                if (!Character.isWhitespace(abbrev.charAt(i))) continue;
                abbrev = abbrev.substring(i);
                break;
            }
            return abbrev;
        }
        return "";
    }

    private static String spaces(int size) {
        StringBuilder buf = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static void shiftTab(View view, JEditTextArea textArea, Buffer buffer) {
        if (Handler.enabled(buffer)) {
            SuperAbbrevs.prevAbbrev(textArea, buffer);
        } else if (0 < textArea.getSelectionCount()) {
            textArea.shiftIndentLeft();
        } else {
            String abbrev = SuperAbbrevs.getAbbrev(textArea, buffer);
            if (abbrev.trim().isEmpty()) {
                textArea.shiftIndentLeft();
            } else {
                Hashtable abbrevs = SuperAbbrevs.loadAbbrevs(SuperAbbrevs.getMode(textArea, buffer));
                String expansion = "";
                if (abbrevs != null && abbrevs.get(abbrev) != null) {
                    expansion = (String)abbrevs.get(abbrev);
                }
                AddAbbrevDialog dialog = new AddAbbrevDialog(view, abbrev, expansion);
            }
        }
    }

    public static void expandAbbrev(View view) {
        Buffer buffer = view.getBuffer();
        JEditTextArea textArea = view.getTextArea();
        if (!textArea.isEditable()) {
            textArea.getToolkit().beep();
        } else if (Handler.enabled(buffer)) {
            textArea.getToolkit().beep();
        } else {
            String abbrev = SuperAbbrevs.getAbbrev(textArea, buffer);
            if (abbrev.trim().isEmpty()) {
                textArea.getToolkit().beep();
                return;
            }
            String mode = SuperAbbrevs.getMode(textArea, buffer);
            String template = SuperAbbrevs.getTemplateString(mode, abbrev);
            if (template != null) {
                SuperAbbrevs.removeAbbrev(textArea, buffer, abbrev);
                Hashtable modeVariables = SuperAbbrevs.loadVariables();
                SuperAbbrevs.expandAbbrev(view, template, modeVariables);
            } else {
                textArea.getToolkit().beep();
            }
        }
    }

    public static void expandAbbrev(View view, String template, Hashtable variables) {
        Buffer buffer = view.getBuffer();
        JEditTextArea textArea = view.getTextArea();
        int caretPos = textArea.getCaretPosition();
        String indent = SuperAbbrevs.getIndent(textArea, buffer);
        try {
            Interpreter interpreter = new Interpreter();
            String selection = "";
            if (textArea.getSelectionCount() == 1) {
                selection = textArea.getSelectedText();
                selection = selection.replaceAll("\\\\", "\\\\\\\\");
                textArea.setSelectedText("");
                caretPos = textArea.getCaretPosition();
            }
            interpreter.set("filename", (Object)buffer.getName());
            interpreter.set("selection", (Object)selection);
            SuperAbbrevs.putVariables(interpreter, variables);
            Template t = TemplateFactory.createTemplate(template, interpreter, indent);
            t.setOffset(caretPos);
            textArea.setSelectedText(t.toString(), false);
            SuperAbbrevs.selectField(textArea, t.getCurrentField());
            Handler h = new Handler(t, textArea, buffer);
            Handler.putHandler(buffer, h);
            TemplateCaretListener.putCaretListener(textArea, new TemplateCaretListener());
        }
        catch (TargetError e) {
            System.out.println("TargetError");
            System.out.println(e.getMessage());
        }
        catch (ParseException e) {
            System.out.println("ParseException");
            System.out.println(e.getMessage());
        }
        catch (EvalError e) {
            System.out.println("EvalError");
            System.out.println(e.getErrorLineNumber());
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println("IOException");
            System.out.println(e.getMessage());
        }
    }

    public static void showAbbrevDialog(View view, JEditTextArea textArea, Buffer buffer) {
        String mode;
        String template;
        if (!textArea.isEditable() || 1 < textArea.getSelectionCount() || Handler.enabled(buffer)) {
            textArea.getToolkit().beep();
            return;
        }
        String abbrev = JOptionPane.showInputDialog((Component)view, "Type in an abbreviation", "Abbreviation Input", 1);
        if (abbrev != null && !abbrev.trim().equals("") && (template = SuperAbbrevs.getTemplateString(mode = SuperAbbrevs.getMode(textArea, buffer), abbrev)) != null) {
            Hashtable variables = SuperAbbrevs.loadVariables();
            SuperAbbrevs.expandAbbrev(view, template, variables);
        }
    }

    public static void nextAbbrev(JEditTextArea textArea, Buffer buffer) {
        Handler h = Handler.getHandler((JEditBuffer)buffer);
        Template t = h.getTemplate();
        if (t != null) {
            TemplateCaretListener listener = TemplateCaretListener.removeCaretListener(textArea);
            t.nextField();
            SelectableField f = t.getCurrentField();
            if (f != null) {
                int start = f.getOffset();
                int end = start + f.getLength();
                textArea.setCaretPosition(end);
                textArea.addToSelection((Selection)new Selection.Range(start, end));
            }
            TemplateCaretListener.putCaretListener(textArea, listener);
        }
    }

    public static void prevAbbrev(JEditTextArea textArea, Buffer buffer) {
        Handler h = Handler.getHandler((JEditBuffer)buffer);
        Template t = h.getTemplate();
        if (t != null) {
            TemplateCaretListener listener = TemplateCaretListener.removeCaretListener(textArea);
            t.prevField();
            SelectableField f = t.getCurrentField();
            if (f != null) {
                int start = f.getOffset();
                int end = start + f.getLength();
                textArea.setCaretPosition(end);
                textArea.addToSelection((Selection)new Selection.Range(start, end));
            }
            TemplateCaretListener.putCaretListener(textArea, listener);
        }
    }

    public static String getMode(JEditTextArea textArea, Buffer buffer) {
        int caretPos = textArea.getCaretPosition();
        return buffer.getRuleSetAtOffset(caretPos).getModeName();
    }

    public static void selectField(JEditTextArea textArea, SelectableField field) {
        int start = field.getOffset();
        int end = start + field.getLength();
        textArea.setCaretPosition(end);
        textArea.addToSelection((Selection)new Selection.Range(start, end));
    }

    @Nonnull
    private static String getAbbrev(JEditTextArea textArea, Buffer buffer) {
        int i;
        int line = textArea.getCaretLine();
        int lineStart = buffer.getLineStartOffset(line);
        int caretPos = textArea.getCaretPosition();
        int caretPosition = caretPos - lineStart;
        String lineText = buffer.getLineText(line);
        for (i = caretPosition - 1; 0 <= i && Character.isJavaIdentifierPart(lineText.charAt(i)); --i) {
        }
        return lineText.substring(i + 1, caretPosition);
    }

    private static String getIndent(JEditTextArea textArea, Buffer buffer) {
        int lineNumber = textArea.getCaretLine();
        String line = buffer.getLineText(lineNumber);
        String output = "";
        for (int i = 0; i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t'); ++i) {
            output = output + line.substring(i, i + 1);
        }
        return output;
    }

    public static void removeAbbrev(JEditTextArea textArea, Buffer buffer, String abbrev) {
        int caretPos = textArea.getCaretPosition();
        int templateStart = caretPos - abbrev.length();
        buffer.remove(templateStart, abbrev.length());
    }

    public static void makeDefaults() {
        SuperAbbrevsIO.createAbbrevsDir();
        SuperAbbrevsIO.removeOldMacros();
        SuperAbbrevsIO.writeDefaultAbbrevs();
        SuperAbbrevsIO.writeDefaultVariables();
        SuperAbbrevsIO.writeDefaultAbbrevFunctions();
        SuperAbbrevsIO.writeDefaultTemplateGenerationFunctions();
    }

    private static void putVariables(Interpreter interpreter, Hashtable variables) throws EvalError {
        if (variables != null) {
            for (Map.Entry entry : variables.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                interpreter.set(name, (Object)value);
            }
        }
    }
}

