/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs;

import java.util.Hashtable;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.buffer.BufferAdapter;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import superabbrevs.TemplateCaretListener;
import superabbrevs.template.Template;
import superabbrevs.template.WriteOutsideTemplateException;

public class Handler
extends BufferAdapter {
    private boolean disabled;
    private JEditTextArea textArea;
    private boolean justEdited = false;
    private int caret;
    private int oldTemplateLength;
    private Buffer buffer;
    private boolean inCompoundEdit = false;
    private Template template;
    private static Hashtable handlers = new Hashtable();

    public Template getTemplate() {
        return this.template;
    }

    public Handler(Template template, JEditTextArea textArea, Buffer buffer) {
        this.textArea = textArea;
        this.buffer = buffer;
        this.template = template;
    }

    public boolean justEdited() {
        return this.justEdited;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void contentInserted(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        if (!this.disabled) {
            String insertedText = buffer.getText(offset, length);
            try {
                if (this.justEdited) {
                    offset = this.caret;
                    this.oldTemplateLength += length;
                } else {
                    this.oldTemplateLength = this.template.getLength() + length;
                }
                int fieldOffset = this.template.getCurrentField().getOffset();
                this.template.insert(offset, insertedText);
                int offsetChanged = this.template.getCurrentField().getOffset() - fieldOffset;
                this.caret = offset + offsetChanged + length;
                this.justEdited = true;
            }
            catch (WriteOutsideTemplateException e) {
                Handler.removeHandler(buffer);
            }
        }
    }

    public void contentRemoved(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        if (!this.disabled) {
            try {
                this.oldTemplateLength = this.template.getLength() - length;
                int fieldOffset = this.template.getCurrentField().getOffset();
                this.template.delete(offset, length);
                int offsetChanged = this.template.getCurrentField().getOffset() - fieldOffset;
                this.caret = offset + offsetChanged;
                this.justEdited = true;
                this.textArea.setCaretPosition(this.caret);
            }
            catch (WriteOutsideTemplateException e) {
                Handler.removeHandler(buffer);
            }
        }
    }

    public void postEdit() {
        this.disabled = true;
        this.buffer.writeLock();
        TemplateCaretListener listener = TemplateCaretListener.removeCaretListener(this.textArea);
        Handler handler = Handler.removeHandler((JEditBuffer)this.buffer);
        this.buffer.remove(this.template.getOffset(), this.oldTemplateLength);
        this.buffer.insert(this.template.getOffset(), this.template.toString());
        Handler.putHandler(this.buffer, handler);
        TemplateCaretListener.putCaretListener(this.textArea, listener);
        this.buffer.writeUnlock();
        this.textArea.setCaretPosition(this.caret);
        this.disabled = false;
        this.justEdited = false;
    }

    public static void putHandler(Buffer buffer, Handler t) {
        Handler h = Handler.getHandler((JEditBuffer)buffer);
        buffer.removeBufferListener((BufferListener)h);
        buffer.addBufferListener((BufferListener)t);
        handlers.put(buffer, t);
    }

    public static Handler getHandler(JEditBuffer buffer) {
        return (Handler)((Object)handlers.get(buffer));
    }

    public static Handler removeHandler(JEditBuffer buffer) {
        Handler h = Handler.getHandler(buffer);
        buffer.removeBufferListener((BufferListener)h);
        handlers.remove(buffer);
        return h;
    }

    public static boolean enabled(Buffer buffer) {
        return null != handlers.get(buffer);
    }
}

