/*
 * Decompiled with CFR 0.152.
 */
package console.ssh;

import console.CommandOutputParser;
import console.Console;
import console.Output;
import console.ParsingOutputStreamTask;
import console.SimpleOutputStreamTask;
import console.ssh.ConnectionManager;
import console.ssh.ConsoleState;
import console.ssh.SecureErrorSource;
import errorlist.DefaultErrorSource;
import java.awt.Color;
import java.io.InputStream;

class StreamThread
extends ParsingOutputStreamTask {
    private String status;

    public StreamThread(Console console, InputStream in, Output output, Color defaultColor) {
        super(in, output, defaultColor, console.getConsolePane().getBackground(), null, null);
        this.setWaitingLoop(SimpleOutputStreamTask.WLTypes.blockWL);
        ConsoleState cs = ConnectionManager.getConsoleState(console);
        String currentDirectory = cs.getPath();
        SecureErrorSource es = new SecureErrorSource(cs, console.getView());
        CommandOutputParser copt = new CommandOutputParser(console.getView(), (DefaultErrorSource)es, defaultColor);
        copt.setDirectory(currentDirectory);
        cs.setDirectoryChangeListener(copt);
        this.setErrorParser(copt);
        this.setAnsiParser(defaultColor, console.getConsolePane().getBackground());
        this.status = "sshconsole";
    }

    public void setStatus(String newStatus) {
        this.status = newStatus;
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return this.status;
    }
}

