/*
 * Decompiled with CFR 0.152.
 */
package console.ssh;

import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import console.Console;
import console.ConsolePane;
import console.Output;
import console.ssh.Connection;
import console.ssh.ConnectionManager;
import console.ssh.ConsoleState;
import ftp.ConnectionInfo;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class Shell
extends console.Shell {
    static final byte[] EOF = new byte[]{4};
    static final byte[] SUSPEND = new byte[]{26};
    static final byte[] STOP = new byte[]{3};
    static final byte[] newline = new byte[]{10};

    public void endOfFile(Console console) {
        new ShellAction(console, EOF).actionPerformed(null);
        console.stopAnimation();
    }

    public boolean handlesVFS(String vfsPath) {
        return vfsPath.startsWith("sftp://");
    }

    public boolean chDir(Console console, String path) {
        if (!this.handlesVFS(path)) {
            return false;
        }
        if (!jEdit.isStartupDone()) {
            return false;
        }
        ConsoleState cs = ConnectionManager.getConsoleState(console);
        cs.setPath(path, true);
        return true;
    }

    public void stop(Console console) {
        new ShellAction(console, STOP).actionPerformed(null);
    }

    public void closeConsole(Console console) {
        this.endOfFile(console);
    }

    public void openConsole(Console console) {
    }

    public Shell() {
        super("ssh");
    }

    public void execute(Console console, String input, Output output, Output error, String command) {
        boolean consumed;
        ConsoleState cs = ConnectionManager.getConsoleState(console);
        if (cs.conn == null) {
            try {
                Buffer b;
                String p;
                ConnectionInfo info = ConnectionManager.getConnectionInfo(cs.getPath());
                if ((info == null || cs.getPath().equals("")) && (p = (b = console.getView().getEditPane().getBuffer()).getPath()).startsWith("sftp:")) {
                    cs.setPath(MiscUtilities.getParentOfPath((String)p), true);
                }
                if ((info = ConnectionManager.getConnectionInfo(cs.getPath())) == null) {
                    Log.log((int)7, (Object)((Object)this), (Object)("Unable to get connectioninfo for: " + cs.getPath()));
                    console.stopAnimation();
                    this.printPrompt(console, output);
                    return;
                }
                cs.info = info;
                Session session = ConnectionManager.client.getSession(info.user, info.host, info.port);
                Connection c = ConnectionManager.getShellConnection(console, info);
                session.setUserInfo((UserInfo)c);
                cs.os = c.ostr;
                cs.conn = c;
                cs.setPath("");
            }
            catch (Exception e) {
                Log.log((int)7, (Object)((Object)this), (Object)"getShellConnection failed:", (Throwable)e);
                console.stopAnimation();
            }
        }
        if (consumed = cs.preprocess(command)) {
            this.printPrompt(console, output);
        } else if (cs.os != null) {
            try {
                cs.os.write((command + "\n").getBytes());
                cs.os.flush();
            }
            catch (IOException ioe) {
                Log.log((int)7, (Object)((Object)this), (Object)("IOException writing to ssh pipe: " + ioe.toString()));
                cs.close();
                console.stopAnimation();
            }
        }
    }

    public void printPrompt(Console console, Output output) {
        ConsoleState s = ConnectionManager.getConsoleState(console);
        String promptString = "[no sftp:// connections?] >";
        if (s.info != null) {
            promptString = "[ssh:" + s.info.user + "@" + s.info.host + "]> ";
        }
        if (s.conn == null || !s.conn.inUse) {
            output.writeAttrs(ConsolePane.colorAttributes((Color)console.getPlainColor()), "\n" + promptString);
        } else {
            try {
                s.os.write(newline);
                s.os.flush();
            }
            catch (IOException ioe) {
                this.endOfFile(console);
            }
        }
    }

    public void detach(Console console) {
        new ShellAction(console, SUSPEND).actionPerformed(null);
    }

    public static class ShellAction
    extends AbstractAction {
        final Console con;
        final byte[] cmd;

        public ShellAction(Console console, byte[] str) {
            this.con = console;
            this.cmd = str;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.con.getShell().getName().equals("ssh")) {
                return;
            }
            ConsoleState cs = ConnectionManager.getConsoleState(this.con);
            if (cs != null && cs.os != null) {
                try {
                    cs.os.write(this.cmd);
                    cs.os.flush();
                }
                catch (IOException ioe) {
                    Log.log((int)7, (Object)this, (Object)"ioexception when writing - connection closed");
                    cs.close();
                }
            }
        }
    }
}

