/*
 * Decompiled with CFR 0.152.
 */
package console.ssh;

import console.ssh.ConnectionManager;
import console.ssh.ConsoleState;
import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.util.Log;

public class SecureErrorSource
extends DefaultErrorSource {
    ConsoleState consoleState;

    public SecureErrorSource(ConsoleState cs, View v) {
        super("sshconsole", v);
        ErrorSource.registerErrorSource((ErrorSource)this);
        this.consoleState = cs;
    }

    public synchronized void addError(final DefaultErrorSource.DefaultError error) {
        DefaultErrorSource.ErrorListForPath list;
        String path;
        if (error.getErrorSource() != this) {
            Log.log((int)7, (Object)((Object)this), (Object)"Why different error source?");
            ErrorSource.registerErrorSource((ErrorSource)error.getErrorSource());
        }
        if (!(path = error.getFilePath()).startsWith("sftp:")) {
            String base = ConnectionManager.extractBase(this.consoleState.getPath());
            path = base + path;
            try {
                error.setFilePath(path);
            }
            catch (Exception e) {
                return;
            }
        }
        if ((list = (DefaultErrorSource.ErrorListForPath)this.errors.get(path)) == null) {
            list = new DefaultErrorSource.ErrorListForPath();
            this.errors.put(path, list);
        }
        if (list.add((Object)error)) {
            ++this.errorCount;
            this.removeOrAddToBus();
            if (this.registered) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ErrorSourceUpdate message = new ErrorSourceUpdate((ErrorSource)SecureErrorSource.this, ErrorSourceUpdate.ERROR_ADDED, (ErrorSource.Error)error);
                        EditBus.send((EBMessage)message);
                    }
                });
            }
        }
    }
}

