/*
 * Decompiled with CFR 0.152.
 */
package console.ssh;

import console.CommandOutputParser;
import console.Console;
import console.Output;
import console.Shell;
import console.ssh.Connection;
import console.ssh.ConnectionManager;
import ftp.ConnectionInfo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.jEdit;

public class ConsoleState {
    private String path = "";
    Console console;
    String dir = "";
    OutputStream os = null;
    Connection conn = null;
    ConnectionInfo info = null;
    CommandOutputParser dirChangeListener = null;

    public ConsoleState(Console c) {
        this.console = c;
    }

    public void setPath(String newPath) {
        this.setPath(newPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String newPath, boolean chDirAfter) {
        if (File.separatorChar == '\\') {
            newPath = newPath.replace('\\', '/');
        }
        if (this.path.equals(newPath)) {
            return;
        }
        this.path = newPath;
        ConnectionInfo newInfo = ConnectionManager.getConnectionInfo(newPath);
        if (newInfo == null) {
            return;
        }
        if (this.info == null || !newInfo.equals((Object)this.info)) {
            this.info = newInfo;
            if (this.conn != null) {
                try {
                    this.os.close();
                    this.conn.logout();
                }
                catch (IOException e) {
                }
                finally {
                    this.dir = "";
                    this.os = null;
                    this.conn = null;
                }
            }
        }
        if (this.dirChangeListener != null) {
            this.dirChangeListener.setDirectory(this.path);
        }
        if ((newPath = ConnectionManager.extractDirectory(newPath)) == null || this.dir.equals(newPath)) {
            return;
        }
        this.dir = newPath;
        Shell s = this.console.getShell();
        if (!s.getName().equals("ssh")) {
            return;
        }
        if (chDirAfter) {
            String command = "cd " + this.dir;
            Console.ShellState output = this.console.getShellState(s);
            s.execute(this.console, null, (Output)output, (Output)output, command);
        }
    }

    public String getPath() {
        return this.path;
    }

    protected boolean preprocess(String command) {
        if (command.startsWith("cd ")) {
            String base = ConnectionManager.extractBase(this.path);
            String direct = ConnectionManager.extractDirectory(this.path);
            String argument = command.substring(3);
            String newPath = null;
            newPath = argument.startsWith("/") ? base + argument : base + MiscUtilities.constructPath((String)direct, (String)argument);
            this.setPath(newPath, false);
            return false;
        }
        if (command.startsWith("%browse")) {
            String base = ConnectionManager.extractBase(this.path);
            String direct = ConnectionManager.extractDirectory(this.path);
            String arg = command.substring(7);
            String newPath = this.path;
            if (arg.length() > 1 && (arg = arg.substring(1)).length() > 0) {
                newPath = arg.startsWith("/") ? base + arg : base + MiscUtilities.constructPath((String)direct, (String)arg);
            }
            VFSBrowser.browseDirectory((View)this.console.getView(), (String)newPath);
            return true;
        }
        if (command.startsWith("%edit ")) {
            String arg = command.substring(6);
            jEdit.openFile((View)this.console.getView(), (String)this.path, (String)arg, (boolean)false, null);
            return true;
        }
        return false;
    }

    public void close() {
        this.dir = "";
        if (this.conn != null) {
            try {
                this.conn.logout();
                ConnectionManager.closeConnection(this.conn);
                this.conn = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setDirectoryChangeListener(CommandOutputParser cop) {
        this.dirChangeListener = cop;
    }
}

