/*
 * Decompiled with CFR 0.152.
 */
package console.ssh;

import console.Console;
import console.ssh.Connection;
import console.ssh.ConsoleState;
import ftp.ConnectionInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.util.Log;

public class ConnectionManager
extends ftp.ConnectionManager {
    static Pattern sftpPath = Pattern.compile("sftp://(?:([^@]+)@)?([^/:]+)(?::(\\d+))?/(.*)$");
    static HashMap<ConnectionInfo, Connection> connectionInfos = null;
    static HashMap<Console, ConsoleState> consoleStates = null;
    static ArrayList<Connection> connections = new ArrayList();

    static String extractDirectory(String vfsPath) {
        String path = null;
        Matcher m = sftpPath.matcher(vfsPath);
        if (m.matches()) {
            path = "/" + m.group(4);
        }
        return path;
    }

    static String extractBase(String vfsPath) {
        String path = null;
        Matcher m = sftpPath.matcher(vfsPath);
        if (m.matches()) {
            int end = Math.max(m.end(3), m.end(2));
            end = Math.max(end, m.end(1));
            path = vfsPath.substring(0, end);
        }
        return path;
    }

    static ConnectionInfo parseAddress(String vfsPath) {
        Matcher m = sftpPath.matcher(vfsPath);
        if (!m.matches()) {
            return null;
        }
        String user = m.group(1) != null ? m.group(1) : System.getProperty("user.name");
        String host = m.group(2);
        String portstr = m.group(3) != null ? m.group(3) : "22";
        int port = Integer.parseInt(portstr);
        return new ConnectionInfo(true, host, port, user, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeUnusedConnections() {
        Object object = lock;
        synchronized (object) {
            for (int i = 0; i < connections.size(); ++i) {
                Connection _connect = connections.get(i);
                if (_connect.inUse()) continue;
                ConnectionManager.closeConnection(_connect);
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeConnection(Connection connect) {
        Object object = lock;
        synchronized (object) {
            if (connect.inUse) {
                Log.log((int)1, ConnectionManager.class, (Object)"Can't close connection that still in use");
                return;
            }
            Log.log((int)1, ConnectionManager.class, (Object)("Closing connection to " + connect.info));
            try {
                connect.logout();
            }
            catch (IOException io) {
                Log.log((int)9, ConnectionManager.class, (Object)io);
            }
            connections.remove(connect);
        }
    }

    static void setup() {
        lock = new Object();
        connectionInfos = new HashMap();
        consoleStates = new HashMap();
    }

    public static void cleanup() {
        for (ConsoleState cs : consoleStates.values()) {
            cs.close();
        }
        connections.clear();
        connectionInfos.clear();
        consoleStates.clear();
    }

    public static ConsoleState getConsoleState(Console c) {
        if (consoleStates.containsKey(c)) {
            return consoleStates.get(c);
        }
        ConsoleState ss = new ConsoleState(c);
        consoleStates.put(c, ss);
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Connection getShellConnection(Console console, ConnectionInfo info) throws IOException {
        Connection connect = null;
        Object object = lock;
        synchronized (object) {
            Iterator<Connection> iterator = connections.iterator();
            while (iterator.hasNext()) {
                Connection c = iterator.next();
                if (!c.info.equals((Object)info) || c.inUse() || (connect = c).checkIfOpen()) continue;
                Log.log((int)1, ConnectionManager.class, (Object)("Connection " + connect + " expired"));
                try {
                    connect.logout();
                }
                catch (IOException io) {
                    // empty catch block
                }
                iterator.remove();
                connect = null;
            }
            if (connect == null) {
                Log.log((int)1, ConnectionManager.class, (Object)(Thread.currentThread() + ": Connecting to " + info));
                connect = new Connection(console, info);
                connections.add(connect);
            } else {
                connect.setConsole(console);
            }
            connect.inUse = true;
            return connect;
        }
    }

    public static ConnectionInfo getConnectionInfo(String vfsPath) {
        Matcher m = sftpPath.matcher(vfsPath);
        if (!m.matches()) {
            return null;
        }
        String user = m.group(1);
        if (user == null || user.length() < 1) {
            user = System.getProperty("user.name");
        }
        String host = m.group(2);
        String port = m.group(3);
        if (port == null) {
            port = "22";
        }
        return (ConnectionInfo)logins.get(host + ":" + port);
    }
}

