/*
 * Decompiled with CFR 0.152.
 */
package console.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import console.Console;
import console.ssh.StreamThread;
import ftp.ConnectionInfo;
import ftp.ConnectionManager;
import ftp.PasswordDialog;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class Connection
implements UserInfo {
    int id;
    ConnectionInfo info;
    Session session;
    String home;
    boolean inUse = false;
    Timer closeTimer;
    private String passphrase = null;
    Channel channel;
    OutputStream ostr;
    StreamThread stout;
    Console console;
    private int keyAttempts = 0;
    private int SESSION_TIMEOUT = 60000;
    private int CHANNEL_TIMEOUT = 10000;

    public Connection(Console console, ConnectionInfo info) {
        try {
            this.console = console;
            this.info = info;
            this.session = ConnectionManager.client.getSession(info.user, info.host, info.port);
            if (info.privateKey != null) {
                Log.log((int)1, (Object)this, (Object)"Attempting public key authentication");
                Log.log((int)1, (Object)this, (Object)("Using key: " + info.privateKey));
                ConnectionManager.client.addIdentity(info.privateKey);
            }
            this.keyAttempts = 0;
            this.session.setUserInfo((UserInfo)this);
            this.session.connect(this.SESSION_TIMEOUT);
            this.channel = this.session.openChannel("shell");
            ChannelShell channelShell = (ChannelShell)this.channel;
            channelShell.setAgentForwarding(true);
            channelShell.setXForwarding(true);
            channelShell.setPtyType("dumb");
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream(pos);
            this.channel.setOutputStream((OutputStream)pos);
            this.stout = new StreamThread(console, pis, console.getOutput(), console.getPlainColor());
            this.stout.setStatus("ssh " + info.toString());
            console.startAnimation();
            this.inUse = true;
            ThreadUtilities.runInBackground((Runnable)((Object)this.stout));
            pos = new PipedOutputStream();
            pis = new PipedInputStream(pos);
            this.channel.setInputStream((InputStream)pis);
            this.ostr = pos;
            this.channel.connect(this.CHANNEL_TIMEOUT);
        }
        catch (Exception e) {
            Log.log((int)9, (Object)this, (Object)"Can't create Connection - did you browse sftp:// first?", (Throwable)e);
        }
    }

    void setConsole(Console c) throws IOException {
        if (c != this.console) {
            this.stout.abort();
            this.console = c;
            this.stout = new StreamThread(this.console, this.channel.getInputStream(), this.console.getOutput(), this.console.getPlainColor());
            this.console.startAnimation();
            this.inUse = true;
            this.stout.setStatus("ssh " + this.info.toString());
            ThreadUtilities.runInBackground((Runnable)((Object)this.stout));
        }
    }

    public boolean inUse() {
        return this.inUse;
    }

    boolean checkIfOpen() throws IOException {
        return this.channel.isConnected();
    }

    void logout() throws IOException {
        if (this.console.getView() != null) {
            this.console.stopAnimation();
        }
        this.stout.abort();
        this.channel.disconnect();
        this.session.disconnect();
        this.inUse = false;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getPassword() {
        return this.info.password;
    }

    public boolean promptPassword(String message) {
        return true;
    }

    public boolean promptPassphrase(String message) {
        Log.log((int)1, (Object)this, (Object)message);
        this.passphrase = ConnectionManager.getPassphrase((String)this.info.privateKey);
        if (this.passphrase == null || this.keyAttempts != 0) {
            PasswordDialog pd = new PasswordDialog((JFrame)this.console.getView(), jEdit.getProperty((String)"login.privatekeypassword"), message);
            if (!pd.isOK()) {
                return false;
            }
            this.passphrase = new String(pd.getPassword());
            ConnectionManager.setPassphrase((String)this.info.privateKey, (String)this.passphrase);
        }
        ++this.keyAttempts;
        return true;
    }

    public boolean promptYesNo(final String message) {
        final int[] ret = new int[1];
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Object[] options = new Object[]{"yes", "no"};
                    ret[0] = JOptionPane.showOptionDialog((Component)Connection.this.console.getView(), message, "Warning", -1, 2, null, options, options[0]);
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException e) {
            Log.log((int)9, (Object)this, (Object)e);
        }
        catch (InvocationTargetException e) {
            Log.log((int)9, (Object)this, (Object)e);
        }
        return ret[0] == 0;
    }

    public void showMessage(String message) {
        JOptionPane.showMessageDialog((Component)this.console.getView(), message);
    }
}

