/*
 * Decompiled with CFR 0.152.
 */
package jython.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;

public class RegistryOptionsPane
extends AbstractOptionPane
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox override;
    private JTextField path;
    private JTextField cache;
    private JButton browseForCache;
    private JComboBox verbose;
    private JCheckBox respectJavaAccessibility;
    private JTextField compiler;
    private JButton browseForCompiler;
    private JTextField classpath;
    private JTextField compilerOpts;

    public RegistryOptionsPane() {
        super("jython.registry");
    }

    public void _init() {
        this.override = new JCheckBox(jEdit.getProperty((String)"options.jython.overrideTitle"));
        this.addComponent(this.override);
        this.override.getModel().setSelected(jEdit.getBooleanProperty((String)"options.jython.override"));
        this.override.addActionListener(this);
        this.path = new JTextField(jEdit.getProperty((String)"options.jython.registry.value.0"));
        this.addComponent(jEdit.getProperty((String)"options.jython.registry.name.0"), this.path);
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        this.browseForCache = new JButton("...");
        this.browseForCache.addActionListener(this);
        this.cache = new JTextField(jEdit.getProperty((String)"options.jython.registry.value.1"));
        panel.add((Component)this.cache, "Center");
        panel.add((Component)this.browseForCache, "East");
        this.addComponent(jEdit.getProperty((String)"options.jython.registry.name.1"), panel);
        DefaultComboBoxModel<String> levels = new DefaultComboBoxModel<String>();
        StringTokenizer st = new StringTokenizer(jEdit.getProperty((String)"options.jython.python.verbose.values"));
        levels.addElement("");
        while (st.hasMoreElements()) {
            levels.addElement(st.nextToken());
        }
        this.verbose = new JComboBox(levels);
        this.addComponent(jEdit.getProperty((String)"options.jython.registry.name.2"), this.verbose);
        this.verbose.setSelectedItem(jEdit.getProperty((String)"options.jython.registry.value.2"));
        this.respectJavaAccessibility = new JCheckBox(jEdit.getProperty((String)"options.jython.registry.name.3"));
        this.addComponent(this.respectJavaAccessibility);
        this.respectJavaAccessibility.getModel().setSelected(jEdit.getBooleanProperty((String)"options.jython.registry.value.3"));
        panel = new JPanel(new BorderLayout(2, 2));
        this.browseForCompiler = new JButton("...");
        this.browseForCompiler.addActionListener(this);
        this.compiler = new JTextField(jEdit.getProperty((String)"options.jython.registry.value.4"));
        panel.add((Component)this.compiler, "Center");
        panel.add((Component)this.browseForCompiler, "East");
        this.addComponent(jEdit.getProperty((String)"options.jython.registry.name.4"), panel);
        this.classpath = new JTextField(jEdit.getProperty((String)"options.jython.registry.value.5"));
        this.addComponent(jEdit.getProperty((String)"options.jython.registry.name.5"), this.classpath);
        this.compilerOpts = new JTextField(jEdit.getProperty((String)"options.jython.registry.value.6"));
        this.addComponent(jEdit.getProperty((String)"options.jython.registry.name.6"), this.compilerOpts);
        this.enableControls();
    }

    public void _save() {
        jEdit.setBooleanProperty((String)"options.jython.override", (boolean)this.override.getModel().isSelected());
        jEdit.setProperty((String)"options.jython.registry.value.0", (String)this.path.getText());
        jEdit.setProperty((String)"options.jython.registry.value.1", (String)this.cache.getText());
        jEdit.setProperty((String)"options.jython.registry.value.2", (String)((String)this.verbose.getSelectedItem()));
        jEdit.setBooleanProperty((String)"options.jython.registry.value.3", (boolean)this.respectJavaAccessibility.getModel().isSelected());
        jEdit.setProperty((String)"options.jython.registry.value.4", (String)this.compiler.getText());
        jEdit.setProperty((String)"options.jython.registry.value.5", (String)this.classpath.getText());
        jEdit.setProperty((String)"options.jython.registry.value.6", (String)this.compilerOpts.getText());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String[] files;
        if (evt.getSource() == this.override) {
            this.enableControls();
        } else if (evt.getSource() == this.browseForCache) {
            String[] dirs = GUIUtilities.showVFSFileDialog(null, (String)this.cache.getText(), (int)3, (boolean)false);
            if (dirs != null && dirs.length == 1) {
                this.cache.setText(dirs[0]);
            }
        } else if (evt.getSource() == this.browseForCompiler && (files = GUIUtilities.showVFSFileDialog(null, (String)this.compiler.getText(), (int)0, (boolean)false)) != null && files.length == 1) {
            this.compiler.setText(files[0]);
        }
    }

    private void enableControls() {
        boolean enabled = this.override.getModel().isSelected();
        this.path.setEnabled(enabled);
        this.cache.setEnabled(enabled);
        this.browseForCache.setEnabled(enabled);
        this.verbose.setEnabled(enabled);
        this.respectJavaAccessibility.setEnabled(enabled);
        this.compiler.setEnabled(enabled);
        this.browseForCompiler.setEnabled(enabled);
        this.classpath.setEnabled(enabled);
        this.compilerOpts.setEnabled(enabled);
    }
}

