/*
 * Decompiled with CFR 0.152.
 */
package jython;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import jython.Console;
import jython.ExecuteCommand;
import jython.ImportCommand;
import jython.JeditConsole;
import jython.JythonCommand;
import jython.JythonErrorDialog;
import jython.LineCommand;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.imp;
import projectviewer.ProjectViewer;
import projectviewer.vpt.VPTProject;

public class JythonExecutor
implements Runnable {
    private static JythonExecutor executor;
    private JeditConsole interpreter;
    private Thread interpreterThread;
    private Object lock;
    private ArrayList<JythonCommand> queue;
    private boolean interrupted;
    private boolean initialised;
    private boolean useInternalLib = false;
    private PyStringMap originalLocals = null;

    private void JythonExecutor() {
    }

    public static synchronized JythonExecutor getExecutor() {
        if (executor == null) {
            executor = new JythonExecutor();
        }
        return executor;
    }

    public static void execMacro(String name) {
        JythonExecutor.getExecutor();
        if (executor != null) {
            executor.internalExecMacro(null, name);
        }
    }

    public static void execMacro(View view, String name) {
        JythonExecutor.getExecutor();
        if (executor != null) {
            executor.internalExecMacro(view, name);
        }
    }

    public static PyObject execPlugin(String plugin, String dir, String module, String function) {
        JythonExecutor.getExecutor();
        if (executor != null) {
            return executor.execPlugin(plugin, dir, module, function, true, null);
        }
        return null;
    }

    public static PyObject execPlugin(String plugin, String dir, String module, String function, Object[] args) {
        JythonExecutor.getExecutor();
        if (executor != null) {
            return executor.execPlugin(plugin, dir, module, function, true, args);
        }
        return null;
    }

    public static void addPlugin(String plugin) {
    }

    public static void checkVersion(View view) {
        if (PySystemState.hexversion < 33882352) {
            GUIUtilities.error((Component)view, (String)"jython.check.wrong", (Object[])new Object[]{PySystemState.version});
        } else {
            GUIUtilities.message((Component)view, (String)"jython.check.right", (Object[])new Object[]{PySystemState.version});
        }
    }

    public void interruptCurrent(Console console) {
        this.interpreter.interrupt(Py.getThreadState());
        PySystemState sys = Py.getSystemState();
        PyObject locals = this.interpreter.getLocals();
        this.interrupt();
    }

    public void interrupt() {
        this.originalLocals = null;
        this.interpreter = null;
        PySystemState sys = Py.getSystemState();
        sys.path = new PyList();
        this.interpreter = this.getInterpreter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execBuffer(View view, Buffer buffer, Console console) {
        if (buffer != null && buffer.getPath() != null) {
            ExecuteCommand command = new ExecuteCommand(buffer, view, console);
            try {
                this.queue.add(command);
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
            }
            catch (Exception e) {
                this.interpreter.doException(console, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importBuffer(View view, Buffer buffer, Console console) {
        ImportCommand command = new ImportCommand(buffer, view, console);
        try {
            this.queue.add(command);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
        catch (Exception e) {
            this.interpreter.doException(console, e);
        }
    }

    public PyObject eval(String what) {
        return this.interpreter.eval(what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(View view, String command, Console console) {
        Log.log((int)1, (Object)this, (Object)command);
        try {
            LineCommand entry = new LineCommand(command, view, console);
            this.queue.add(entry);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
        catch (Exception e) {
            this.interpreter.doException(console, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        JeditConsole interp = this.getInterpreter();
        while (true) {
            try {
                while (true) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.queue.size() == 0) {
                            try {
                                this.lock.wait(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        if (this.queue.size() == 0) {
                            continue;
                        }
                        if (this.interrupted) {
                            return;
                        }
                        JythonCommand command = this.queue.get(0);
                        this.queue.remove(0);
                        command.execute(this.interpreter);
                    }
                }
            }
            catch (Throwable ex) {
                Log.log((int)9, (Object)this, (Object)ex.getMessage());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized JeditConsole getInterpreter() {
        if (this.interpreter == null) {
            PluginJAR[] plugins;
            VPTProject currentProject;
            String path;
            if (!this.initialised) {
                int jpy;
                Properties sysProperties;
                String classpath;
                Properties props = new Properties();
                if (jEdit.getBooleanProperty((String)"options.jython.registry.override")) {
                    int propsSize = Integer.parseInt(jEdit.getProperty((String)"options.jython.registry.count"));
                    for (int i = 0; i < propsSize; ++i) {
                        String key = null;
                        String value = null;
                        key = jEdit.getProperty((String)("options.jython.registry.name." + i));
                        value = jEdit.getProperty((String)("options.jython.registry.value." + i));
                        if (value == null || value.length() <= 0) continue;
                        props.setProperty(key, value);
                    }
                }
                if ((classpath = (sysProperties = System.getProperties()).getProperty("java.class.path")) != null && (jpy = classpath.toLowerCase().indexOf("jython.jar")) == -1) {
                    this.useInternalLib = true;
                }
                if (this.useInternalLib && !props.containsKey("python.cachedir")) {
                    props.setProperty("python.cachedir", MiscUtilities.constructPath((String)MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"jython"), (String)"cachedir"));
                }
                try {
                    JeditConsole.initialize((Properties)sysProperties, (Properties)props, (String[])new String[]{""});
                }
                catch (Exception e) {
                    Log.log((int)9, (Object)this, (Object)e);
                }
                finally {
                    this.initialised = true;
                }
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            PyModule mod = imp.addModule((String)"__main__");
            PySystemState sys = Py.getSystemState();
            if (this.originalLocals == null) {
                this.originalLocals = (PyStringMap)mod.__dict__;
                this.originalLocals = this.originalLocals.copy();
            }
            try {
                this.interpreter = this.originalLocals != null && sys != null ? new JeditConsole((PyObject)this.originalLocals, sys, out, err) : new JeditConsole(out, err);
            }
            catch (Exception e) {
                Log.log((int)9, (Object)this, (Object)"Not possible to build interpreter");
                Log.log((int)9, (Object)this, (Object)e);
                return null;
            }
            if (this.useInternalLib) {
                PluginJAR jar = jEdit.getPlugin((String)"jython.JythonPlugin").getPluginJAR();
                Log.log((int)1, (Object)this, (Object)"Using internal library");
                path = new File(new File(jar.getPath()).getParent(), "jythonlib.jar").toString();
                PySystemState.packageManager.addJar(path, true);
                sys.path.insert(0, (PyObject)new PyString(path + "/Lib"));
                path = new File(new File(jar.getPath()).getParent(), "jython.jar").toString();
                PySystemState.packageManager.addJar(path, true);
            }
            if (jEdit.getPlugin((String)"projectviewer.ProjectPlugin") != null && (currentProject = ProjectViewer.getActiveProject((View)jEdit.getActiveView())) != null && (path = currentProject.getRootPath()) != null) {
                sys.path.insert(0, (PyObject)new PyString(path));
            }
            if (jEdit.getBooleanProperty((String)"options.jython.autoloadPlugins")) {
                plugins = jEdit.getPluginJARs();
                for (int i = 0; i < plugins.length; ++i) {
                    PySystemState.packageManager.addJar(plugins[i].getPath(), true);
                }
            } else {
                plugins = jEdit.getPluginJARs();
                for (int i = 0; i < plugins.length; ++i) {
                    if (plugins[i].getPath().toUpperCase().endsWith("SIDEKICK.JAR")) {
                        PySystemState.packageManager.addJar(plugins[i].getPath(), true);
                    }
                    if (!plugins[i].getPath().toUpperCase().endsWith("ERRORLIST.JAR")) continue;
                    PySystemState.packageManager.addJar(plugins[i].getPath(), true);
                }
            }
            this.execPlugin("jython.JythonPlugin", "jython", "init", "_start", false, null);
            this.interpreter.runsource("from init import _getUsersJythonDir");
            this.interpreter.runsource("from org.gjt.sp.jedit import Buffer");
            this.interpreter.runsource("from org.gjt.sp.jedit import EditPane");
            this.interpreter.runsource("from org.gjt.sp.jedit import jEdit");
            this.interpreter.runsource("from org.gjt.sp.jedit import View");
            this.lock = new Object();
            this.queue = new ArrayList();
            this.interrupted = false;
            this.interpreterThread = new Thread(this);
            this.interpreterThread.start();
        }
        return this.interpreter;
    }

    protected void internalExecMacro(View view, String name) {
        if (this.interpreter == null) {
            this.interpreter = this.getInterpreter();
        }
        if (view == null) {
            view = jEdit.getFirstView();
        }
        EditPane editPane = null;
        Buffer buffer = null;
        JEditTextArea textArea = null;
        if (view != null) {
            editPane = view.getEditPane();
            textArea = editPane.getTextArea();
            buffer = editPane.getBuffer();
        }
        PySystemState sys = Py.getSystemState();
        PyObject py_view = view != null ? Py.java2py((Object)view) : Py.None;
        PyObject py_buffer = buffer != null ? Py.java2py((Object)buffer) : Py.None;
        PyObject py_editPane = editPane != null ? Py.java2py((Object)editPane) : Py.None;
        PyObject py_textArea = textArea != null ? Py.java2py((Object)textArea) : Py.None;
        PyObject init = ((PyStringMap)sys.modules).get((PyObject)new PyString("init"));
        init.__setattr__("view", py_view);
        init.__setattr__("buffer", py_buffer);
        init.__setattr__("editPane", py_editPane);
        init.__setattr__("textArea", py_textArea);
        PyObject locals = this.interpreter.getLocals();
        locals.__setitem__("view", py_view);
        locals.__setitem__("buffer", py_buffer);
        locals.__setitem__("editPane", py_editPane);
        locals.__setitem__("textArea", py_textArea);
        locals.__setitem__("__name__", (PyObject)new PyString("__main__"));
        try {
            this.interpreter.execfile(name);
        }
        catch (Throwable t) {
            new JythonErrorDialog(view, t);
        }
        this.interpreter.doIO(" ", null);
    }

    private PyObject execPlugin(String plugin, String dir, String module, String function, boolean delete, Object[] args) {
        EditPlugin ePlugin = jEdit.getPlugin((String)plugin);
        this.getInterpreter();
        PyObject result = null;
        if (ePlugin != null) {
            try {
                PluginJAR jar = ePlugin.getPluginJAR();
                PySystemState sys = Py.getSystemState();
                String path = jar.getPath();
                PySystemState.packageManager.addJar(path, true);
                PyString element = new PyString(path + "/" + dir);
                try {
                    sys.path.index((PyObject)element);
                }
                catch (Exception e) {
                    sys.path.append((PyObject)element);
                }
                this.interpreter.pushLine("import " + module);
                Log.log((int)1, (Object)this, (Object)("Imported " + module));
                PyObject amodule = null;
                try {
                    amodule = sys.modules.__getitem__((PyObject)new PyString(module));
                }
                catch (PyException e) {
                    Log.log((int)9, (Object)this, (Object)("Executing plugin failed " + plugin + ", module " + module));
                    return null;
                }
                if (args == null) {
                    result = amodule.invoke(function.intern());
                } else {
                    PyObject[] pyArgs = new PyObject[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        pyArgs[i] = Py.java2py((Object)args[i]);
                    }
                    result = amodule.invoke(function.intern(), pyArgs);
                }
                if (delete) {
                    this.interpreter.pushLine("del " + module);
                }
            }
            catch (Exception e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
        } else {
            Log.log((int)9, (Object)this, (Object)("plugin " + plugin + " not found"));
        }
        return result;
    }
}

