/*
 * Decompiled with CFR 0.152.
 */
package jython;

import java.io.ByteArrayOutputStream;
import jython.Console;
import jython.DefaultConsole;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.InteractiveInterpreter;

public class JeditConsole
extends InteractiveInterpreter {
    private boolean onProcess = false;
    private DefaultConsole defConsole = new DefaultConsole();
    private String FILENAME = "<console>";
    protected ByteArrayOutputStream out;
    protected ByteArrayOutputStream err;

    public JeditConsole(ByteArrayOutputStream out, ByteArrayOutputStream err) {
        this.out = out;
        this.err = err;
        this.setOut(out);
        this.setErr(err);
    }

    public JeditConsole(PyObject dict, PySystemState systemState, ByteArrayOutputStream out, ByteArrayOutputStream err) {
        super(dict);
        this.out = out;
        this.err = err;
        this.setOut(out);
        this.setErr(err);
    }

    public boolean pushLine(String line) {
        if (this.buffer.length() > 0) {
            this.buffer.append("\n");
        }
        this.buffer.append(line);
        this.onProcess = this.runsource(this.buffer.toString(), this.FILENAME);
        if (!this.onProcess) {
            this.resetbuffer();
        }
        return this.onProcess;
    }

    public boolean isOnProcess() {
        return this.onProcess;
    }

    public void doIO(String command, Console console) {
        this.doIO(command, console, true);
    }

    public void doIO(String command, Console console, boolean addPrompt) {
        if (console == null) {
            console = this.defConsole;
        }
        if (this.out.size() > 1) {
            String resultText = this.out.toString();
            console.printResult(resultText.substring(0, resultText.length() - (command.length() == 0 ? 0 : 1)));
        }
        this.out.reset();
        if (this.err.size() > 1) {
            String errorText = this.err.toString();
            console.printErrorMsg(errorText.substring(0, errorText.length() - (command.length() == 0 ? 0 : 1)), this.FILENAME, 0);
        }
        this.err.reset();
        if (addPrompt) {
            console.printPrompt();
        }
    }

    public void doException(Console console, Throwable e) {
        if (console == null) {
            console = this.defConsole;
        }
        try {
            this.doIO(" ", console, false);
            if (console != null) {
                console.printError(e);
                console.printPrompt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

