/*
 * Decompiled with CFR 0.152.
 */
package jython;

import jython.Console;
import jython.JeditConsole;
import jython.JythonCommand;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.python.core.PyException;

abstract class AbstractCommand
implements JythonCommand {
    protected View view;
    protected Console console;
    protected Buffer buffer;

    AbstractCommand(Buffer buffer, View view, Console console) {
        this.buffer = buffer;
        this.view = view;
        this.console = console;
    }

    @Override
    public void execute(JeditConsole interpreter) {
        if (!interpreter.isOnProcess()) {
            EditPane editPane = this.view.getEditPane();
            Buffer buffer = editPane.getBuffer();
            interpreter.set("buffer", buffer);
            interpreter.set("editPane", editPane);
            interpreter.set("textArea", editPane.getTextArea());
            interpreter.set("view", this.view);
        }
        try {
            this.doExecute(interpreter);
        }
        catch (PyException e) {
            interpreter.doException(this.console, e);
        }
        catch (Throwable e) {
            interpreter.doException(this.console, e);
        }
    }

    protected abstract void doExecute(JeditConsole var1) throws Exception;
}

