/*
 * Decompiled with CFR 0.152.
 */
package xml.translate;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFailedException;
import com.thaiopensource.relaxng.input.MultiInputFormat;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.OutputFailedException;
import com.thaiopensource.relaxng.output.OutputFormat;
import com.thaiopensource.relaxng.translate.Formats;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import xml.PathUtilities;
import xml.Resolver;
import xml.parser.ErrorListErrorHandler;
import xml.translate.BufferCompactParseInputFormat;
import xml.translate.BufferDtdInputFormat;
import xml.translate.BufferSAXParseInputFormat;
import xml.translate.BuffersOutputDirectory;
import xml.translate.EntityResolverWrapper;

public class TrangTranslator {
    private static DefaultErrorSource errorSource;
    static final String[] inputTypes;
    static final String[] outputTypes;

    public static void stop() {
        if (errorSource != null) {
            ErrorSource.unregisterErrorSource((ErrorSource)errorSource);
            errorSource = null;
        }
    }

    private static void initErrorSource() {
        errorSource = new DefaultErrorSource("xml.TrangTranslator");
        ErrorSource.registerErrorSource((ErrorSource)errorSource);
    }

    public static String guessInputType(Buffer buffer) {
        String inputType;
        String input = buffer.getPath();
        String extension = null;
        if (input.length() > 0) {
            extension = input.substring(input.length() - 3);
        }
        if (Arrays.asList(inputTypes).contains(extension)) {
            inputType = extension;
        } else {
            inputType = buffer.getMode().getName();
            if (!Arrays.asList(inputTypes).contains(inputType)) {
                inputType = null;
            }
        }
        return inputType;
    }

    public static void translateCurrentBuffer(View view, Buffer buffer, String outputType) {
        String input = buffer.getPath();
        String inputType = TrangTranslator.guessInputType(buffer);
        if (inputType == null) {
            int res = GUIUtilities.listConfirm((Component)view, (String)"xml.translate.choose-input-type", (String[])new String[0], (Object[])inputTypes);
            if (res >= 0 && res < inputTypes.length) {
                inputType = inputTypes[res];
            } else {
                return;
            }
        }
        List<String> inputs = Collections.singletonList(input);
        String output = input.endsWith(inputType) ? input.replaceAll(inputType + "$", outputType) : input + "." + outputType;
        TrangTranslator.translate(view, inputType, inputs, Collections.<String>emptyList(), outputType, output, Collections.<String>emptyList());
    }

    public static void translate(View view, String inputType, List<String> inputs, List<String> inputParams, String outputType, String outputFilename, List<String> outputParams) {
        OutputFormat outputFormat;
        Object inputFormat;
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException("must provide at least one input");
        }
        String mainInput = inputs.get(0);
        if (errorSource == null) {
            TrangTranslator.initErrorSource();
        }
        ErrorListErrorHandler eh = new ErrorListErrorHandler(errorSource, mainInput);
        if (inputType == null && (inputType = MiscUtilities.getFileExtension((String)mainInput)).length() > 0) {
            inputType = inputType.substring(1);
        }
        if ((inputFormat = inputType.equalsIgnoreCase("dtd") ? new BufferDtdInputFormat() : (inputType.equalsIgnoreCase("rng") ? new BufferSAXParseInputFormat() : (inputType.equalsIgnoreCase("rnc") ? new BufferCompactParseInputFormat() : Formats.createInputFormat((String)inputType)))) == null) {
            throw new IllegalArgumentException("unsupported input format : " + inputType);
        }
        String ext = MiscUtilities.getFileExtension((String)outputFilename);
        if (outputType == null && (outputType = ext).length() > 0) {
            outputType = outputType.substring(1);
        }
        if ((outputFormat = Formats.createOutputFormat((String)outputType)) == null) {
            throw new IllegalArgumentException("unsupported output format : " + outputType);
        }
        EntityResolverWrapper resolver = new EntityResolverWrapper(Resolver.instance(), true);
        String[] inputParamArray = inputParams.toArray(new String[inputParams.size()]);
        outputType = outputType.toLowerCase();
        try {
            SchemaCollection sc;
            if (inputs.size() > 1) {
                if (!(inputFormat instanceof MultiInputFormat)) {
                    throw new IllegalArgumentException("Only XML input type can handle multiple inputs !");
                }
                String[] uris = new String[inputs.size()];
                for (int i = 0; i < uris.length; ++i) {
                    uris[i] = PathUtilities.pathToURL(inputs.get(i));
                }
                sc = ((MultiInputFormat)inputFormat).load(uris, inputParamArray, outputType, (ErrorHandler)eh, (com.thaiopensource.resolver.Resolver)resolver);
            } else {
                sc = inputFormat.load(PathUtilities.pathToURL(mainInput), inputParamArray, outputType, eh, (com.thaiopensource.resolver.Resolver)resolver);
            }
            if (ext.length() == 0) {
                ext = outputType;
            }
            BuffersOutputDirectory od = new BuffersOutputDirectory(view, sc.getMainUri(), outputFilename);
            outputFormat.output(sc, (OutputDirectory)od, outputParams.toArray(new String[outputParams.size()]), inputType.toLowerCase(), (ErrorHandler)eh);
            String done = jEdit.getProperty((String)"xml.translate.done.message", (Object[])new String[]{String.valueOf(od.getOutputCount())});
            Log.log((int)3, TrangTranslator.class, (Object)done);
            GUIUtilities.message((Component)view, (String)"xml.translate.done", (Object[])new String[]{String.valueOf(od.getOutputCount())});
        }
        catch (OutputFailedException e) {
            GUIUtilities.error((Component)view, (String)"xml.translate.failed", (Object[])new String[]{e.toString()});
            e.printStackTrace();
        }
        catch (InputFailedException e) {
            GUIUtilities.error((Component)view, (String)"xml.translate.failed", (Object[])new String[]{e.toString()});
            e.printStackTrace();
        }
        catch (InvalidParamsException e) {
            GUIUtilities.error((Component)view, (String)"xml.translate.failed", (Object[])new String[]{e.toString()});
            e.printStackTrace();
        }
        catch (IOException e) {
            GUIUtilities.error((Component)view, (String)"xml.translate.failed", (Object[])new String[]{e.toString()});
            e.printStackTrace();
        }
        catch (SAXException e) {
            GUIUtilities.error((Component)view, (String)"xml.translate.failed", (Object[])new String[]{e.toString()});
            e.printStackTrace();
        }
    }

    static {
        inputTypes = new String[]{"rng", "rnc", "dtd", "xml"};
        outputTypes = new String[]{"rng", "rnc", "dtd", "xsd"};
    }
}

