/*
 * Decompiled with CFR 0.152.
 */
package xml.translate;

import common.gui.OkCancelButtons;
import ise.java.awt.KappaLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import xml.gui.VFSFileList;
import xml.gui.VFSFileTextField;
import xml.translate.TrangTranslator;

public class TrangGUI
extends EnhancedDialog {
    private static final String OUTPUT_TYPE_PROP = "xml.translate.output-type";
    private View view;
    private Buffer buffer;
    private VFSFileTextField inputField;
    private VFSFileTextField outputField;
    private JComboBox inputTypeBox;
    private JComboBox outputTypeBox;
    private Map<String, Options> inputOptions;
    private Map<String, Options> outputOptions;

    public TrangGUI(View parent, Buffer buffer) {
        super((Frame)parent, "Trang GUI", false);
        this.view = this.view;
        this.buffer = buffer;
        this.inputOptions = new HashMap<String, Options>();
        this.outputOptions = new HashMap<String, Options>();
        Container c = this.getContentPane();
        c.setLayout((LayoutManager)new KappaLayout());
        JLabel l = new JLabel("Input:");
        c.add((Component)l, "0, 0, 2, 1, E, 0, 5");
        this.inputField = new VFSFileTextField(this.view, "xml.translate.input");
        this.inputField.setFile(buffer.getPath());
        this.inputField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if ("file".equals(pce.getPropertyName())) {
                    String path = (String)pce.getNewValue();
                    final String extension = path.substring(path.length() - 3);
                    if (Arrays.asList(TrangTranslator.inputTypes).contains(extension)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TrangGUI.this.inputTypeBox.setSelectedItem(extension);
                            }
                        });
                    }
                }
            }
        });
        c.add((Component)this.inputField, "2, 0, 7, 1, W, w, 5");
        l = new JLabel("Input Type:");
        c.add((Component)l, "0, 1, 2, 1, E, 0, 5");
        this.inputTypeBox = new JComboBox<String>(TrangTranslator.inputTypes);
        this.inputTypeBox.setName("input-type");
        c.add((Component)this.inputTypeBox, "2, 1, 3, 1, W, 0, 5");
        final CardLayout inputOptionsLayout = new CardLayout();
        final JPanel inputOptionsPanel = new JPanel(inputOptionsLayout);
        inputOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Options..."));
        this.inputOptions.put("rng", new Options(""));
        this.inputOptions.put("rnc", new Options(""));
        this.inputOptions.put("xml", new XMLOptions());
        this.inputOptions.put("dtd", new DTDOptions());
        this.outputOptions.put("rng", new Options(""));
        this.outputOptions.put("rnc", new Options(""));
        this.outputOptions.put("dtd", new Options(""));
        this.outputOptions.put("xsd", new XSDOptions());
        for (Map.Entry<String, Options> options : this.inputOptions.entrySet()) {
            inputOptionsPanel.add((Component)options.getValue(), options.getKey());
        }
        c.add((Component)inputOptionsPanel, "2, 2, 8, 8, 0, hw, 5");
        this.inputTypeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                String newInputType = (String)TrangGUI.this.inputTypeBox.getSelectedItem();
                inputOptionsLayout.show(inputOptionsPanel, (String)evt.getItem());
                for (Options o : TrangGUI.this.outputOptions.values()) {
                    o.inputTypeChanged(newInputType);
                }
            }
        });
        String _guessed = TrangTranslator.guessInputType(buffer);
        if (_guessed == null) {
            _guessed = "rng";
        }
        final String guessed = _guessed;
        this.inputTypeBox.setSelectedItem(guessed);
        l = new JLabel("Output:");
        c.add((Component)l, "0, 10, 2, 1, E, 0, 5");
        String outputType = jEdit.getProperty((String)OUTPUT_TYPE_PROP, (String)"rng");
        String output = buffer.getPath().endsWith(guessed) ? buffer.getPath().replaceAll(guessed + "$", outputType) : buffer.getPath() + "." + outputType;
        this.outputField = new VFSFileTextField(this.view, "xml.translate.output");
        this.outputField.setFile(buffer.getPath());
        c.add((Component)this.outputField, "2, 10, 7, 1, W, w, 5");
        l = new JLabel("Output Type:");
        c.add((Component)l, "0, 11, 2, 1, E, 0, 5");
        this.outputTypeBox = new JComboBox<String>(TrangTranslator.outputTypes);
        this.outputTypeBox.setName("output-type");
        c.add((Component)this.outputTypeBox, "2, 11, 7, 1, W, w, 5");
        final CardLayout outputOptionsLayout = new CardLayout();
        final JPanel outputOptionsPanel = new JPanel(outputOptionsLayout);
        for (Map.Entry<String, Options> options : this.outputOptions.entrySet()) {
            outputOptionsPanel.add((Component)options.getValue(), options.getKey());
        }
        c.add((Component)outputOptionsPanel, "2, 12, 8, 8, 0, hw, 5");
        this.outputTypeBox.addItemListener(new ItemListener(){
            private String oldOutputType;
            {
                this.oldOutputType = guessed;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                String newOutputType = (String)TrangGUI.this.outputTypeBox.getSelectedItem();
                outputOptionsLayout.show(outputOptionsPanel, newOutputType);
                for (Options o : TrangGUI.this.inputOptions.values()) {
                    o.outputTypeChanged(newOutputType);
                }
                if (TrangGUI.this.outputField.getFile().endsWith(this.oldOutputType)) {
                    String out = TrangGUI.this.outputField.getFile();
                    TrangGUI.this.outputField.setFile(out.substring(0, out.length() - 3) + newOutputType);
                    this.oldOutputType = newOutputType;
                }
            }
        });
        this.outputTypeBox.setSelectedItem(guessed);
        c.add((Component)new OkCancelButtons((EnhancedDialog)this), "0, 20, 10, 1, S, 5");
        this.pack();
    }

    public void ok() {
        List<String> inputParams;
        List<String> inputs;
        Options selectedInputOptions = this.inputOptions.get((String)this.inputTypeBox.getSelectedItem());
        Options selectedOutputOptions = this.outputOptions.get((String)this.outputTypeBox.getSelectedItem());
        if (selectedInputOptions instanceof XMLOptions) {
            XMLOptions xo = (XMLOptions)selectedInputOptions;
            inputs = new ArrayList<String>();
            inputs.add(this.inputField.getFile());
            inputs.addAll(xo.getOptions());
            inputParams = Collections.emptyList();
        } else {
            inputs = Collections.singletonList(this.inputField.getFile());
            inputParams = selectedInputOptions.getOptions();
        }
        List<String> outputParams = selectedOutputOptions.getOptions();
        jEdit.setProperty((String)OUTPUT_TYPE_PROP, (String)((String)this.outputTypeBox.getSelectedItem()));
        selectedInputOptions.saveOptions();
        selectedOutputOptions.saveOptions();
        TrangTranslator.translate(this.view, (String)this.inputTypeBox.getSelectedItem(), inputs, inputParams, (String)this.outputTypeBox.getSelectedItem(), this.outputField.getFile(), outputParams);
        this.setVisible(false);
    }

    public void cancel() {
        this.setVisible(false);
    }

    class ComboOption
    extends JComboBox
    implements Option {
        ComboOption(String name, String[] values) {
            super(values);
            this.setName(name);
        }

        @Override
        public String getParamValue() {
            return this.getName() + "=" + this.getSelectedItem();
        }

        @Override
        public void setParamValue(String value) {
            if (value.startsWith(this.getName() + "=")) {
                this.setSelectedItem(value.substring(this.getName().length() + 1));
            } else {
                this.setSelectedItem(value);
            }
        }

        @Override
        public boolean hasValue() {
            return true;
        }
    }

    class CheckOption
    extends JCheckBox
    implements Option {
        private boolean noOption;

        CheckOption(String name, String label, boolean noOption) {
            super(label);
            this.setName(name);
            this.noOption = noOption;
        }

        @Override
        public String getParamValue() {
            if (this.isSelected()) {
                return this.getName();
            }
            if (this.noOption) {
                return "no-" + this.getName();
            }
            return null;
        }

        @Override
        public void setParamValue(String value) {
            this.setSelected(this.getName().equals(value));
        }

        @Override
        public boolean hasValue() {
            return this.noOption || this.isSelected();
        }
    }

    class StringOption
    extends JTextField
    implements Option {
        StringOption(String name) {
            super(20);
            this.setName(name);
        }

        @Override
        public String getParamValue() {
            return this.getName() + "=" + this.getText();
        }

        @Override
        public void setParamValue(String value) {
            if (value.startsWith(this.getName() + "=")) {
                this.setText(value.substring(this.getName().length() + 1));
            } else {
                this.setText(value);
            }
        }

        @Override
        public boolean hasValue() {
            return this.getText().length() > 0;
        }
    }

    static interface Option {
        public String getParamValue();

        public void setParamValue(String var1);

        public boolean hasValue();

        public String getName();
    }

    class XSDOptions
    extends Options {
        XSDOptions() {
            super("xml.translate.xsd.");
            String[] process = new String[]{"strict", "lax", "skip"};
            this.addCheckOption("disable-abstract-elements", false);
            this.addComboOption("any-process-contents", process);
            this.addComboOption("any-attribute-process-contents", process);
        }

        @Override
        public void inputTypeChanged(String newInputType) {
            ((Option)this.options.get("any-process-contents")).setParamValue("dtd".equals(newInputType) ? "strict" : "skip");
        }
    }

    class DTDOptions
    extends Options {
        JTextArea namespaces;

        DTDOptions() {
            super("xml.translate.dtd.");
            this.addStringOption("xmlns");
            this.addCustomOption("namespaces", this.initNamespaces(), 2);
            this.addStringOption("colon-replacement");
            this.addStringOption("element-define");
            this.addCheckOption("inline-attlist", true);
            this.addStringOption("attlist-define");
            this.addStringOption("any-name");
            this.addCheckOption("strict-any", false);
            this.addStringOption("annotation-prefix");
            this.addCheckOption("generate-start", false);
        }

        private JComponent initNamespaces() {
            this.namespaces = new JTextArea(3, 30);
            this.namespaces.setName("namespaces");
            this.namespaces.setText(jEdit.getProperty((String)"xml.translate.dtd.namespaces", (String)""));
            this.namespaces.setToolTipText(jEdit.getProperty((String)"xml.translate.dtd.namespaces.tooltip"));
            this.namespaces.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (10 == e.getKeyCode()) {
                        DTDOptions.this.namespaces.setText(DTDOptions.this.namespaces.getText() + "\n");
                        e.consume();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (10 == e.getKeyCode()) {
                        e.consume();
                    }
                }
            });
            JScrollPane scr = new JScrollPane(this.namespaces);
            return scr;
        }

        @Override
        public void outputTypeChanged(String newOutputType) {
            ((Option)this.options.get("inline-attlist")).setParamValue("xsd".equals(newOutputType) ? "inline-attlist" : "no-inline-attlist");
        }

        @Override
        public List<String> getOptions() {
            String[] nsa;
            List<String> opts = super.getOptions();
            for (String ns : nsa = this.namespaces.getText().split("\\s+")) {
                if ("".equals(ns)) continue;
                opts.add(ns);
            }
            return opts;
        }

        @Override
        public void saveOptions() {
            super.saveOptions();
            jEdit.setProperty((String)"xml.translate.dtd.namespaces", (String)this.namespaces.getText());
        }
    }

    class XMLOptions
    extends Options {
        private VFSFileList list;

        XMLOptions() {
            super("xml.translate.xml.");
            this.setLayout(new BorderLayout());
            JLabel l = new JLabel(jEdit.getProperty((String)"xml.translate.xml-inputs.label"));
            l.setAlignmentX(0.0f);
            this.add((Component)l, "North");
            this.list = new VFSFileList(TrangGUI.this.view, "xml.translate.xml-inputs");
            this.add((Component)this.list, "Center");
        }

        @Override
        public List<String> getOptions() {
            Object[] paths = this.list.getItems();
            ArrayList<String> al = new ArrayList<String>();
            for (int i = 0; i < paths.length; ++i) {
                al.add((String)paths[i]);
            }
            return al;
        }
    }

    class Options
    extends JPanel {
        private int y;
        private String propertyPrefix;
        protected Map<String, Option> options;

        Options(String propertyPrefix) {
            super((LayoutManager)new KappaLayout());
            this.propertyPrefix = propertyPrefix;
            this.options = new HashMap<String, Option>();
        }

        protected final void addStringOption(String name) {
            JLabel l = new JLabel(jEdit.getProperty((String)(this.propertyPrefix + name + ".label")));
            this.add((Component)l, "0, " + this.y + ", 1, 1, E, 0, 5");
            StringOption option = new StringOption(name);
            option.setToolTipText(jEdit.getProperty((String)(this.propertyPrefix + name + ".tooltip")));
            option.setParamValue(jEdit.getProperty((String)(this.propertyPrefix + name)));
            this.options.put(name, option);
            this.add((Component)option, "1, " + this.y + ", 8, 1, W, w, 5");
            ++this.y;
        }

        protected final void addCustomOption(String name, JComponent comp, int h) {
            JLabel l = new JLabel(jEdit.getProperty((String)(this.propertyPrefix + name + ".label")));
            this.add((Component)l, "0, " + this.y + ", 1, 1, E, 0, 5");
            this.add((Component)comp, "1, " + this.y + ", 8, " + h + ", W, w, 5");
            this.y += h;
        }

        protected final void addCheckOption(String name, boolean isNoOption) {
            CheckOption option = new CheckOption(name, jEdit.getProperty((String)(this.propertyPrefix + name + ".label")), isNoOption);
            option.setToolTipText(jEdit.getProperty((String)(this.propertyPrefix + name + ".tooltip")));
            option.setParamValue(jEdit.getProperty((String)(this.propertyPrefix + name)));
            this.options.put(name, option);
            this.add((Component)option, "1, " + this.y + ", 8, 1, W, 0, 5");
            ++this.y;
        }

        protected final void addComboOption(String name, String[] values) {
            JLabel l = new JLabel(jEdit.getProperty((String)(name + ".label")));
            this.add((Component)l, "0, " + this.y + ", 1, 1, E, 0, 5");
            ComboOption option = new ComboOption(name, values);
            option.setToolTipText(jEdit.getProperty((String)(this.propertyPrefix + name + ".tooltip")));
            option.setParamValue(jEdit.getProperty((String)(this.propertyPrefix + name)));
            this.options.put(name, option);
            this.add((Component)option, "1, " + this.y + ", 8, 1, W, w, 5");
            ++this.y;
        }

        public List<String> getOptions() {
            ArrayList<String> res = new ArrayList<String>();
            for (Option o : this.options.values()) {
                if (!o.hasValue()) continue;
                res.add(o.getParamValue());
            }
            return res;
        }

        public void saveOptions() {
            for (Option o : this.options.values()) {
                jEdit.setProperty((String)(this.propertyPrefix + o.getName()), (String)o.getParamValue());
            }
        }

        public void inputTypeChanged(String newInputType) {
        }

        public void outputTypeChanged(String newOutputType) {
        }
    }
}

