/*
 * Decompiled with CFR 0.152.
 */
package xml.translate;

import com.thaiopensource.resolver.AbstractResolver;
import com.thaiopensource.resolver.BasicResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.resolver.xml.ExternalDTDSubsetIdentifier;
import com.thaiopensource.resolver.xml.ExternalEntityIdentifier;
import com.thaiopensource.resolver.xml.ExternalIdentifier;
import com.thaiopensource.resolver.xml.sax.SAX;
import java.io.IOException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public final class EntityResolverWrapper
extends AbstractResolver {
    private final EntityResolver entityResolver;
    private final EntityResolver2 entityResolver2;
    private final boolean promiscuous;

    public EntityResolverWrapper(EntityResolver entityResolver, boolean promiscuous) {
        this.entityResolver = entityResolver;
        this.entityResolver2 = entityResolver instanceof EntityResolver2 ? (EntityResolver2)entityResolver : null;
        this.promiscuous = promiscuous;
    }

    public void resolve(Identifier id, Input input) throws IOException, ResolverException {
        String publicId;
        if (input.isResolved()) {
            return;
        }
        String entityName = null;
        if (id instanceof ExternalIdentifier) {
            publicId = ((ExternalIdentifier)id).getPublicId();
            if (id instanceof ExternalEntityIdentifier) {
                entityName = ((ExternalEntityIdentifier)id).getEntityName();
            } else if (id instanceof ExternalDTDSubsetIdentifier) {
                entityName = "[dtd]";
            }
        } else {
            if (!this.promiscuous) {
                return;
            }
            publicId = null;
        }
        try {
            InputSource inputSource = entityName != null && this.entityResolver2 != null ? this.entityResolver2.resolveEntity(entityName, publicId, id.getBase(), id.getUriReference()) : this.entityResolver.resolveEntity(publicId, EntityResolverWrapper.getSystemId(id));
            if (inputSource != null) {
                SAX.setInput((Input)input, (InputSource)inputSource);
            }
        }
        catch (SAXException e) {
            throw SAX.toResolverException((SAXException)e);
        }
    }

    static String getSystemId(Identifier id) {
        try {
            return BasicResolver.resolveUri((Identifier)id);
        }
        catch (ResolverException resolverException) {
            return id.getUriReference();
        }
    }

    public void open(Input input) throws IOException, ResolverException {
        if (input.isUriDefinitive() && !input.isOpen()) {
            InputSource inputSource;
            try {
                inputSource = this.entityResolver2 != null ? this.entityResolver2.resolveEntity(null, null, null, input.getUri()) : this.entityResolver.resolveEntity(null, input.getUri());
            }
            catch (SAXException e) {
                throw SAX.toResolverException((SAXException)e);
            }
            if (inputSource != null) {
                SAX.setInput((Input)input, (InputSource)inputSource);
            }
        }
    }
}

