/*
 * Decompiled with CFR 0.152.
 */
package xml.translate;

import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.xml.out.CharRepertoire;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.util.Log;

public class BuffersOutputDirectory
implements OutputDirectory {
    private View view;
    private final Map<String, String> uriMap;
    private final String mainInputExtension;
    private final String outputExtension;
    private final String outputDirectory;
    private int outputCount;
    private int indent;
    private int lineLength;

    public BuffersOutputDirectory(View view, String mainInput, String mainOutput) {
        this.view = view;
        this.uriMap = new HashMap<String, String>();
        this.mainInputExtension = MiscUtilities.getFileExtension((String)mainInput);
        this.outputDirectory = MiscUtilities.getParentOfPath((String)mainOutput);
        this.outputExtension = MiscUtilities.getFileExtension((String)mainOutput);
        this.uriMap.put(mainInput, MiscUtilities.getFileName((String)mainOutput));
        Mode outputMode = ModeProvider.instance.getModeForFile(MiscUtilities.getFileName((String)mainOutput), "");
        if (outputMode == null) {
            outputMode = jEdit.getMode((String)"text");
        }
        this.indent = (Integer)outputMode.getProperty("indentSize");
        this.lineLength = (Integer)outputMode.getProperty("maxLineLen");
    }

    public int getIndent() {
        Log.log((int)1, BuffersOutputDirectory.class, (Object)"getIndent()");
        return this.indent;
    }

    public int getLineLength() {
        Log.log((int)1, BuffersOutputDirectory.class, (Object)"getLineLength()");
        return this.lineLength;
    }

    public String getLineSeparator() {
        Log.log((int)1, BuffersOutputDirectory.class, (Object)"getLineSeparator()");
        return "\n";
    }

    public OutputDirectory.Stream open(String sourceUri, String ignoredEncoding) throws UnsupportedEncodingException {
        Log.log((int)1, BuffersOutputDirectory.class, (Object)("open(" + sourceUri + "," + ignoredEncoding + ")"));
        String newSourceURI = MiscUtilities.constructPath(null, (String)this.outputDirectory, (String)this.mapFilename(sourceUri));
        Log.log((int)1, BuffersOutputDirectory.class, (Object)("===>" + newSourceURI));
        Buffer b = jEdit.openFile((View)this.view, (String)newSourceURI);
        BufferWriter writer = new BufferWriter(b);
        String encoding = (String)b.getProperty((Object)"encoding");
        CharRepertoire repertoire = CharRepertoire.getInstance((String)encoding);
        ++this.outputCount;
        return new OutputDirectory.Stream((Writer)writer, encoding, repertoire);
    }

    public void setEncoding(String encoding) {
        Log.log((int)1, BuffersOutputDirectory.class, (Object)("setEncoding(" + encoding + ")"));
    }

    public void setIndent(int indent) {
        Log.log((int)1, BuffersOutputDirectory.class, (Object)("setIndent(" + indent + ")"));
    }

    public String reference(String fromSourceUri, String toSourceUri) {
        Log.log((int)1, BuffersOutputDirectory.class, (Object)("reference(" + fromSourceUri + "," + toSourceUri + ")"));
        Log.log((int)1, BuffersOutputDirectory.class, (Object)("===>" + this.mapFilename(toSourceUri) + ")"));
        return this.mapFilename(toSourceUri);
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    private String mapFilename(String sourceUri) {
        String filename = this.uriMap.get(sourceUri);
        if (filename == null) {
            filename = this.chooseFilename(sourceUri);
            this.uriMap.put(sourceUri, filename);
        }
        return filename;
    }

    private String chooseFilename(String sourceUri) {
        String filename = MiscUtilities.getFileName((String)sourceUri);
        String base = filename.endsWith(this.mainInputExtension) ? filename.substring(0, filename.length() - this.mainInputExtension.length()) : filename;
        filename = base + this.outputExtension;
        int i = 1;
        while (this.uriMap.containsValue(filename)) {
            filename = base + Integer.toString(i) + this.outputExtension;
            ++i;
        }
        return filename;
    }

    public static class BufferWriter
    extends StringWriter {
        private Buffer targetBuffer;

        public BufferWriter(Buffer targetBuffer) {
            this.targetBuffer = targetBuffer;
        }

        @Override
        public void close() throws IOException {
            super.close();
            VFSManager.waitForRequests();
            this.targetBuffer.beginCompoundEdit();
            this.targetBuffer.remove(0, this.targetBuffer.getLength());
            this.targetBuffer.insert(0, this.toString());
            this.targetBuffer.endCompoundEdit();
        }
    }
}

