/*
 * Decompiled with CFR 0.152.
 */
package xml.translate;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.dtd.DtdInputFormat;
import com.thaiopensource.relaxng.input.dtd.ResolverEntityManager;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.translate.util.AbsoluteUriParam;
import com.thaiopensource.relaxng.translate.util.AbstractParam;
import com.thaiopensource.relaxng.translate.util.InvalidParamValueException;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.relaxng.translate.util.NCNameParam;
import com.thaiopensource.relaxng.translate.util.NmtokenParam;
import com.thaiopensource.relaxng.translate.util.Param;
import com.thaiopensource.relaxng.translate.util.ParamFactory;
import com.thaiopensource.relaxng.translate.util.ParamProcessor;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.xml.dtd.om.Dtd;
import com.thaiopensource.xml.dtd.parse.DtdParserImpl;
import com.thaiopensource.xml.dtd.parse.ParseException;
import com.thaiopensource.xml.em.EntityManager;
import com.thaiopensource.xml.util.Naming;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import xml.translate.BufferDtdConverter;

public class BufferDtdInputFormat
extends DtdInputFormat {
    public SchemaCollection load(String uri, String[] params, String outputFormat, ErrorHandler eh, Resolver resolver) throws InvalidParamsException, IOException, SAXException {
        ErrorReporter er = new ErrorReporter(eh, DtdInputFormat.class);
        final BufferDtdConverter.Options options = new BufferDtdConverter.Options();
        if ("xsd".equals(outputFormat)) {
            options.inlineAttlistDecls = true;
            options.generateStart = false;
        }
        ParamProcessor pp = new ParamProcessor();
        pp.declare("inline-attlist", (Param)new AbstractParam(){

            public void set(boolean value) {
                options.inlineAttlistDecls = value;
            }
        });
        pp.declare("xmlns", (Param)new AbsoluteUriParam(){

            public void set(String value) throws InvalidParamValueException {
                if (value.equals("")) {
                    this.setAbsoluteUri(value);
                } else {
                    super.set(value);
                }
            }

            protected void setAbsoluteUri(String value) {
                options.defaultNamespace = value;
            }
        });
        pp.declare("any-name", (Param)new NCNameParam(){

            protected void setNCName(String value) {
                options.anyName = value;
            }
        });
        pp.declare("strict-any", (Param)new AbstractParam(){

            public void set(boolean value) {
                options.strictAny = value;
            }
        });
        pp.declare("annotation-prefix", (Param)new NCNameParam(){

            protected void setNCName(String value) {
                options.annotationPrefix = value;
            }
        });
        pp.declare("colon-replacement", (Param)new NmtokenParam(){

            protected void setNmtoken(String value) {
                options.colonReplacement = value;
            }
        });
        pp.declare("generate-start", (Param)new AbstractParam(){

            public void set(boolean value) {
                options.generateStart = value;
            }
        });
        pp.declare("element-define", (Param)new DeclPatternParam(er.getLocalizer()){

            @Override
            void setDeclPattern(String pattern) {
                options.elementDeclPattern = pattern;
            }
        });
        pp.declare("attlist-define", (Param)new DeclPatternParam(er.getLocalizer()){

            @Override
            void setDeclPattern(String pattern) {
                options.attlistDeclPattern = pattern;
            }
        });
        pp.setParamFactory((ParamFactory)new NamespaceDeclParamFactory(options.prefixMap));
        pp.process(params, eh);
        try {
            ResolverEntityManager em = new ResolverEntityManager(resolver);
            Dtd dtd = new DtdParserImpl().parse(em.open(uri), (EntityManager)em);
            try {
                return new BufferDtdConverter(dtd, er, options).convert();
            }
            catch (ErrorReporter.WrappedSAXException e) {
                throw e.getException();
            }
        }
        catch (ParseException e) {
            throw new SAXParseException(e.getMessageBody(), null, e.getLocation(), e.getLineNumber(), e.getColumnNumber());
        }
    }

    private static abstract class DeclPatternParam
    extends AbstractParam {
        private final Localizer localizer;

        DeclPatternParam(Localizer localizer) {
            this.localizer = localizer;
        }

        public void set(String value) throws InvalidParamValueException {
            if (value.indexOf(37) < 0) {
                throw new InvalidParamValueException(this.localizer.message("no_percent"));
            }
            if (value.lastIndexOf(37) != value.indexOf(37)) {
                throw new InvalidParamValueException(this.localizer.message("multiple_percent"));
            }
            if (!Naming.isNcname((String)value.replace('%', 'x'))) {
                throw new InvalidParamValueException(this.localizer.message("not_ncname_with_percent"));
            }
            this.setDeclPattern(value);
        }

        abstract void setDeclPattern(String var1);
    }

    private static class NamespaceDeclParamFactory
    implements ParamFactory {
        private final Map<String, String> prefixMap;

        NamespaceDeclParamFactory(Map<String, String> prefixMap) {
            this.prefixMap = prefixMap;
        }

        public Param createParam(String name) {
            if (!name.startsWith("xmlns:")) {
                return null;
            }
            final String prefix = name.substring(6);
            if (!Naming.isNcname((String)prefix)) {
                return null;
            }
            return new AbsoluteUriParam(){

                public void setAbsoluteUri(String uri) {
                    NamespaceDeclParamFactory.this.prefixMap.put(prefix, uri);
                }
            };
        }
    }
}

