/*
 * Decompiled with CFR 0.152.
 */
package xml.translate;

import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.input.CommentTrimmer;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.xml.dtd.om.AttributeDefault;
import com.thaiopensource.xml.dtd.om.AttributeGroup;
import com.thaiopensource.xml.dtd.om.AttributeGroupMember;
import com.thaiopensource.xml.dtd.om.AttributeGroupVisitor;
import com.thaiopensource.xml.dtd.om.Datatype;
import com.thaiopensource.xml.dtd.om.DatatypeVisitor;
import com.thaiopensource.xml.dtd.om.Def;
import com.thaiopensource.xml.dtd.om.Dtd;
import com.thaiopensource.xml.dtd.om.EnumGroup;
import com.thaiopensource.xml.dtd.om.EnumGroupVisitor;
import com.thaiopensource.xml.dtd.om.Flag;
import com.thaiopensource.xml.dtd.om.ModelGroup;
import com.thaiopensource.xml.dtd.om.ModelGroupVisitor;
import com.thaiopensource.xml.dtd.om.NameSpec;
import com.thaiopensource.xml.dtd.om.TokenizedDatatype;
import com.thaiopensource.xml.dtd.om.TopLevel;
import com.thaiopensource.xml.dtd.om.TopLevelVisitor;
import com.thaiopensource.xml.em.ExternalId;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class BufferDtdConverter {
    private final Dtd dtd;
    private final ErrorReporter er;
    private final SchemaCollection sc = new SchemaCollection();
    private final Options options;
    private boolean hadAny = false;
    private boolean hadDefaultValue = false;
    private final Map<String, Integer> elementNameTable = new HashMap<String, Integer>();
    private final Map<String, List<AttributeGroup>> attlistDeclTable = new HashMap<String, List<AttributeGroup>>();
    private final Set<String> definedNames = new HashSet<String>();
    private final Map<String, String> prefixTable = new HashMap<String, String>();
    private final Map<String, Set<String>> attributeNamesTable = new HashMap<String, Set<String>>();
    private Set<String> attributeNames = null;
    private String defaultNamespace = null;
    private String annotationPrefix = null;
    private String colonReplacement = null;
    private String elementDeclPattern = null;
    private String attlistDeclPattern = null;
    private String anyName = null;
    private static final int ELEMENT_DECL = 1;
    private static final int ATTLIST_DECL = 2;
    private static final int ELEMENT_REF = 4;
    private static final String SEPARATORS = ".-_";
    private static final String DEFAULT_PATTERN = "#.%";
    private final String[] ELEMENT_KEYWORDS = new String[]{"element", "elem", "e"};
    private final String[] ATTLIST_KEYWORDS = new String[]{"attlist", "attributes", "attribs", "atts", "a"};
    private final String[] ANY_KEYWORDS = new String[]{"any", "ANY", "anyElement"};

    public BufferDtdConverter(Dtd dtd, ErrorReporter er, Options options) {
        this.dtd = dtd;
        this.er = er;
        this.options = options;
    }

    public SchemaCollection convert() {
        try {
            this.dtd.accept((TopLevelVisitor)new Analyzer());
            this.chooseNames();
            GrammarPattern grammar = new GrammarPattern();
            this.sc.setMainUri(this.dtd.getUri());
            this.sc.getSchemaDocumentMap().put(this.dtd.getUri(), new SchemaDocument((Pattern)grammar, this.dtd.getEncoding()));
            ComponentOutput co = new ComponentOutput(grammar);
            this.dtd.accept((TopLevelVisitor)co);
            this.outputUndefinedElements(grammar.getComponents());
            if (this.options.generateStart) {
                this.outputStart(grammar.getComponents());
            }
            this.outputAny(grammar.getComponents());
            co.finish();
            return this.sc;
        }
        catch (Exception e) {
            throw (RuntimeException)e;
        }
    }

    private void chooseNames() {
        this.chooseAny();
        this.chooseColonReplacement();
        this.chooseDeclPatterns();
        this.choosePrefixes();
        this.chooseAnnotationPrefix();
    }

    private void chooseAny() {
        if (!this.hadAny) {
            return;
        }
        if (this.options.anyName != null) {
            if (!this.definedNames.contains(this.options.anyName)) {
                this.anyName = this.options.anyName;
                this.definedNames.add(this.anyName);
                return;
            }
            this.warning("cannot_use_any_name");
        }
        int n = 0;
        while (true) {
            for (int i = 0; i < this.ANY_KEYWORDS.length; ++i) {
                this.anyName = BufferDtdConverter.repeatChar('_', n) + this.ANY_KEYWORDS[i];
                if (this.definedNames.contains(this.anyName)) continue;
                this.definedNames.add(this.anyName);
                return;
            }
            ++n;
        }
    }

    private void choosePrefixes() {
        if (this.options.defaultNamespace != null) {
            if (this.defaultNamespace != null && !this.defaultNamespace.equals(this.options.defaultNamespace)) {
                this.warning("default_namespace_conflict");
            }
            this.defaultNamespace = this.options.defaultNamespace;
        } else if (this.defaultNamespace == null) {
            this.defaultNamespace = NameClass.INHERIT_NS;
        }
        for (Map.Entry<String, String> entry : this.options.prefixMap.entrySet()) {
            String prefix = entry.getKey();
            String ns = entry.getValue();
            String s = this.prefixTable.get(prefix);
            if (s == null) {
                this.warning("irrelevant_prefix", prefix);
                continue;
            }
            if (!s.equals("") && !s.equals(ns)) {
                this.warning("prefix_conflict", prefix);
            }
            this.prefixTable.put(prefix, ns);
        }
    }

    private void chooseAnnotationPrefix() {
        if (!this.hadDefaultValue) {
            return;
        }
        if (this.options.annotationPrefix != null) {
            if (this.prefixTable.get(this.options.annotationPrefix) == null) {
                this.annotationPrefix = this.options.annotationPrefix;
                return;
            }
            this.warning("cannot_use_annotation_prefix");
        }
        int n = 0;
        while (true) {
            this.annotationPrefix = BufferDtdConverter.repeatChar('_', n) + "a";
            if (this.prefixTable.get(this.annotationPrefix) == null) {
                return;
            }
            ++n;
        }
    }

    private void chooseColonReplacement() {
        if (this.options.colonReplacement != null) {
            this.colonReplacement = this.options.colonReplacement;
            if (this.colonReplacementOk()) {
                return;
            }
            this.warning("cannot_use_colon_replacement");
            this.colonReplacement = null;
        }
        if (this.colonReplacementOk()) {
            return;
        }
        int n = 1;
        while (true) {
            for (int i = 0; i < SEPARATORS.length(); ++i) {
                this.colonReplacement = BufferDtdConverter.repeatChar(SEPARATORS.charAt(i), n);
                if (!this.colonReplacementOk()) continue;
                return;
            }
            ++n;
        }
    }

    private boolean colonReplacementOk() {
        HashSet<String> names = new HashSet<String>();
        for (String s : this.elementNameTable.keySet()) {
            String name = this.mungeQName(s);
            if (names.contains(name)) {
                return false;
            }
            names.add(name);
        }
        return true;
    }

    private void chooseDeclPatterns() {
        if (this.options.elementDeclPattern != null) {
            if (this.patternOk(this.options.elementDeclPattern, null)) {
                this.elementDeclPattern = this.options.elementDeclPattern;
            } else {
                this.warning("cannot_use_element_decl_pattern");
            }
        }
        if (this.options.attlistDeclPattern != null) {
            if (this.patternOk(this.options.attlistDeclPattern, this.elementDeclPattern)) {
                this.attlistDeclPattern = this.options.attlistDeclPattern;
            } else {
                this.warning("cannot_use_attlist_decl_pattern");
            }
        }
        if (this.elementDeclPattern != null && this.attlistDeclPattern != null) {
            return;
        }
        String pattern = this.namingPattern();
        if (this.elementDeclPattern == null) {
            this.elementDeclPattern = this.patternOk("%", this.attlistDeclPattern) ? "%" : this.choosePattern(pattern, this.ELEMENT_KEYWORDS, this.attlistDeclPattern);
        }
        if (this.attlistDeclPattern == null) {
            this.attlistDeclPattern = this.choosePattern(pattern, this.ATTLIST_KEYWORDS, this.elementDeclPattern);
        }
    }

    private String choosePattern(String metaPattern, String[] keywords, String otherPattern) {
        while (true) {
            for (int i = 0; i < keywords.length; ++i) {
                String pattern = BufferDtdConverter.substitute(metaPattern, '#', keywords[i]);
                if (!this.patternOk(pattern, otherPattern)) continue;
                return pattern;
            }
            metaPattern = metaPattern.substring(0, 1) + metaPattern.substring(1, 2) + metaPattern.substring(1, 2) + metaPattern.substring(2);
        }
    }

    private String namingPattern() {
        HashMap<String, Integer> patternTable = new HashMap<String, Integer>();
        for (String name : this.definedNames) {
            for (int i = 0; i < SEPARATORS.length(); ++i) {
                char sep = SEPARATORS.charAt(i);
                int k = name.indexOf(sep);
                if (k > 0) {
                    BufferDtdConverter.inc(patternTable, name.substring(0, k + 1) + "%");
                }
                if ((k = name.lastIndexOf(sep)) < 0 || k >= name.length() - 1) continue;
                BufferDtdConverter.inc(patternTable, "%" + name.substring(k));
            }
        }
        String bestPattern = null;
        int bestCount = 0;
        for (Map.Entry entry : patternTable.entrySet()) {
            int count = (Integer)entry.getValue();
            if (bestPattern != null && count <= bestCount) continue;
            bestCount = count;
            bestPattern = (String)entry.getKey();
        }
        if (bestPattern == null) {
            return DEFAULT_PATTERN;
        }
        if (bestPattern.charAt(0) == '%') {
            return bestPattern.substring(0, 2) + "#";
        }
        return "#" + bestPattern.substring(bestPattern.length() - 2);
    }

    private static void inc(Map<String, Integer> table, String str) {
        Integer n = table.get(str);
        if (n == null) {
            table.put(str, 1);
        } else {
            table.put(str, n + 1);
        }
    }

    private boolean patternOk(String pattern, String otherPattern) {
        HashSet<String> usedNames = new HashSet<String>();
        for (String s : this.elementNameTable.keySet()) {
            String name = this.mungeQName(s);
            String declName = BufferDtdConverter.substitute(pattern, '%', name);
            if (this.definedNames.contains(declName)) {
                return false;
            }
            if (otherPattern == null) continue;
            String otherDeclName = BufferDtdConverter.substitute(otherPattern, '%', name);
            if (usedNames.contains(declName) || usedNames.contains(otherDeclName) || declName.equals(otherDeclName)) {
                return false;
            }
            usedNames.add(declName);
            usedNames.add(otherDeclName);
        }
        return true;
    }

    private void noteDef(String name) {
        this.definedNames.add(name);
    }

    private void noteElementName(String name, int flags) {
        Integer n = this.elementNameTable.get(name);
        if (n != null) {
            if (n == (flags |= n.intValue())) {
                return;
            }
        } else {
            this.noteNamePrefix(name);
        }
        this.elementNameTable.put(name, flags);
    }

    private void noteAttlist(String name, AttributeGroup group) {
        List<AttributeGroup> groups = this.attlistDeclTable.get(name);
        if (groups == null) {
            groups = new Vector<AttributeGroup>();
            this.attlistDeclTable.put(name, groups);
        }
        groups.add(group);
    }

    private void noteAttribute(String name, String defaultValue) {
        if (name.equals("xmlns")) {
            if (defaultValue != null) {
                if (this.defaultNamespace != null && !this.defaultNamespace.equals(defaultValue)) {
                    this.error("INCONSISTENT_DEFAULT_NAMESPACE");
                } else {
                    this.defaultNamespace = defaultValue;
                }
            }
        } else if (name.startsWith("xmlns:")) {
            if (defaultValue != null) {
                String prefix = name.substring(6);
                String ns = this.prefixTable.get(prefix);
                if (ns != null && !ns.equals("") && !ns.equals(defaultValue)) {
                    this.error("INCONSISTENT_PREFIX", prefix);
                } else if (!prefix.equals("xml")) {
                    this.prefixTable.put(prefix, defaultValue);
                }
            }
        } else {
            if (defaultValue != null) {
                this.hadDefaultValue = true;
            }
            this.noteNamePrefix(name);
        }
    }

    private void noteNamePrefix(String name) {
        int i = name.indexOf(58);
        if (i < 0) {
            return;
        }
        String prefix = name.substring(0, i);
        if (this.prefixTable.get(prefix) == null && !prefix.equals("xml")) {
            this.prefixTable.put(prefix, "");
        }
    }

    private int nameFlags(String name) {
        Integer n = this.elementNameTable.get(name);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private String elementDeclName(String name) {
        return BufferDtdConverter.substitute(this.elementDeclPattern, '%', this.mungeQName(name));
    }

    private String attlistDeclName(String name) {
        return BufferDtdConverter.substitute(this.attlistDeclPattern, '%', this.mungeQName(name));
    }

    private String mungeQName(String name) {
        if (this.colonReplacement == null) {
            int i = name.indexOf(58);
            if (i < 0) {
                return name;
            }
            return name.substring(i + 1);
        }
        return BufferDtdConverter.substitute(name, ':', this.colonReplacement);
    }

    private static String repeatChar(char c, int n) {
        char[] buf = new char[n];
        for (int i = 0; i < n; ++i) {
            buf[i] = c;
        }
        return new String(buf);
    }

    private static String substitute(String pattern, char ch, String value) {
        int i = pattern.indexOf(ch);
        if (i < 0) {
            return pattern;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(pattern.substring(0, i));
        buf.append(value);
        buf.append(pattern.substring(i + 1));
        return buf.toString();
    }

    private void outputStart(List<Component> components) {
        ChoicePattern choice = new ChoicePattern();
        int mask = 5;
        while (true) {
            boolean gotOne = false;
            for (Map.Entry<String, Integer> entry : this.elementNameTable.entrySet()) {
                if ((entry.getValue() & mask) != 1) continue;
                gotOne = true;
                choice.getChildren().add(BufferDtdConverter.ref(this.elementDeclName(entry.getKey())));
            }
            if (gotOne) break;
            if (mask == 1) {
                return;
            }
            mask = 1;
        }
        components.add((Component)new DefineComponent(DefineComponent.START, (Pattern)choice));
    }

    private void outputAny(List<Component> components) {
        if (!this.hadAny) {
            return;
        }
        if (this.options.strictAny) {
            DefineComponent dc = new DefineComponent(this.anyName, (Pattern)new TextPattern());
            dc.setCombine(Combine.CHOICE);
            components.add((Component)dc);
        } else {
            GroupPattern group = new GroupPattern();
            group.getChildren().add(new ZeroOrMorePattern((Pattern)new AttributePattern((NameClass)new AnyNameNameClass(), (Pattern)new TextPattern())));
            group.getChildren().add(BufferDtdConverter.ref(this.anyName));
            ChoicePattern choice = new ChoicePattern();
            choice.getChildren().add(new ElementPattern((NameClass)new AnyNameNameClass(), (Pattern)group));
            choice.getChildren().add(new TextPattern());
            components.add((Component)new DefineComponent(this.anyName, (Pattern)new ZeroOrMorePattern((Pattern)choice)));
        }
    }

    private void outputUndefinedElements(List<Component> components) {
        Vector<String> elementNames = new Vector<String>();
        elementNames.addAll(this.elementNameTable.keySet());
        Collections.sort(elementNames);
        for (String elementName : elementNames) {
            if ((this.elementNameTable.get(elementName) & 1) != 0) continue;
            DefineComponent dc = new DefineComponent(this.elementDeclName(elementName), (Pattern)new NotAllowedPattern());
            dc.setCombine(Combine.CHOICE);
            components.add((Component)dc);
        }
    }

    private static Pattern ref(String name) {
        return new RefPattern(name);
    }

    private void error(String key) {
        this.er.error(key, null);
    }

    private void error(String key, String arg) {
        this.er.error(key, arg, null);
    }

    private void warning(String key) {
        this.er.warning(key, null);
    }

    private void warning(String key, String arg) {
        this.er.warning(key, arg, null);
    }

    private static String[] valueType(Datatype datatype) {
        datatype = datatype.deref();
        switch (datatype.getType()) {
            case 0: {
                return new String[]{"", "string"};
            }
            case 1: {
                return new String[]{"http://www.w3.org/2001/XMLSchema-datatypes", ((TokenizedDatatype)datatype).getTypeName()};
            }
        }
        return new String[]{"", "token"};
    }

    private Pattern convert(ModelGroup mg) throws Exception {
        ModelGroupOutput mgo = new ModelGroupOutput();
        mg.accept((ModelGroupVisitor)mgo);
        return mgo.pattern;
    }

    private Pattern convert(Datatype dt) throws Exception {
        DatatypeOutput dto = new DatatypeOutput();
        dt.accept((DatatypeVisitor)dto);
        return dto.pattern;
    }

    private Pattern convert(AttributeGroup ag) throws Exception {
        GroupPattern group = new GroupPattern();
        ag.accept((AttributeGroupVisitor)new AttributeGroupOutput(group));
        switch (group.getChildren().size()) {
            case 0: {
                return new EmptyPattern();
            }
            case 1: {
                return (Pattern)group.getChildren().get(0);
            }
        }
        return group;
    }

    private NameClass convertQName(String name, boolean useDefault) {
        String ns;
        int i = name.indexOf(58);
        if (i < 0) {
            return new NameNameClass(useDefault ? this.defaultNamespace : "", name);
        }
        String prefix = name.substring(0, i);
        String localName = name.substring(i + 1);
        if (prefix.equals("xml")) {
            ns = "http://www.w3.org/XML/1998/namespace";
        } else {
            ns = this.prefixTable.get(prefix);
            if (ns.equals("")) {
                this.error("UNDECLARED_PREFIX", prefix);
                ns = "##" + prefix;
                this.prefixTable.put(prefix, ns);
            }
        }
        NameNameClass nnc = new NameNameClass(ns, localName);
        nnc.setPrefix(prefix);
        return nnc;
    }

    private class SignificanceDetector
    extends VisitorBase {
        boolean significant;

        private SignificanceDetector() {
            this.significant = false;
        }

        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            this.significant = true;
        }

        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            this.significant = true;
        }

        public void modelGroupDef(String name, ModelGroup modelGroup) throws Exception {
            this.significant = true;
        }

        public void attributeGroupDef(String name, AttributeGroup attributeGroup) throws Exception {
            this.significant = true;
        }

        public void enumGroupDef(String name, EnumGroup enumGroup) {
            this.significant = true;
        }

        public void datatypeDef(String name, Datatype datatype) {
            this.significant = true;
        }
    }

    private class DuplicateAttributeDetector
    implements AttributeGroupVisitor {
        private boolean containsDuplicate = false;
        private final List<String> names = new Vector<String>();

        private DuplicateAttributeDetector() {
        }

        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) {
            String name = nameSpec.getValue();
            if (BufferDtdConverter.this.attributeNames.contains(name)) {
                this.containsDuplicate = true;
            }
            this.names.add(name);
        }

        public void attributeGroupRef(String name, AttributeGroup attributeGroup) throws Exception {
            attributeGroup.accept((AttributeGroupVisitor)this);
        }
    }

    private class ModelGroupOutput
    implements ModelGroupVisitor {
        private Pattern pattern;

        private ModelGroupOutput() {
        }

        public void choice(ModelGroup[] members) throws Exception {
            if (members.length == 0) {
                this.pattern = new NotAllowedPattern();
            } else if (members.length == 1) {
                members[0].accept((ModelGroupVisitor)this);
            } else {
                ChoicePattern tem = new ChoicePattern();
                this.pattern = tem;
                List children = tem.getChildren();
                for (int i = 0; i < members.length; ++i) {
                    children.add(BufferDtdConverter.this.convert(members[i]));
                }
            }
        }

        public void sequence(ModelGroup[] members) throws Exception {
            if (members.length == 0) {
                this.pattern = new EmptyPattern();
            } else if (members.length == 1) {
                members[0].accept((ModelGroupVisitor)this);
            } else {
                GroupPattern tem = new GroupPattern();
                this.pattern = tem;
                List children = tem.getChildren();
                for (int i = 0; i < members.length; ++i) {
                    children.add(BufferDtdConverter.this.convert(members[i]));
                }
            }
        }

        public void oneOrMore(ModelGroup member) throws Exception {
            this.pattern = new OneOrMorePattern(BufferDtdConverter.this.convert(member));
        }

        public void zeroOrMore(ModelGroup member) throws Exception {
            this.pattern = new ZeroOrMorePattern(BufferDtdConverter.this.convert(member));
        }

        public void optional(ModelGroup member) throws Exception {
            this.pattern = new OptionalPattern(BufferDtdConverter.this.convert(member));
        }

        public void modelGroupRef(String name, ModelGroup modelGroup) {
            this.pattern = BufferDtdConverter.ref(name);
        }

        public void elementRef(NameSpec name) {
            this.pattern = BufferDtdConverter.ref(BufferDtdConverter.this.elementDeclName(name.getValue()));
        }

        public void pcdata() {
            this.pattern = new TextPattern();
        }

        public void any() {
            this.pattern = BufferDtdConverter.ref(BufferDtdConverter.this.anyName);
            if (((BufferDtdConverter)BufferDtdConverter.this).options.strictAny) {
                this.pattern = new ZeroOrMorePattern(this.pattern);
            }
        }
    }

    private class EnumGroupOutput
    implements EnumGroupVisitor {
        private final List<Pattern> list;

        EnumGroupOutput(ChoicePattern choice) {
            this.list = choice.getChildren();
        }

        public void enumValue(String value) {
            this.list.add((Pattern)new ValuePattern("", "token", value));
        }

        public void enumGroupRef(String name, EnumGroup enumGroup) {
            this.list.add(BufferDtdConverter.ref(name));
        }
    }

    private class DatatypeOutput
    implements DatatypeVisitor {
        Pattern pattern;

        private DatatypeOutput() {
        }

        public void cdataDatatype() {
            this.pattern = new DataPattern("", "string");
        }

        public void tokenizedDatatype(String typeName) {
            this.pattern = new DataPattern("http://www.w3.org/2001/XMLSchema-datatypes", typeName);
        }

        public void enumDatatype(EnumGroup enumGroup) throws Exception {
            if (enumGroup.getMembers().length == 0) {
                this.pattern = new NotAllowedPattern();
            } else {
                ChoicePattern tem = new ChoicePattern();
                this.pattern = tem;
                enumGroup.accept((EnumGroupVisitor)new EnumGroupOutput(tem));
            }
        }

        public void notationDatatype(EnumGroup enumGroup) throws Exception {
            this.enumDatatype(enumGroup);
        }

        public void datatypeRef(String name, Datatype datatype) {
            this.pattern = BufferDtdConverter.ref(name);
        }
    }

    private class AttributeGroupOutput
    implements AttributeGroupVisitor {
        final List<Pattern> group;

        AttributeGroupOutput(GroupPattern gp) {
            this.group = gp.getChildren();
        }

        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) throws Exception {
            Object dt;
            String name = nameSpec.getValue();
            if (BufferDtdConverter.this.attributeNames.contains(name)) {
                return;
            }
            BufferDtdConverter.this.attributeNames.add(name);
            if (name.equals("xmlns") || name.startsWith("xmlns:")) {
                return;
            }
            String dv = attributeDefault.getDefaultValue();
            String fv = attributeDefault.getFixedValue();
            if (fv != null) {
                String[] typeName = BufferDtdConverter.valueType(datatype);
                dt = new ValuePattern(typeName[0], typeName[1], fv);
            } else {
                dt = datatype.getType() != 0 ? BufferDtdConverter.this.convert(datatype) : new TextPattern();
            }
            AttributePattern pattern = new AttributePattern(BufferDtdConverter.this.convertQName(name, false), (Pattern)dt);
            if (dv != null) {
                AttributeAnnotation anno = new AttributeAnnotation("http://relaxng.org/ns/compatibility/annotations/1.0", "defaultValue", dv);
                anno.setPrefix(BufferDtdConverter.this.annotationPrefix);
                pattern.getAttributeAnnotations().add(anno);
            }
            if (!attributeDefault.isRequired()) {
                this.group.add((Pattern)new OptionalPattern((Pattern)pattern));
            } else {
                this.group.add((Pattern)pattern);
            }
        }

        public void attributeGroupRef(String name, AttributeGroup attributeGroup) throws Exception {
            DuplicateAttributeDetector detector = new DuplicateAttributeDetector();
            attributeGroup.accept((AttributeGroupVisitor)detector);
            if (detector.containsDuplicate) {
                attributeGroup.accept((AttributeGroupVisitor)this);
            } else {
                this.group.add(BufferDtdConverter.ref(name));
                BufferDtdConverter.this.attributeNames.addAll(detector.names);
            }
        }
    }

    private class ComponentOutput
    extends VisitorBase {
        private final List<Component> components;
        private final Annotated grammar;
        private List<Comment> comments;

        ComponentOutput(GrammarPattern grammar) {
            this.comments = null;
            this.components = grammar.getComponents();
            this.grammar = grammar;
        }

        void finish() {
            if (this.comments != null) {
                this.grammar.getFollowingElementAnnotations().addAll(this.comments);
            }
        }

        private void addComponent(Component c) {
            if (this.comments != null) {
                if (this.components.isEmpty()) {
                    this.grammar.getLeadingComments().addAll(this.comments);
                } else {
                    c.getLeadingComments().addAll(this.comments);
                }
                this.comments = null;
            }
            this.components.add(c);
        }

        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            DefineComponent dc;
            GroupPattern gp = new GroupPattern();
            if (((BufferDtdConverter)BufferDtdConverter.this).options.inlineAttlistDecls) {
                List groups = (List)BufferDtdConverter.this.attlistDeclTable.get(nameSpec.getValue());
                if (groups != null) {
                    BufferDtdConverter.this.attributeNames = new HashSet();
                    AttributeGroupOutput agv = new AttributeGroupOutput(gp);
                    for (AttributeGroup group : groups) {
                        group.accept((AttributeGroupVisitor)agv);
                    }
                }
            } else {
                gp.getChildren().add(BufferDtdConverter.ref(BufferDtdConverter.this.attlistDeclName(nameSpec.getValue())));
            }
            Pattern pattern = BufferDtdConverter.this.convert(modelGroup);
            if (gp.getChildren().size() > 0) {
                if (pattern instanceof GroupPattern) {
                    gp.getChildren().addAll(((GroupPattern)pattern).getChildren());
                } else {
                    gp.getChildren().add(pattern);
                }
                pattern = gp;
            }
            this.addComponent((Component)new DefineComponent(BufferDtdConverter.this.elementDeclName(nameSpec.getValue()), (Pattern)new ElementPattern(BufferDtdConverter.this.convertQName(nameSpec.getValue(), true), pattern)));
            if (!((BufferDtdConverter)BufferDtdConverter.this).options.inlineAttlistDecls && (BufferDtdConverter.this.nameFlags(nameSpec.getValue()) & 2) == 0) {
                dc = new DefineComponent(BufferDtdConverter.this.attlistDeclName(nameSpec.getValue()), (Pattern)new EmptyPattern());
                dc.setCombine(Combine.INTERLEAVE);
                this.addComponent((Component)dc);
            }
            if (BufferDtdConverter.this.anyName != null && ((BufferDtdConverter)BufferDtdConverter.this).options.strictAny) {
                dc = new DefineComponent(BufferDtdConverter.this.anyName, BufferDtdConverter.ref(BufferDtdConverter.this.elementDeclName(nameSpec.getValue())));
                dc.setCombine(Combine.CHOICE);
                this.addComponent((Component)dc);
            }
        }

        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            Pattern pattern;
            if (((BufferDtdConverter)BufferDtdConverter.this).options.inlineAttlistDecls) {
                return;
            }
            String name = nameSpec.getValue();
            BufferDtdConverter.this.attributeNames = (Set)BufferDtdConverter.this.attributeNamesTable.get(name);
            if (BufferDtdConverter.this.attributeNames == null) {
                BufferDtdConverter.this.attributeNames = new HashSet();
                BufferDtdConverter.this.attributeNamesTable.put(name, BufferDtdConverter.this.attributeNames);
            }
            if ((pattern = BufferDtdConverter.this.convert(attributeGroup)) instanceof EmptyPattern) {
                List decls = (List)BufferDtdConverter.this.attlistDeclTable.get(name);
                if (decls.get(0) != attributeGroup) {
                    return;
                }
                BufferDtdConverter.this.attributeNames = new HashSet();
                int len = decls.size();
                for (int i = 1; i < len; ++i) {
                    if (BufferDtdConverter.this.convert((AttributeGroup)decls.get(i)) instanceof EmptyPattern) continue;
                    return;
                }
            }
            DefineComponent dc = new DefineComponent(BufferDtdConverter.this.attlistDeclName(name), pattern);
            dc.setCombine(Combine.INTERLEAVE);
            this.addComponent((Component)dc);
        }

        public void modelGroupDef(String name, ModelGroup modelGroup) throws Exception {
            this.addComponent((Component)new DefineComponent(name, BufferDtdConverter.this.convert(modelGroup)));
        }

        public void attributeGroupDef(String name, AttributeGroup attributeGroup) throws Exception {
            GroupPattern pattern;
            BufferDtdConverter.this.attributeNames = new HashSet();
            AttributeGroupMember[] members = attributeGroup.getMembers();
            GroupPattern group = new GroupPattern();
            AttributeGroupOutput agv = new AttributeGroupOutput(group);
            for (int i = 0; i < members.length; ++i) {
                members[i].accept((AttributeGroupVisitor)agv);
            }
            switch (group.getChildren().size()) {
                case 0: {
                    pattern = new EmptyPattern();
                    break;
                }
                case 1: {
                    pattern = (Pattern)group.getChildren().get(0);
                    break;
                }
                default: {
                    pattern = group;
                }
            }
            this.addComponent((Component)new DefineComponent(name, (Pattern)pattern));
        }

        public void enumGroupDef(String name, EnumGroup enumGroup) throws Exception {
            ChoicePattern pattern;
            ChoicePattern choice = new ChoicePattern();
            enumGroup.accept((EnumGroupVisitor)new EnumGroupOutput(choice));
            switch (choice.getChildren().size()) {
                case 0: {
                    pattern = new NotAllowedPattern();
                    break;
                }
                case 1: {
                    pattern = (Pattern)choice.getChildren().get(0);
                    break;
                }
                default: {
                    pattern = choice;
                }
            }
            this.addComponent((Component)new DefineComponent(name, (Pattern)pattern));
        }

        public void datatypeDef(String name, Datatype datatype) throws Exception {
            this.addComponent((Component)new DefineComponent(name, BufferDtdConverter.this.convert(datatype)));
        }

        @Override
        public void comment(String value) {
            if (this.comments == null) {
                this.comments = new Vector<Comment>();
            }
            this.comments.add(new Comment(CommentTrimmer.trimComment((String)value)));
        }

        @Override
        public void externalIdRef(String name, ExternalId externalId, String uri, String encoding, TopLevel[] contents) throws Exception {
            if (uri == null) {
                super.externalIdRef(name, externalId, uri, encoding, contents);
                return;
            }
            SignificanceDetector sd = new SignificanceDetector();
            try {
                sd.externalIdRef(name, externalId, uri, encoding, contents);
                if (!sd.significant) {
                    return;
                }
            }
            catch (Exception e) {
                throw (RuntimeException)e;
            }
            if (BufferDtdConverter.this.sc.getSchemaDocumentMap().get(uri) != null) {
                super.externalIdRef(name, externalId, uri, encoding, contents);
                return;
            }
            IncludeComponent ic = new IncludeComponent(uri);
            ic.setNs(BufferDtdConverter.this.defaultNamespace);
            this.addComponent((Component)ic);
            GrammarPattern included = new GrammarPattern();
            ComponentOutput co = new ComponentOutput(included);
            for (int i = 0; i < contents.length; ++i) {
                contents[i].accept((TopLevelVisitor)co);
            }
            co.finish();
            BufferDtdConverter.this.sc.getSchemaDocumentMap().put(uri, new SchemaDocument((Pattern)included, encoding));
        }
    }

    private class Analyzer
    extends VisitorBase
    implements ModelGroupVisitor,
    AttributeGroupVisitor {
        private Analyzer() {
        }

        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            BufferDtdConverter.this.noteElementName(nameSpec.getValue(), 1);
            modelGroup.accept((ModelGroupVisitor)this);
        }

        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            BufferDtdConverter.this.noteElementName(nameSpec.getValue(), 2);
            BufferDtdConverter.this.noteAttlist(nameSpec.getValue(), attributeGroup);
            attributeGroup.accept((AttributeGroupVisitor)this);
        }

        public void modelGroupDef(String name, ModelGroup modelGroup) throws Exception {
            BufferDtdConverter.this.noteDef(name);
            modelGroup.accept((ModelGroupVisitor)this);
        }

        public void attributeGroupDef(String name, AttributeGroup attributeGroup) throws Exception {
            BufferDtdConverter.this.noteDef(name);
            attributeGroup.accept((AttributeGroupVisitor)this);
        }

        public void enumGroupDef(String name, EnumGroup enumGroup) {
            BufferDtdConverter.this.noteDef(name);
        }

        public void datatypeDef(String name, Datatype datatype) {
            BufferDtdConverter.this.noteDef(name);
        }

        public void choice(ModelGroup[] members) throws Exception {
            for (int i = 0; i < members.length; ++i) {
                members[i].accept((ModelGroupVisitor)this);
            }
        }

        public void sequence(ModelGroup[] members) throws Exception {
            for (int i = 0; i < members.length; ++i) {
                members[i].accept((ModelGroupVisitor)this);
            }
        }

        public void oneOrMore(ModelGroup member) throws Exception {
            member.accept((ModelGroupVisitor)this);
        }

        public void zeroOrMore(ModelGroup member) throws Exception {
            member.accept((ModelGroupVisitor)this);
        }

        public void optional(ModelGroup member) throws Exception {
            member.accept((ModelGroupVisitor)this);
        }

        public void modelGroupRef(String name, ModelGroup modelGroup) {
        }

        public void elementRef(NameSpec name) {
            BufferDtdConverter.this.noteElementName(name.getValue(), 4);
        }

        public void pcdata() {
        }

        public void any() {
            BufferDtdConverter.this.hadAny = true;
        }

        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) {
            BufferDtdConverter.this.noteAttribute(nameSpec.getValue(), attributeDefault.getDefaultValue());
        }

        public void attributeGroupRef(String name, AttributeGroup attributeGroup) {
        }
    }

    private static abstract class VisitorBase
    implements TopLevelVisitor {
        private VisitorBase() {
        }

        public void processingInstruction(String target, String value) throws Exception {
        }

        public void comment(String value) throws Exception {
        }

        public void flagDef(String name, Flag flag) throws Exception {
        }

        public void includedSection(Flag flag, TopLevel[] contents) throws Exception {
            for (int i = 0; i < contents.length; ++i) {
                contents[i].accept((TopLevelVisitor)this);
            }
        }

        public void ignoredSection(Flag flag, String contents) throws Exception {
        }

        public void internalEntityDecl(String name, String value) throws Exception {
        }

        public void externalEntityDecl(String name, ExternalId externalId) throws Exception {
        }

        public void notationDecl(String name, ExternalId externalId) throws Exception {
        }

        public void nameSpecDef(String name, NameSpec nameSpec) throws Exception {
        }

        public void overriddenDef(Def def, boolean isDuplicate) throws Exception {
        }

        public void externalIdDef(String name, ExternalId externalId) throws Exception {
        }

        public void externalIdRef(String name, ExternalId externalId, String uri, String encoding, TopLevel[] contents) throws Exception {
            for (int i = 0; i < contents.length; ++i) {
                contents[i].accept((TopLevelVisitor)this);
            }
        }

        public void paramDef(String name, String value) throws Exception {
        }

        public void attributeDefaultDef(String name, AttributeDefault ad) throws Exception {
        }
    }

    static class Options {
        boolean inlineAttlistDecls;
        boolean generateStart = true;
        boolean strictAny;
        String elementDeclPattern;
        String attlistDeclPattern;
        String colonReplacement;
        String anyName;
        String annotationPrefix;
        String defaultNamespace;
        final Map<String, String> prefixMap = new HashMap<String, String>();

        Options() {
        }
    }
}

