/*
 * Decompiled with CFR 0.152.
 */
package xml.parser.javacc;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sidekick.util.Location;
import sidekick.util.ParseError;
import sidekick.util.Range;
import xml.parser.javacc.ParseException;
import xml.parser.javacc.SimpleCharStream;
import xml.parser.javacc.Token;
import xml.parser.javacc.XmlDebugDumper;
import xml.parser.javacc.XmlDocument;
import xml.parser.javacc.XmlParserConstants;
import xml.parser.javacc.XmlParserTokenManager;

public class XmlParser
implements XmlParserConstants {
    static String NL = System.getProperty("line.separator");
    private List<ParseError> parseErrors = new ArrayList<ParseError>();
    private Pattern pePattern = Pattern.compile("(.*?)(\\d+)(.*?)(\\d+)(.*?)");
    private Pattern attributePattern = Pattern.compile("([a-zA-Z0-9.-])*");
    public XmlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[9];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setLineSeparator(String ls) {
        NL = ls;
    }

    private static String getTokenText(Token first, Token cur) {
        StringBuffer sb = new StringBuffer();
        Token t = first;
        while (t != cur.next) {
            if (t.specialToken != null) {
                Token tt = t.specialToken;
                while (tt.specialToken != null) {
                    tt = tt.specialToken;
                }
                while (tt != null) {
                    sb.append(tt.image);
                    tt = tt.next;
                }
            }
            sb.append(t.image);
            t = t.next;
        }
        return sb.toString();
    }

    public XmlParser(Reader in, int lineOffset, int columnOffset) {
        this(in);
        this.jj_input_stream.ReInit(in, lineOffset, columnOffset);
    }

    public static void main(String[] args) throws ParseException {
        XmlParser parser = new XmlParser(System.in);
        XmlDocument doc = parser.XmlDocument();
        doc.accept(new XmlDebugDumper(System.out));
        System.exit(0);
    }

    public void setTabSize(int size) {
        this.jj_input_stream.setTabSize(size);
    }

    public int getTabSize() {
        return this.jj_input_stream.getTabSize(0);
    }

    private void addException(ParseException pe) {
        Range range = this.getExceptionLocation(pe);
        this.parseErrors.add(new ParseError(pe.getMessage(), range));
        pe.printStackTrace();
    }

    public List<ParseError> getParseErrors() {
        System.out.println("getParserErrors, there are " + this.parseErrors.size() + " errors");
        return this.parseErrors;
    }

    private Range getExceptionLocation(ParseException pe) {
        Token t = pe.currentToken;
        if (t != null) {
            return new Range(new Location(t.next.beginLine - 1, t.next.beginColumn), new Location(t.next.endLine - 1, t.next.endColumn));
        }
        try {
            Matcher m = this.pePattern.matcher(pe.getMessage());
            if (m.matches()) {
                String ln = m.group(2);
                String cn = m.group(4);
                int line_number = -1;
                int column_number = 0;
                if (ln != null) {
                    line_number = Integer.parseInt(ln);
                }
                if (cn != null) {
                    column_number = Integer.parseInt(cn);
                }
                return line_number > -1 ? new Range(new Location(line_number - 1, column_number - 1), new Location(line_number - 1, column_number)) : null;
            }
            return new Range();
        }
        catch (Exception e) {
            return new Range();
        }
    }

    private boolean isProperAttribute(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return true;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        if (s.startsWith("<%") && (s.endsWith("%>") || s.endsWith("%"))) {
            return true;
        }
        boolean rtn = this.attributePattern.matcher(s).matches();
        if (!rtn) {
            System.out.println("bad attribute: " + s);
        }
        return rtn;
    }

    public final XmlDocument XmlDocument() throws ParseException {
        XmlDocument.ElementSequence s = this.ElementSequence();
        this.jj_consume_token(0);
        return new XmlDocument(s);
    }

    public final XmlDocument.ElementSequence ElementSequence() throws ParseException {
        XmlDocument.ElementSequence s = new XmlDocument.ElementSequence();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            XmlDocument.XmlElement h = this.Element();
            s.addElement(h);
        }
        return s;
    }

    public final XmlDocument.XmlElement Element() throws ParseException {
        if (this.jj_2_1(2)) {
            XmlDocument.XmlElement e = this.Tag();
            return e;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                XmlDocument.XmlElement e = this.EndTag();
                return e;
            }
            case 12: {
                XmlDocument.Comment e = this.CommentTag();
                return e;
            }
            case 15: {
                XmlDocument.Comment e = this.DeclTag();
                return e;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        if (this.jj_2_2(2)) {
            this.jj_consume_token(14);
            Token text = this.jj_consume_token(19);
            return new XmlDocument.Text("<" + text.image);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                Token text = this.jj_consume_token(16);
                return new XmlDocument.Text(text.image);
            }
            case 11: {
                this.jj_consume_token(11);
                return new XmlDocument.Newline();
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final XmlDocument.Attribute Attribute() throws ParseException {
        Token t2 = null;
        try {
            XmlDocument.Attribute a;
            Token t1 = this.jj_consume_token(21);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: {
                    this.jj_consume_token(24);
                    t2 = this.jj_consume_token(28);
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                }
            }
            if (t2 == null) {
                a = new XmlDocument.Attribute(t1.image);
                a.setStartLocation(t1.beginLine, t1.beginColumn);
                a.setEndLocation(t1.endLine, t1.endColumn + 1);
            } else {
                a = new XmlDocument.Attribute(t1.image, t2.image);
                a.setStartLocation(t1.beginLine, t1.beginColumn);
                a.setValueStartLocation(t2.beginLine, t2.beginColumn);
                a.setEndLocation(t2.endLine, t2.endColumn + 1);
                if (!this.isProperAttribute(t2.image)) {
                    ParseException e = new ParseException("Parse error at line " + t2.beginLine + ", column " + t2.beginColumn + ".  Attribute is improperly quoted.");
                    this.addException(e);
                }
            }
            return a;
        }
        catch (ParseException e) {
            this.addException(e);
            return null;
        }
    }

    public final XmlDocument.AttributeList AttributeList() throws ParseException {
        XmlDocument.AttributeList alist = new XmlDocument.AttributeList();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            XmlDocument.Attribute a = this.Attribute();
            alist.addAttribute(a);
        }
        return alist;
    }

    public final XmlDocument.XmlElement Tag() throws ParseException {
        Token firstToken = this.getToken(1);
        Token st = null;
        try {
            Token et;
            st = this.jj_consume_token(14);
            Token t = this.jj_consume_token(18);
            XmlDocument.AttributeList alist = this.AttributeList();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    et = this.jj_consume_token(22);
                    break;
                }
                case 23: {
                    et = this.jj_consume_token(23);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            String tag_start = "<";
            String tag_name = "";
            if (st.image.startsWith("<") && st.image.endsWith(":")) {
                tag_start = "<";
                tag_name = st.image.substring(1) + t.image;
            } else {
                tag_name = t.image;
            }
            XmlDocument.Tag rtn_tag = new XmlDocument.Tag(tag_start, tag_name, alist, et.image);
            if (et.kind == 23) {
                rtn_tag.setEmpty(true);
            }
            rtn_tag.setStartLocation(st.beginLine, st.beginColumn);
            rtn_tag.setEndLocation(et.endLine, et.endColumn + 1);
            return rtn_tag;
        }
        catch (ParseException ex) {
            this.addException(ex);
            this.token_source.SwitchTo(5);
            String s = XmlParser.getTokenText(firstToken, this.getNextToken());
            return new XmlDocument.Text(s);
        }
    }

    public final XmlDocument.XmlElement EndTag() throws ParseException {
        Token firstToken = this.getToken(1);
        try {
            Token st = this.jj_consume_token(13);
            Token t = this.jj_consume_token(18);
            Token et = this.jj_consume_token(22);
            String tag_name = "";
            tag_name = st.image.startsWith("</") && st.image.endsWith(":") ? st.image.substring(2) + t.image : t.image;
            XmlDocument.EndTag b = new XmlDocument.EndTag(tag_name);
            b.setStartLocation(st.beginLine, st.beginColumn);
            b.setEndLocation(et.endLine, et.endColumn + 1);
            return b;
        }
        catch (ParseException ex) {
            this.addException(ex);
            this.token_source.SwitchTo(5);
            String s = XmlParser.getTokenText(firstToken, this.getNextToken());
            return new XmlDocument.Text(s);
        }
    }

    public final XmlDocument.Comment CommentTag() throws ParseException {
        Token comment_end = null;
        StringBuffer s = new StringBuffer();
        try {
            Token comment_start;
            block15: {
                comment_start = this.jj_consume_token(12);
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 31: 
                        case 32: 
                        case 33: {
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            break block15;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 31: {
                            Token t = this.jj_consume_token(31);
                            s.append(t.image);
                            continue block14;
                        }
                        case 32: {
                            this.jj_consume_token(32);
                            s.append(NL);
                            continue block14;
                        }
                        case 33: {
                            Token t = this.jj_consume_token(33);
                            s.append(t.image);
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    break;
                }
                case 30: {
                    comment_end = this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return new XmlDocument.Comment(comment_start.image + s.toString() + (comment_end == null ? "" : comment_end.image));
        }
        catch (ParseException e) {
            this.addException(e);
            throw new Error("Missing return statement in function");
        }
    }

    public final XmlDocument.Comment DeclTag() throws ParseException {
        try {
            this.jj_consume_token(15);
            Token t = this.jj_consume_token(34);
            this.jj_consume_token(35);
            return new XmlDocument.Comment(t.image);
        }
        catch (ParseException e) {
            this.addException(e);
            throw new Error("Missing return statement in function");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_4() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private final boolean jj_3_1() {
        return this.jj_3R_4();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{129024, 45056, 67584, 0x1000000, 0x200000, 0xC00000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x40000001};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 3, 3, 0};
    }

    public XmlParser(InputStream stream) {
        this(stream, null);
    }

    public XmlParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new XmlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public XmlParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new XmlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public XmlParser(XmlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(XmlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[36];
        for (i = 0; i < 36; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 9; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 36; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        XmlParser.jj_la1_0();
        XmlParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

