/*
 * Decompiled with CFR 0.152.
 */
package xml.parser.javacc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Position;
import sidekick.html.parser.html.HtmlDocument;
import sidekick.util.Location;
import sidekick.util.SideKickElement;
import xml.NamespaceBindings;
import xml.parser.javacc.XmlVisitor;

public class XmlDocument {
    ElementSequence elements;
    static String NL = System.getProperty("line.separator");
    private static final String HTML_HEAD = "<head><link rel=STYLESHEET TYPE=\"text/css\" HREF=\"" + HtmlDocument.class.getResource("../style.css") + "\"></head>";

    public XmlDocument(ElementSequence s) {
        this.elements = s;
    }

    public void setLineSeparator(String ls) {
        NL = ls;
    }

    public void accept(XmlVisitor v) {
        if (v != null) {
            v.visit(this);
        }
    }

    private static String dequote(String s) {
        if (s == null) {
            return "";
        }
        if (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static String trimBrackets(CharSequence cs) {
        String s = ((Object)cs).toString();
        if (s.startsWith("<")) {
            s = s.substring(1);
        }
        if (s.endsWith(">")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static class AttributeList {
        public List<Attribute> attributes = new ArrayList<Attribute>();

        public void addAttribute(Attribute a) {
            this.attributes.add(a);
        }

        public boolean contains(String name) {
            for (Attribute attribute : this.attributes) {
                if (!attribute.name.equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }

        public boolean hasValue(String name) {
            for (Attribute attribute : this.attributes) {
                if (!attribute.name.equalsIgnoreCase(name) || !attribute.hasValue) continue;
                return true;
            }
            return false;
        }

        public String getValue(String name) {
            for (Attribute attribute : this.attributes) {
                if (!attribute.name.equalsIgnoreCase(name) || !attribute.hasValue) continue;
                return XmlDocument.dequote(attribute.value);
            }
            return null;
        }
    }

    public static class Attribute
    extends XmlElement {
        public String name;
        public String value;
        public boolean hasValue;
        private Location valueStartLocation = new Location(0, 0);

        public Attribute(String n) {
            this.name = n;
            this.hasValue = false;
        }

        public Attribute(String n, String v) {
            this.name = n;
            this.value = v;
            this.hasValue = true;
        }

        public String getName() {
            return this.name == null ? "" : this.name;
        }

        public String getValue() {
            return this.value == null ? "" : this.value;
        }

        public int getLength() {
            return this.hasValue ? this.name.length() + 1 + this.value.length() : this.name.length();
        }

        public String toString() {
            return this.hasValue ? this.name + "=" + this.value : this.name;
        }

        public void setValueStartLocation(int line, int column) {
            this.valueStartLocation = new Location(line, column);
        }

        public void setValueStartLocation(Location location) {
            this.valueStartLocation = location;
        }

        public Location getValueStartLocation() {
            return this.valueStartLocation;
        }

        @Override
        public void accept(XmlVisitor visitor) {
        }
    }

    public static class Annotation
    extends XmlElement {
        String type;
        String text;

        public Annotation(String type, String text) {
            this.type = type;
            this.text = text;
        }

        @Override
        public void accept(XmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 14 + this.type.length() + this.text.length();
        }

        public String toString() {
            return "<!--NOTE(" + this.type + ") " + this.text + "-->";
        }
    }

    public static class ElementSequence {
        private List elements;

        public ElementSequence(int n) {
            this.elements = new ArrayList(n);
        }

        public ElementSequence() {
            this.elements = new ArrayList();
        }

        public void addElement(XmlElement o) {
            this.elements.add(o);
        }

        public int size() {
            return this.elements.size();
        }

        public Iterator iterator() {
            return this.elements.iterator();
        }

        public Object getElementAt(int i) {
            if (this.elements != null && this.elements.size() > 0) {
                return this.elements.get(i);
            }
            return null;
        }

        public void setElements(List coll) {
            this.elements.clear();
            this.elements.addAll(coll);
        }
    }

    public static class Newline
    extends XmlElement {
        @Override
        public void accept(XmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return NL.length();
        }

        public String toString() {
            return NL;
        }
    }

    public static class Text
    extends XmlElement {
        public String text;

        public Text(String t) {
            this.text = t;
        }

        @Override
        public void accept(XmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return this.text.length();
        }

        public String toString() {
            return this.text;
        }
    }

    public static class Comment
    extends XmlElement {
        public String comment;

        public Comment(String c) {
            this.comment = c;
        }

        @Override
        public void accept(XmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 3 + this.comment.length();
        }

        public String toString() {
            return this.comment;
        }
    }

    public static class TagBlock
    extends XmlElement {
        public Tag startTag;
        public EndTag endTag;
        public ElementSequence body;

        public TagBlock(Tag t, ElementSequence b, EndTag et) {
            this.startTag = t;
            this.endTag = et;
            this.body = b;
        }

        public TagBlock(String name, AttributeList aList, ElementSequence b) {
            this.startTag = new Tag(name, aList);
            this.endTag = new EndTag(name);
            this.body = b;
        }

        @Override
        public void accept(XmlVisitor v) {
            v.visit(this);
        }

        public String toString() {
            return this.startTag.toString();
        }

        @Override
        public String toLongString() {
            return this.startTag.toLongString();
        }
    }

    public static class EndTag
    extends XmlElement {
        public String tagName;

        public EndTag(String t) {
            this.tagName = t;
        }

        @Override
        public void accept(XmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 3 + this.tagName.length();
        }

        public String toString() {
            return "</" + this.tagName + ">";
        }
    }

    public static class Tag
    extends XmlElement {
        public String tagStart = "<";
        public String tagName;
        public AttributeList attributeList;
        public String tagEnd = ">";
        public boolean emptyTag = false;
        public String namespace;
        public NamespaceBindings namespaceBindings;

        public Tag(String name, AttributeList a) {
            this.tagName = name;
            this.attributeList = a;
        }

        public Tag(String tagStart, String name, AttributeList a, String tagEnd) {
            this.tagStart = tagStart;
            this.tagName = name;
            this.attributeList = a;
            this.tagEnd = tagEnd;
        }

        public void sortAttributes() {
            Collections.sort(this.attributeList.attributes, new Comparator(){

                public int compare(Object a, Object b) {
                    return ((Attribute)a).name.compareTo(((Attribute)b).name);
                }
            });
        }

        public void setEmpty(boolean b) {
            this.emptyTag = b;
        }

        @Override
        public void accept(XmlVisitor v) {
            v.visit(this);
        }

        public boolean hasAttribute(String name) {
            return this.attributeList.contains(name);
        }

        public boolean hasAttributeValue(String name) {
            return this.attributeList.hasValue(name);
        }

        public String getAttributeValue(String name) {
            return this.attributeList.getValue(name);
        }

        public int getLength() {
            int length = 0;
            for (Attribute attribute : this.attributeList.attributes) {
                length += 1 + attribute.getLength();
            }
            return length + this.tagName.length() + (this.emptyTag ? 1 : 0);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.tagName);
            for (Attribute attribute : this.attributeList.attributes) {
                s.append(" ");
                s.append(attribute.toString());
            }
            return s.toString();
        }

        @Override
        public String toLongString() {
            StringBuffer s = new StringBuffer();
            if (this.tagName.equals("html")) {
                s.append("<html><b>html");
                return s.toString();
            }
            s.append("<html>").append(HTML_HEAD).append("<body><b>");
            if (this.tagStart.length() > 1 && !this.tagStart.endsWith(":")) {
                s.append(this.tagStart.substring(1));
                s.append(" ");
            }
            s.append(this.tagName);
            s.append("</b><br><table>");
            for (Attribute attribute : this.attributeList.attributes) {
                s.append("<tr><td>").append(attribute.name).append("</td><td>").append(attribute.value).append("</td></tr>");
            }
            s.append("</table></body></html>");
            return s.toString();
        }
    }

    public static abstract class XmlElement
    implements SideKickElement {
        private Location startLocation = new Location(0, 0);
        private Location endLocation = new Location(0, 0);
        private Position startPosition = null;
        private Position endPosition = null;

        public abstract void accept(XmlVisitor var1);

        public void setStartLocation(int line, int column) {
            this.startLocation = new Location(line, column);
        }

        public void setStartLocation(Location location) {
            this.startLocation = location;
        }

        public Location getStartLocation() {
            return this.startLocation;
        }

        public void setEndLocation(int line, int column) {
            this.endLocation = new Location(line, column);
        }

        public void setEndLocation(Location location) {
            this.endLocation = location;
        }

        public Location getEndLocation() {
            return this.endLocation;
        }

        public void setStartPosition(Position s) {
            this.startPosition = s;
        }

        public Position getStartPosition() {
            return this.startPosition;
        }

        public void setEndPosition(Position s) {
            this.endPosition = s;
        }

        public Position getEndPosition() {
            return this.endPosition;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof XmlElement)) {
                return false;
            }
            XmlElement he = (XmlElement)o;
            String a = he.toString();
            String b = this.toString();
            if (a == null && b != null) {
                return false;
            }
            if (a != null && b == null) {
                return false;
            }
            if (a == null && b == null && he.getStartLocation().equals(this.getStartLocation()) && he.getEndLocation().equals(this.getEndLocation())) {
                return true;
            }
            return a.equals(b) && he.getStartLocation().equals(this.getStartLocation()) && he.getEndLocation().equals(this.getEndLocation());
        }

        public String toLongString() {
            return this.toString();
        }
    }
}

