/*
 * Decompiled with CFR 0.152.
 */
package xml.parser.javacc;

import java.io.OutputStream;
import java.io.PrintWriter;
import xml.parser.javacc.ParseException;
import xml.parser.javacc.XmlDocument;
import xml.parser.javacc.XmlParser;
import xml.parser.javacc.XmlVisitor;

public class XmlDebugDumper
extends XmlVisitor {
    protected PrintWriter out;

    public XmlDebugDumper(OutputStream os) {
        this.out = new PrintWriter(os);
    }

    @Override
    public void finish() {
        this.out.flush();
    }

    @Override
    public void visit(XmlDocument.Tag t) {
        this.out.print("Tag(" + t + ")");
    }

    @Override
    public void visit(XmlDocument.EndTag t) {
        this.out.print("Tag(" + t + ")");
    }

    @Override
    public void visit(XmlDocument.Comment c) {
        this.out.print("Comment(" + c + ")");
    }

    @Override
    public void visit(XmlDocument.Text t) {
        this.out.print(t);
    }

    @Override
    public void visit(XmlDocument.Newline n) {
        this.out.println("-NL-");
    }

    @Override
    public void visit(XmlDocument.Annotation a) {
        this.out.print(a);
    }

    @Override
    public void visit(XmlDocument.TagBlock bl) {
        this.out.print("<BLOCK>");
        this.visit(bl.startTag);
        this.visit(bl.body);
        this.visit(bl.endTag);
        this.out.print("</BLOCK>");
    }

    public static void main(String[] args) throws ParseException {
        XmlParser parser = new XmlParser(System.in);
        XmlDocument doc = parser.XmlDocument();
        doc.accept(new XmlDebugDumper(System.out));
    }
}

