/*
 * Decompiled with CFR 0.152.
 */
package xml.parser.javacc;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import xml.parser.javacc.XmlDocument;
import xml.parser.javacc.XmlDumper;
import xml.parser.javacc.XmlParser;
import xml.parser.javacc.XmlScrubber;
import xml.parser.javacc.XmlVisitor;

public class XmlCollector
extends XmlVisitor {
    protected ElementStack tagStack = new ElementStack();
    protected ElementStack elements;
    protected boolean collected;

    protected int pushNode(XmlDocument.XmlElement e) {
        if (e != null) {
            this.elements.addElement(e);
        }
        return this.elements.size() - 1;
    }

    @Override
    public void visit(XmlDocument.Comment c) {
        this.pushNode(c);
    }

    @Override
    public void visit(XmlDocument.Text t) {
        this.pushNode(t);
    }

    @Override
    public void visit(XmlDocument.Newline n) {
        this.pushNode(n);
    }

    @Override
    public void visit(XmlDocument.Tag t) {
        if (t == null) {
            return;
        }
        TagStackEntry ts = new TagStackEntry();
        int index = this.pushNode(t);
        if (!t.emptyTag) {
            ts.tagName = t.tagName;
            ts.index = index;
            this.tagStack.addElement(ts);
        }
    }

    @Override
    public void visit(XmlDocument.EndTag t) {
        int i;
        if (t == null) {
            return;
        }
        for (i = this.tagStack.size() - 1; i >= 0; --i) {
            TagStackEntry ts = (TagStackEntry)this.tagStack.elementAt(i);
            if (!t.tagName.equals(ts.tagName)) continue;
            XmlDocument.ElementSequence blockElements = new XmlDocument.ElementSequence(this.elements.size() - ts.index - 1);
            for (int j = ts.index + 1; j < this.elements.size(); ++j) {
                blockElements.addElement((XmlDocument.XmlElement)this.elements.elementAt(j));
            }
            XmlDocument.Tag tag = (XmlDocument.Tag)this.elements.elementAt(ts.index);
            XmlDocument.TagBlock block = new XmlDocument.TagBlock(tag, blockElements, t);
            block.setStartLocation(tag.getStartLocation());
            block.setEndLocation(t.getEndLocation());
            this.elements.popN(this.elements.size() - ts.index);
            this.elements.addElement(block);
            this.tagStack.popN(this.tagStack.size() - i);
            this.collected = true;
            break;
        }
        if (i < 0) {
            this.pushNode(t);
        }
    }

    @Override
    public void visit(XmlDocument.TagBlock bl) {
        if (bl == null) {
            return;
        }
        XmlCollector c = new XmlCollector();
        c.start();
        c.visit(bl.body);
        c.finish();
        this.pushNode(bl);
    }

    @Override
    public void visit(XmlDocument.ElementSequence s) {
        if (s == null) {
            return;
        }
        this.elements = new ElementStack(s.size());
        this.collected = false;
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            XmlDocument.XmlElement htmlElement = (XmlDocument.XmlElement)iterator.next();
            if (htmlElement == null) continue;
            htmlElement.accept(this);
        }
        if (this.collected) {
            s.setElements(this.elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        FileInputStream r = new FileInputStream(args[0]);
        try {
            XmlDocument document = new XmlParser(r).XmlDocument();
            document.accept(new XmlScrubber());
            document.accept(new XmlCollector());
            document.accept(new XmlDumper(System.out));
        }
        finally {
            ((InputStream)r).close();
        }
    }

    private static class ElementStack
    extends Vector {
        ElementStack() {
        }

        ElementStack(int n) {
            super(n);
        }

        public void popN(int n) {
            this.elementCount -= n;
        }
    }

    private static class TagStackEntry {
        String tagName;
        int index;

        private TagStackEntry() {
        }
    }
}

