/*
 * Decompiled with CFR 0.152.
 */
package xml.parser.javacc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.util.Log;
import sidekick.util.ElementUtil;
import sidekick.util.Location;
import sidekick.util.SideKickElement;
import xml.CharSequenceReader;
import xml.XmlParsedData;
import xml.parser.javacc.ParseException;
import xml.parser.javacc.XmlDocument;
import xml.parser.javacc.XmlParser;
import xml.parser.javacc.XmlVisitor;

public class TagParser {
    public static final int T_STANDALONE_TAG = 0;
    public static final int T_START_TAG = 1;
    public static final int T_END_TAG = 2;
    private static final FoundException foundException = new FoundException();

    private static XmlDocument parse(CharSequence text) {
        try {
            CharSequenceReader r = new CharSequenceReader(text);
            XmlParser parser = new XmlParser(r);
            parser.getParseErrors();
            return parser.XmlDocument();
        }
        catch (ParseException e) {
            Log.log((int)9, (Object)"error in TagParser.parse()", (Object)e);
            return null;
        }
    }

    public static Tag getTagAtOffset(Buffer buffer, CharSequence text, int pos) {
        if (pos < 0 || pos > text.length()) {
            return null;
        }
        XmlDocument doc = TagParser.parse(text);
        int line = buffer.getLineOfOffset(pos);
        int offset = pos - buffer.getLineStartOffset(line) + 1;
        LastSeenVisitor visitor = new LastSeenVisitor(line + 1, offset);
        try {
            visitor.visit(doc);
            return null;
        }
        catch (FoundException f) {
            XmlDocument.AttributeList attrs;
            String tagName;
            int tagType;
            XmlDocument.XmlElement t;
            if (visitor.lastSeen instanceof XmlDocument.Tag) {
                t = (XmlDocument.Tag)visitor.lastSeen;
                tagType = t.emptyTag ? 0 : 1;
                tagName = t.tagName;
                attrs = t.attributeList;
            } else {
                t = (XmlDocument.EndTag)visitor.lastSeen;
                tagType = 2;
                tagName = ((XmlDocument.EndTag)t).tagName;
                attrs = null;
            }
            ElementUtil.createStartPosition((Buffer)buffer, (SideKickElement)visitor.lastSeen);
            ElementUtil.createEndPosition((Buffer)buffer, (SideKickElement)visitor.lastSeen);
            Tag tag = new Tag(visitor.lastSeen.getStartPosition().getOffset(), visitor.lastSeen.getEndPosition().getOffset() - 1);
            tag.tag = tagName;
            tag.type = tagType;
            tag.attrs = attrs;
            return tag;
        }
    }

    public static Tag getMatchingTag(Buffer buffer, CharSequence text, Tag tag) {
        if (tag.type == 1) {
            return TagParser.findEndTag(buffer, text, tag);
        }
        if (tag.type == 2) {
            return TagParser.findStartTag(buffer, text, tag);
        }
        return null;
    }

    public static Tag findLastOpenTag(Buffer buffer, CharSequence text, int pos, XmlParsedData data) {
        XmlDocument doc = TagParser.parse(text);
        int line = buffer.getLineOfOffset(pos);
        int offset = pos - buffer.getLineStartOffset(line) + 1;
        LastOpenTagVisitor visit = new LastOpenTagVisitor(line + 1, offset);
        try {
            visit.visit(doc);
        }
        catch (FoundException e) {
            // empty catch block
        }
        if (visit.elements.isEmpty()) {
            return null;
        }
        XmlDocument.Tag t = (XmlDocument.Tag)visit.elements.pop();
        int tagType = t.emptyTag ? 0 : 1;
        String tagName = t.tagName;
        ElementUtil.createStartPosition((Buffer)buffer, (SideKickElement)t);
        ElementUtil.createEndPosition((Buffer)buffer, (SideKickElement)t);
        Tag tag = new Tag(t.getStartPosition().getOffset(), t.getEndPosition().getOffset() - 1);
        tag.tag = tagName;
        tag.type = tagType;
        tag.attrs = t.attributeList;
        return tag;
    }

    public static boolean isInsideTag(String text, int pos) {
        int start = text.lastIndexOf(60, pos);
        if (start > -1 && start < pos) {
            int end = -1;
            int len = text.length();
            for (int i = start + 1; i < len && i < pos; ++i) {
                char ch = text.charAt(i);
                if (ch == '>') {
                    end = i;
                    break;
                }
                if (ch != '\'' && ch != '\"') continue;
                int nextQuote = text.indexOf(ch, i + 1);
                if (nextQuote == -1) {
                    System.err.println("quote is not closed !");
                    return false;
                }
                i = nextQuote;
            }
            if (end == -1) {
                return true;
            }
            return end < start;
        }
        return false;
    }

    private static Tag findEndTag(Buffer buffer, CharSequence text, Tag startTag) {
        XmlDocument doc = TagParser.parse(text);
        int line = buffer.getLineOfOffset(startTag.start);
        int offset = startTag.start - buffer.getLineStartOffset(line) + 1;
        FindEndTagVisitor visitor = new FindEndTagVisitor(line + 1, offset, startTag);
        try {
            visitor.visit(doc);
        }
        catch (FoundException e) {
            // empty catch block
        }
        if (visitor.lastSeen != null) {
            ElementUtil.createStartPosition((Buffer)buffer, (SideKickElement)visitor.lastSeen);
            ElementUtil.createEndPosition((Buffer)buffer, (SideKickElement)visitor.lastSeen);
            Tag tag = new Tag(visitor.lastSeen.getStartPosition().getOffset(), visitor.lastSeen.getEndPosition().getOffset() - 1);
            tag.tag = startTag.tag;
            tag.type = 2;
            return tag;
        }
        return null;
    }

    private static Tag findStartTag(Buffer buffer, CharSequence text, Tag endTag) {
        XmlDocument doc = TagParser.parse(text);
        int line = buffer.getLineOfOffset(endTag.start);
        int offset = endTag.start - buffer.getLineStartOffset(line) + 1;
        LastOpenTagVisitor visitor = new LastOpenTagVisitor(line + 1, offset);
        try {
            visitor.visit(doc);
        }
        catch (FoundException e) {
            // empty catch block
        }
        if (!visitor.elements.isEmpty()) {
            for (int i = visitor.elements.size() - 1; i >= 0; --i) {
                XmlDocument.Tag start = (XmlDocument.Tag)visitor.elements.get(i);
                if (!start.tagName.equals(endTag.tag)) continue;
                ElementUtil.createStartPosition((Buffer)buffer, (SideKickElement)start);
                ElementUtil.createEndPosition((Buffer)buffer, (SideKickElement)start);
                Tag tag = new Tag(start.getStartPosition().getOffset(), start.getEndPosition().getOffset() - 1);
                tag.tag = start.tagName;
                tag.type = 1;
                tag.attrs = start.attributeList;
                return tag;
            }
        }
        return null;
    }

    public static List<Attr> getAttrs(Buffer buffer, Tag tag) {
        if (tag.type == 1 || tag.type == 0) {
            ArrayList<Attr> attrs = new ArrayList<Attr>();
            if (tag.attrs != null) {
                for (XmlDocument.Attribute attr : tag.attrs.attributes) {
                    ElementUtil.createStartPosition((Buffer)buffer, (SideKickElement)attr);
                    ElementUtil.createEndPosition((Buffer)buffer, (SideKickElement)attr);
                    Attr a = new Attr(attr.getStartPosition().getOffset(), attr.getEndPosition().getOffset() - 1);
                    a.name = attr.name;
                    a.val = attr.value;
                    attrs.add(a);
                }
            }
            return attrs;
        }
        return Collections.emptyList();
    }

    public static class Attr {
        public String name = null;
        public String val = null;
        public int start;
        public int end;

        Attr(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.name + "=" + this.val;
        }
    }

    public static class Tag
    extends StructureMatcher.Match {
        public String tag = null;
        public int type = -1;
        XmlDocument.AttributeList attrs;

        public Tag(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "<" + this.tag + ">";
                }
                case 0: {
                    return "<" + this.tag + "/>";
                }
                case 2: {
                    return "</" + this.tag + ">";
                }
            }
            throw new InternalError();
        }
    }

    private static class FindEndTagVisitor
    extends XmlVisitor {
        private Location loc;
        private Stack<XmlDocument.Tag> elements = new Stack();
        private Tag startTag;
        private XmlDocument.EndTag lastSeen;

        FindEndTagVisitor(int line, int offset, Tag startTag) {
            this.loc = new Location(line, offset);
            this.startTag = startTag;
        }

        @Override
        public void visit(XmlDocument.Tag t) {
            if (this.loc.compareTo((Object)t.getStartLocation()) < 0) {
                if (!t.emptyTag) {
                    this.elements.push(t);
                }
            } else {
                throw foundException;
            }
        }

        @Override
        public void visit(XmlDocument.EndTag t) {
            if (this.loc.compareTo((Object)t.getStartLocation()) < 0) {
                if (t.tagName.equals(this.startTag.tag) && this.elements.isEmpty()) {
                    if (this.lastSeen == null) {
                        this.lastSeen = t;
                        throw foundException;
                    }
                } else {
                    for (int i = this.elements.size() - 1; i >= 0; --i) {
                        XmlDocument.Tag start = (XmlDocument.Tag)this.elements.get(i);
                        if (!start.tagName.equals(t.tagName)) continue;
                        this.elements.setSize(i);
                        return;
                    }
                }
            } else {
                throw foundException;
            }
        }
    }

    private static class LastOpenTagVisitor
    extends XmlVisitor {
        private Location loc;
        private Stack<XmlDocument.Tag> elements = new Stack();

        LastOpenTagVisitor(int line, int offset) {
            this.loc = new Location(line, offset);
        }

        @Override
        public void visit(XmlDocument.Tag t) {
            if (this.loc.compareTo((Object)t.getEndLocation()) >= 0) {
                if (!t.emptyTag) {
                    this.elements.push(t);
                }
            } else {
                throw foundException;
            }
        }

        @Override
        public void visit(XmlDocument.EndTag t) {
            if (this.loc.compareTo((Object)t.getEndLocation()) > 0) {
                for (int i = this.elements.size() - 1; i >= 0; --i) {
                    XmlDocument.Tag start = (XmlDocument.Tag)this.elements.get(i);
                    if (!start.tagName.equals(t.tagName)) continue;
                    this.elements.setSize(i);
                    return;
                }
            } else {
                throw foundException;
            }
        }
    }

    private static class LastSeenVisitor
    extends XmlVisitor {
        XmlDocument.XmlElement lastSeen = null;
        private Location loc;

        LastSeenVisitor(int line, int offset) {
            this.loc = new Location(line, offset);
        }

        @Override
        public void visit(XmlDocument.Tag t) {
            if (this.loc.compareTo((Object)t.getStartLocation()) > 0 && this.loc.compareTo((Object)t.getEndLocation()) < 0) {
                this.lastSeen = t;
                throw foundException;
            }
        }

        @Override
        public void visit(XmlDocument.EndTag t) {
            if (this.loc.compareTo((Object)t.getStartLocation()) > 0 && this.loc.compareTo((Object)t.getEndLocation()) < 0) {
                this.lastSeen = t;
                throw foundException;
            }
        }
    }

    private static class FoundException
    extends RuntimeException {
        private FoundException() {
        }
    }
}

