/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import javax.swing.Icon;
import javax.swing.text.Position;
import org.gjt.sp.jedit.jEdit;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import sidekick.Asset;
import xml.NamespaceBindings;
import xml.XmlListCellRenderer;

public class XmlTag
extends Asset {
    public Attributes attributes;
    public String attributeString;
    public String idAttributeString;
    public boolean empty;
    public String namespace;
    public NamespaceBindings namespaceBindings;
    private StringBuilder characters = new StringBuilder();

    public XmlTag(String name, String namespace, Position start, Attributes attributes) {
        super(name);
        this.namespace = namespace;
        this.namespaceBindings = new NamespaceBindings();
        this.start = this.end = start;
        this.attributes = new AttributesImpl(attributes);
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        String idName = null;
        String idValue = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            buf.append(' ');
            String aname = attributes.getQName(i);
            String value = attributes.getValue(i);
            buf.append(aname);
            buf.append("=\"");
            buf.append(value);
            buf.append('\"');
            if (!attributes.getLocalName(i).equalsIgnoreCase("id") && !attributes.getType(i).equals("ID")) continue;
            idName = aname;
            idValue = value;
        }
        this.attributeString = buf.toString();
        this.idAttributeString = idName == null ? name : name + ' ' + idName + "=\"" + idValue + '\"';
    }

    public Icon getIcon() {
        return this.empty ? XmlListCellRenderer.EMPTY_ELEMENT_ICON : XmlListCellRenderer.ELEMENT_ICON;
    }

    public String getLongString() {
        return this.attributeString;
    }

    public String getShortString() {
        int showAttributes = jEdit.getIntegerProperty((String)"xml.show-attributes", (int)1);
        switch (showAttributes) {
            case 0: {
                return this.name;
            }
            case 1: {
                return this.idAttributeString;
            }
            case 2: {
                return this.attributeString;
            }
        }
        return null;
    }

    public String toString() {
        return this.attributeString;
    }

    public String getLocalName() {
        return this.name.contains(":") ? this.name.substring(this.name.indexOf(":") + 1) : this.name;
    }

    public String getPrefix() {
        return this.name.contains(":") ? this.name.substring(0, this.name.indexOf(":")) : "";
    }

    public boolean canAddCharacters() {
        return false;
    }

    public void addCharacters(char[] chars) {
        this.characters.append(chars);
    }

    public String getCharacters() {
        return this.characters.toString();
    }
}

