/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import sidekick.SideKickCompletion;
import sidekick.SideKickParser;
import xml.NamespaceBindings;
import xml.SideKickTagHighlight;
import xml.TagHighlight;
import xml.XmlActions;
import xml.XmlListCellRenderer;
import xml.XmlParsedData;
import xml.XmlPlugin;
import xml.completion.ElementDecl;
import xml.completion.EntityDecl;
import xml.completion.XmlCompletion;
import xml.parser.TagParser;

public abstract class XmlParser
extends SideKickParser {
    public static final String INSTANT_COMPLETION_TRIGGERS = "/";
    public static final int ELEMENT_COMPLETE = 60;
    public static final int ENTITY_COMPLETE = 38;
    public static final int ATTRIB_COMPLETE = 32;
    private final char lt = (char)60;
    private final char colon = (char)58;
    private final char amp = (char)38;
    private final char slash = (char)47;
    private final Pattern ws = Pattern.compile("\\s+");
    private final Pattern wordP = Pattern.compile("[\\w-_]+(=[\"']?)?");
    private final Pattern entP = Pattern.compile(".*&([\\w_-]*)$");
    private final Pattern commentCDATAP = Pattern.compile(".*<((!-?-?)|(!\\[(C(D(A(T(A\\[?)?)?)?)?)?))");
    boolean stopped;
    private StructureMatcher highlight;
    private StructureMatcher htmlHighlight;
    private boolean tryModesSuperSet;

    public XmlParser(String name) {
        super(name);
        String matcherName = jEdit.getProperty((String)"xml.structure-matcher", (String)"sidekick");
        this.highlight = "old".equals(matcherName) ? new TagHighlight() : new SideKickTagHighlight();
        this.htmlHighlight = new TagHighlight();
    }

    public void stop() {
        this.stopped = true;
    }

    public void activate(EditPane editPane) {
        super.activate(editPane);
        if (jEdit.getBooleanProperty((String)"xml.tag-highlight")) {
            StructureMatcher h = editPane.getBuffer().getMode().getName().equals("html") || editPane.getBuffer().getMode().getName().equals("jsp") ? this.htmlHighlight : this.highlight;
            editPane.getTextArea().addStructureMatcher(h);
        }
        this.tryModesSuperSet = jEdit.getBooleanProperty((String)"xml.try-modes-superset", (boolean)true);
    }

    public void deactivate(EditPane editPane) {
        editPane.getTextArea().removeStructureMatcher(this.highlight);
        editPane.getTextArea().removeStructureMatcher(this.htmlHighlight);
    }

    public boolean supportsCompletion() {
        return true;
    }

    public String getInstantCompletionTriggers() {
        return INSTANT_COMPLETION_TRIGGERS;
    }

    public SideKickCompletion complete(EditPane editPane, int caret) {
        String word;
        int start;
        Matcher m;
        byte[] ENT_TYPE;
        byte[] PREFIX_TYPE;
        byte[] COLON_TYPE;
        byte[] WORD_TYPE;
        byte[] WS_TYPE;
        byte[] LT_TYPE;
        if (caret == 0) {
            return null;
        }
        XmlParsedData data = XmlParsedData.getParsedData(editPane.getView(), false);
        if (data == null) {
            return null;
        }
        if (XmlPlugin.isDelegated(editPane.getTextArea())) {
            return null;
        }
        Buffer buffer = editPane.getBuffer();
        int lastchar = caret - 1;
        int lastcharLine = buffer.getLineOfOffset(lastchar);
        int lineStart = buffer.getLineStartOffset(lastcharLine);
        DefaultTokenHandler tokenHandler = new DefaultTokenHandler();
        buffer.markTokens(lastcharLine, (TokenHandler)tokenHandler);
        Token token = tokenHandler.getTokens();
        Token openTag = null;
        TokenRingBuffer lastTokens = new TokenRingBuffer(5);
        while (token.id != 127) {
            int next = lineStart + token.length;
            lastTokens.write(token);
            if (lineStart <= lastchar && next > lastchar) break;
            if (token.length == 1 && (token.id == 17 || token.id == 9) && buffer.getSegment(lineStart, token.length).charAt(0) == '<') {
                openTag = token;
            }
            lineStart = next;
            token = token.next;
        }
        boolean caretIsAtLineStart = (lineStart = buffer.getLineStartOffset(buffer.getLineOfOffset(caret))) == caret;
        String modename = buffer.getMode().getName();
        lineStart = buffer.getLineStartOffset(lastcharLine);
        lastTokens.mark();
        Context ctx = new Context();
        if (caretIsAtLineStart) {
            String ruleSet = tokenHandler.getLineContext().rules.getName();
            if ("xml".equals(modename)) {
                if ("xml::TAGS".equals(ruleSet)) {
                    ctx.mode = 32;
                    ctx.attribStart = caret;
                }
            } else if ("xsl".equals(modename)) {
                if ("xsl::TAGS".equals(ruleSet) || "xsl::XSLTAGS".equals(ruleSet)) {
                    ctx.mode = 32;
                    ctx.attribStart = caret;
                }
            } else if ("ant".equals(modename)) {
                if ("ant::TAGS".equals(ruleSet)) {
                    ctx.mode = 32;
                    ctx.attribStart = caret;
                }
            } else if ("maven".equals(modename)) {
                if ("maven::TAGS".equals(ruleSet)) {
                    ctx.mode = 32;
                    ctx.attribStart = caret;
                }
            } else if ("tld".equals(modename)) {
                if ("tld::TAGS".equals(ruleSet)) {
                    ctx.mode = 32;
                    ctx.attribStart = caret;
                }
            } else if ("html".equals(modename) && "html::TAGS".equals(ruleSet)) {
                ctx.mode = 32;
                ctx.attribStart = caret;
            }
        } else if (this.tryModesSuperSet) {
            LT_TYPE = new byte[]{17, 9};
            WS_TYPE = new byte[]{17, 9};
            WORD_TYPE = new byte[]{17, 8, 9, 10, 11, 18, 6};
            COLON_TYPE = new byte[]{18, 12, 17};
            PREFIX_TYPE = new byte[]{12, 8, 9, 10, 11, 18, 6, 17};
            ENT_TYPE = new byte[]{14};
            ctx = this.getMode(lastTokens, buffer, lineStart, LT_TYPE, WS_TYPE, WORD_TYPE, COLON_TYPE, PREFIX_TYPE, ENT_TYPE);
        } else {
            if ("xml".equals(modename) || "xsl".equals(modename)) {
                LT_TYPE = new byte[]{17};
                WS_TYPE = new byte[]{17};
                WORD_TYPE = new byte[]{17};
                COLON_TYPE = new byte[]{18};
                PREFIX_TYPE = new byte[]{12};
                ENT_TYPE = new byte[]{14};
                ctx = this.getMode(lastTokens, buffer, lineStart, LT_TYPE, WS_TYPE, WORD_TYPE, COLON_TYPE, PREFIX_TYPE, ENT_TYPE);
            }
            if (ctx.mode == -1 && "xsl".equals(modename)) {
                lastTokens.reset();
                LT_TYPE = new byte[]{9};
                WS_TYPE = new byte[]{9};
                WORD_TYPE = new byte[]{8, 9};
                COLON_TYPE = new byte[]{12};
                PREFIX_TYPE = new byte[]{12};
                ENT_TYPE = new byte[]{14};
                ctx = this.getMode(lastTokens, buffer, lineStart, LT_TYPE, WS_TYPE, WORD_TYPE, COLON_TYPE, PREFIX_TYPE, ENT_TYPE);
            }
            if (ctx.mode == -1 && "ant".equals(modename)) {
                lastTokens.reset();
                LT_TYPE = new byte[]{17};
                WS_TYPE = new byte[]{17};
                WORD_TYPE = new byte[]{17, 8, 9, 10, 11, 18, 6};
                COLON_TYPE = new byte[]{12};
                PREFIX_TYPE = new byte[]{12, 8, 9, 10, 11, 18, 6};
                ENT_TYPE = new byte[]{14};
                ctx = this.getMode(lastTokens, buffer, lineStart, LT_TYPE, WS_TYPE, WORD_TYPE, COLON_TYPE, PREFIX_TYPE, ENT_TYPE);
            }
            if (ctx.mode == -1 && "html".equals(modename)) {
                LT_TYPE = new byte[]{17};
                WS_TYPE = new byte[]{17};
                WORD_TYPE = new byte[]{17, 8};
                COLON_TYPE = new byte[]{17};
                PREFIX_TYPE = new byte[]{17, 8};
                ENT_TYPE = new byte[]{14};
                lastTokens.reset();
                ctx = this.getMode(lastTokens, buffer, lineStart, LT_TYPE, WS_TYPE, WORD_TYPE, COLON_TYPE, PREFIX_TYPE, ENT_TYPE);
            }
            if (ctx.mode == -1 && "maven".equals(modename)) {
                LT_TYPE = new byte[]{17};
                WS_TYPE = new byte[]{17};
                WORD_TYPE = new byte[]{17, 8, 9, 10};
                COLON_TYPE = new byte[]{12};
                PREFIX_TYPE = new byte[]{12, 8, 9, 10};
                ENT_TYPE = new byte[]{14};
                lastTokens.reset();
                ctx = this.getMode(lastTokens, buffer, lineStart, LT_TYPE, WS_TYPE, WORD_TYPE, COLON_TYPE, PREFIX_TYPE, ENT_TYPE);
            }
            if (ctx.mode == -1 && "tld".equals(modename)) {
                LT_TYPE = new byte[]{17};
                WS_TYPE = new byte[]{17};
                WORD_TYPE = new byte[]{17, 8, 9};
                COLON_TYPE = new byte[]{12};
                PREFIX_TYPE = new byte[]{12, 8, 9};
                ENT_TYPE = new byte[]{14};
                lastTokens.reset();
                ctx = this.getMode(lastTokens, buffer, lineStart, LT_TYPE, WS_TYPE, WORD_TYPE, COLON_TYPE, PREFIX_TYPE, ENT_TYPE);
            }
        }
        if (ctx.mode == -1 && (m = this.entP.matcher(buffer.getSegment(start = Math.max(lineStart, caret - 100), caret - start))).matches()) {
            ctx.mode = 38;
            ctx.wordStart = start + m.start(1);
        }
        if (ctx.mode == -1 && (m = this.commentCDATAP.matcher(buffer.getSegment(start = Math.max(lineStart, caret - 100), caret - start))).matches()) {
            ctx.mode = 60;
            ctx.wordStart = start + m.start(1);
        }
        String closingTag = null;
        ArrayList<XmlListCellRenderer.WithLabel<Object>> allowedCompletions = new ArrayList<XmlListCellRenderer.WithLabel<Object>>(20);
        NamespaceBindings namespaces = data.getNamespaceBindings(caret);
        NamespaceBindings namespacesToInsert = new NamespaceBindings();
        NamespaceBindings localNamespacesToInsert = new NamespaceBindings();
        if (ctx.mode != -1) {
            if (ctx.wordStart == -1) {
                if (openTag != null) {
                    String firstSpace;
                    ctx.wordStart = lineStart + openTag.offset + openTag.length;
                    String tolastchar = ((Object)buffer.getSegment(ctx.wordStart, caret - ctx.wordStart)).toString();
                    word = tolastchar.trim().length() == 0 ? "" : ((firstSpace = tolastchar.split("\\s")[0]).length() > 0 ? firstSpace : ((Object)buffer.getSegment(ctx.wordStart, caret - ctx.wordStart)).toString());
                } else {
                    int start2 = TagParser.lastIndexOf(buffer.getSegment(0, lastchar), 60, lastchar - 1);
                    if (start2 < 0) {
                        throw new IllegalStateException("can't find opening of tag??");
                    }
                    ctx.wordStart = start2 + 1;
                    int end = Math.min(start2 + 100, buffer.getLineEndOffset(buffer.getLineOfOffset(start2)));
                    word = buffer.getText(start2 + 1, end).split("\\s")[0];
                }
            } else {
                word = ((Object)buffer.getSegment(ctx.wordStart, caret - ctx.wordStart)).toString();
            }
            if (ctx.mode == 60) {
                String wordWithoutPrefix = XmlParsedData.getElementLocalName(word);
                String wordPrefix = XmlParsedData.getElementNamePrefix(word);
                List<ElementDecl> completions = data.getAllowedElements(buffer, lastchar);
                TagParser.Tag tag = TagParser.findLastOpenTag(buffer.getSegment(0, lastchar - 1), lastchar - 1, data);
                if (tag != null) {
                    closingTag = tag.tag;
                }
                if ("!--".startsWith(word)) {
                    allowedCompletions.add(new XmlListCellRenderer.WithLabel<XmlListCellRenderer.Comment>(new XmlListCellRenderer.Comment()));
                }
                if (!data.html && "![CDATA[".startsWith(word)) {
                    allowedCompletions.add(new XmlListCellRenderer.WithLabel<XmlListCellRenderer.CDATA>(new XmlListCellRenderer.CDATA()));
                }
                if (closingTag != null && (INSTANT_COMPLETION_TRIGGERS + closingTag).startsWith(word)) {
                    if (word.length() == 0 || !jEdit.getBooleanProperty((String)"xml.close-complete")) {
                        allowedCompletions.add(new XmlListCellRenderer.WithLabel<XmlListCellRenderer.ClosingTag>(new XmlListCellRenderer.ClosingTag(closingTag)));
                    } else {
                        XmlActions.completeClosingTag(editPane.getView(), false);
                        return null;
                    }
                }
                for (int i = 0; i < completions.size(); ++i) {
                    String elementName;
                    ElementDecl elementDecl = completions.get(i);
                    String elementNamespace = elementDecl.completionInfo.namespace;
                    if (elementNamespace == null || "".equals(elementNamespace)) {
                        elementName = elementDecl.name;
                    } else {
                        String pre = namespaces.getPrefix(elementNamespace);
                        if (pre == null) {
                            pre = localNamespacesToInsert.getPrefix(elementNamespace);
                        }
                        if (pre == null) {
                            if (!"".equals(wordPrefix) && elementDecl.name.startsWith(wordWithoutPrefix)) {
                                pre = wordPrefix;
                                namespacesToInsert.put(elementNamespace, pre);
                                localNamespacesToInsert.put(elementNamespace, pre);
                                elementName = pre + ":" + elementDecl.name;
                            } else {
                                pre = NamespaceBindings.generatePrefix(namespaces, localNamespacesToInsert);
                                localNamespacesToInsert.put(elementNamespace, pre);
                                elementName = pre + ":" + elementDecl.name;
                            }
                        } else {
                            elementName = "".equals(pre) ? elementDecl.name : pre + ":" + elementDecl.name;
                        }
                    }
                    if (!elementName.startsWith(word) && (!data.html || !elementName.toLowerCase().startsWith(word.toLowerCase()))) continue;
                    allowedCompletions.add(new XmlListCellRenderer.WithLabel<ElementDecl>(elementName, elementDecl));
                }
            } else if (ctx.mode == 38) {
                List<EntityDecl> completions = data.entities;
                for (int i = 0; i < completions.size(); ++i) {
                    EntityDecl entity = completions.get(i);
                    if (!entity.name.startsWith(word)) continue;
                    allowedCompletions.add(new XmlListCellRenderer.WithLabel<EntityDecl>(entity));
                }
            } else if (ctx.mode == 32) {
                String prefix = buffer.getText(ctx.attribStart, caret - ctx.attribStart);
                String wordWithoutPrefix = XmlParsedData.getElementLocalName(prefix);
                String wordPrefix = XmlParsedData.getElementNamePrefix(prefix);
                ElementDecl decl = data.getElementDecl(word, caret);
                if (decl != null) {
                    List<ElementDecl.AttributeDecl> completions = decl.attributes;
                    for (int i = 0; i < completions.size(); ++i) {
                        String attrName;
                        ElementDecl.AttributeDecl attrDecl = completions.get(i);
                        if (attrDecl.namespace == null || "".equals(attrDecl.namespace)) {
                            attrName = attrDecl.name;
                        } else {
                            String pre = namespaces.getPrefix(attrDecl.namespace);
                            if (pre == null || "".equals(pre)) {
                                pre = localNamespacesToInsert.getPrefix(attrDecl.namespace);
                            }
                            if (pre == null || "".equals(pre)) {
                                if (attrDecl.namespace.equals("http://www.w3.org/XML/1998/namespace")) {
                                    attrName = "xml:" + attrDecl.name;
                                } else {
                                    attrName = attrDecl.name;
                                    if (!"".equals(wordPrefix) && !"xml".equals(wordPrefix) && attrName.startsWith(wordWithoutPrefix)) {
                                        pre = wordPrefix;
                                        namespacesToInsert.put(attrDecl.namespace, pre);
                                        localNamespacesToInsert.put(attrDecl.namespace, pre);
                                        attrName = pre + ":" + attrDecl.name;
                                    } else {
                                        pre = NamespaceBindings.generatePrefix(namespaces, localNamespacesToInsert);
                                        localNamespacesToInsert.put(attrDecl.namespace, pre);
                                        attrName = pre + ":" + attrDecl.name;
                                    }
                                }
                            } else {
                                attrName = pre + ":" + attrDecl.name;
                            }
                        }
                        if (!attrName.startsWith(prefix)) continue;
                        allowedCompletions.add(new XmlListCellRenderer.WithLabel<ElementDecl.AttributeDecl>(attrName, attrDecl));
                    }
                }
                word = prefix;
            }
        } else {
            word = "";
        }
        if (word.endsWith(INSTANT_COMPLETION_TRIGGERS) && allowedCompletions.size() == 0) {
            return null;
        }
        return new XmlCompletion(editPane.getView(), allowedCompletions, namespaces, namespacesToInsert, word, data, closingTag);
    }

    private Context getMode(TokenRingBuffer lastTokens, Buffer buffer, int lineStart, byte[] LT_TYPE, byte[] WS_TYPE, byte[] WORD_TYPE, byte[] COLON_TYPE, byte[] PREFIX_TYPE, byte[] ENT_TYPE) {
        Context ctx = new Context();
        if (!lastTokens.isEmpty()) {
            CharSequence img;
            Token last = lastTokens.popLast();
            if (this.matches(last, LT_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), '<')) {
                ctx.mode = 60;
                ctx.wordStart = lineStart + last.offset + last.length;
            } else if (this.matches(last, WS_TYPE, img, this.ws)) {
                ctx.mode = 32;
                ctx.attribStart = lineStart + last.offset + last.length;
            } else if (this.matches(last, LT_TYPE, img, '/')) {
                if (!lastTokens.isEmpty() && this.matches(last = lastTokens.popLast(), LT_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), '<')) {
                    ctx.mode = 60;
                    ctx.wordStart = lineStart + last.offset + last.length;
                }
            } else if (this.matches(last, WORD_TYPE, img, this.wordP)) {
                if (!lastTokens.isEmpty()) {
                    last = lastTokens.popLast();
                    if (this.matches(last, LT_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), '<')) {
                        ctx.mode = 60;
                        ctx.wordStart = lineStart + last.offset + last.length;
                    } else if (this.matches(last, WS_TYPE, img, this.ws)) {
                        ctx.mode = 32;
                        ctx.attribStart = lineStart + last.offset + last.length;
                    } else if (this.matches(last, LT_TYPE, img, '/')) {
                        if (!lastTokens.isEmpty() && this.matches(last = lastTokens.popLast(), LT_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), '<')) {
                            ctx.mode = 60;
                            ctx.wordStart = lineStart + last.offset + last.length;
                        }
                    } else if (this.matches(last, COLON_TYPE, img, ':') && !lastTokens.isEmpty() && this.matches(last = lastTokens.popLast(), PREFIX_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), this.wordP) && !lastTokens.isEmpty()) {
                        last = lastTokens.popLast();
                        if (this.matches(last, LT_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), '<')) {
                            ctx.mode = 60;
                            ctx.wordStart = lineStart + last.offset + last.length;
                        } else if (this.matches(last, WS_TYPE, img, this.ws)) {
                            ctx.mode = 32;
                            ctx.attribStart = lineStart + last.offset + last.length;
                        } else if (this.matches(last, LT_TYPE, img, '/') && !lastTokens.isEmpty() && this.matches(last = lastTokens.popLast(), LT_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), '<')) {
                            ctx.mode = 60;
                            ctx.wordStart = lineStart + last.offset + last.length;
                        }
                    }
                } else {
                    ctx.mode = 32;
                    ctx.attribStart = lineStart;
                }
            } else if (this.matches(last, COLON_TYPE, img, ':')) {
                if (!lastTokens.isEmpty() && this.matches(last = lastTokens.popLast(), PREFIX_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), this.wordP) && !lastTokens.isEmpty()) {
                    last = lastTokens.popLast();
                    if (this.matches(last, LT_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), '<')) {
                        ctx.mode = 60;
                        ctx.wordStart = lineStart + last.offset + last.length;
                    } else if (this.matches(last, WS_TYPE, img, this.ws)) {
                        ctx.mode = 32;
                        ctx.attribStart = lineStart + last.offset + last.length;
                    } else if (this.matches(last, LT_TYPE, img, '/') && !lastTokens.isEmpty() && this.matches(last = lastTokens.popLast(), LT_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), '<')) {
                        ctx.mode = 60;
                        ctx.wordStart = lineStart + last.offset + last.length;
                    }
                }
            } else if (this.matches(last, ENT_TYPE, img, '&')) {
                ctx.mode = 38;
                ctx.wordStart = lineStart + last.offset + last.length;
            } else if (this.matches(last, ENT_TYPE, img, this.wordP) && !lastTokens.isEmpty() && this.matches(last = lastTokens.popLast(), ENT_TYPE, img = buffer.getSegment(lineStart + last.offset, last.length), '&')) {
                ctx.mode = 38;
                ctx.wordStart = lineStart + last.offset + last.length;
            }
        }
        return ctx;
    }

    private boolean matches(Token last, byte[] types, CharSequence img, char wanted) {
        if (last.length != 1) {
            return false;
        }
        boolean okType = false;
        for (int i = 0; i < types.length; ++i) {
            if (last.id != types[i]) continue;
            okType = true;
            break;
        }
        return okType && img.charAt(0) == wanted;
    }

    private boolean matches(Token last, byte[] types, CharSequence img, Pattern wanted) {
        boolean okType = false;
        for (int i = 0; i < types.length; ++i) {
            if (last.id != types[i]) continue;
            okType = true;
            break;
        }
        return okType && wanted.matcher(img).matches();
    }

    private boolean isWord(CharSequence s) {
        return false;
    }

    private boolean isWS(CharSequence s) {
        return false;
    }

    static class TokenRingBuffer {
        private final Token[] tokens;
        public final int size;
        private int start = 0;
        private int end = 0;
        private int savedStart = -1;
        private int savedEnd = -1;

        public TokenRingBuffer(int size) {
            this.size = size;
            this.tokens = new Token[size + 1];
        }

        public boolean isEmpty() {
            return this.start == this.end;
        }

        public void write(Token t) {
            this.tokens[this.end] = t;
            this.end = (this.end + 1) % this.tokens.length;
            if (this.start == this.end) {
                this.start = (this.start + 1) % this.tokens.length;
            }
            this.savedStart = -1;
        }

        public Token popFirst() {
            Token ret = this.tokens[this.start];
            this.start = (this.start + 1) % this.tokens.length;
            return ret;
        }

        public Token popLast() {
            --this.end;
            if (this.end < 0) {
                this.end = this.tokens.length - 1;
            }
            return this.tokens[this.end];
        }

        public void mark() {
            this.savedStart = this.start;
            this.savedEnd = this.end;
        }

        public boolean reset() {
            if (this.savedStart == -1) {
                return false;
            }
            this.start = this.savedStart;
            this.end = this.savedEnd;
            return true;
        }
    }

    private static class Context {
        int mode = -1;
        int wordStart = -1;
        int attribStart = -1;

        private Context() {
        }
    }
}

