/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import errorlist.DefaultErrorSource;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import sidekick.IAsset;
import sidekick.SideKickParsedData;
import xml.AntXmlParsedData;
import xml.CharSequenceReader;
import xml.PathUtilities;
import xml.SchemaMappingManager;
import xml.XmlParsedData;
import xml.completion.CompletionInfo;
import xml.gui.XmlModeToolBar;
import xml.parser.CachedGrammarPool;
import xml.parser.ConstructTreeHandler;
import xml.parser.EntityMgrFixerConfiguration;
import xml.parser.ErrorListErrorHandler;
import xml.parser.GrabIdsAndCompletionInfoHandler;
import xml.parser.MyEntityResolver;
import xml.parser.SchemaAutoLoader;
import xml.parser.SchemaMapping;
import xml.parser.XmlParser;

public class XercesParserImpl
extends XmlParser {
    public static String COMPLETION_INFO_CACHE_ENTRY = "CompletionInfo";
    private View view = null;
    private Map<View, JPanel> panels = new HashMap<View, JPanel>();

    public XercesParserImpl() {
        super("xml");
    }

    public void activate(View view) {
        this.view = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SideKickParsedData parse(Buffer buffer, DefaultErrorSource errorSource) {
        DefaultMutableTreeNode root;
        IAsset rootAsset;
        XmlParsedData data;
        long start;
        block45: {
            String msg;
            start = System.currentTimeMillis();
            Log.log((int)5, XercesParserImpl.class, (Object)("parsing started @" + start));
            this.stopped = false;
            CharSequence text = buffer.getSegment(0, buffer.getLength());
            data = this.createXmlParsedData(buffer.getName(), buffer.getMode().toString(), false);
            if (text.length() == 0) {
                return data;
            }
            ErrorListErrorHandler errorHandler = new ErrorListErrorHandler(errorSource, buffer.getPath());
            SchemaMapping mapping = SchemaMappingManager.isSchemaMappingEnabled(buffer) ? SchemaMappingManager.getSchemaMappingForBuffer(buffer, errorHandler) : null;
            MyEntityResolver resolver = new MyEntityResolver(buffer, errorHandler);
            GrabIdsAndCompletionInfoHandler handler = new GrabIdsAndCompletionInfoHandler(this, buffer, errorHandler, data, resolver);
            Object reader = null;
            SchemaAutoLoader schemaLoader = null;
            try {
                String schemaFromProp;
                reader = new SAXParser((XMLParserConfiguration)new EntityMgrFixerConfiguration(null, new CachedGrammarPool(buffer)));
                reader.setFeature("http://xml.org/sax/features/validation", buffer.getBooleanProperty("xml.validate"));
                reader.setFeature("http://apache.org/xml/features/validation/dynamic", buffer.getBooleanProperty("xml.validate"));
                reader.setFeature("http://apache.org/xml/features/validation/schema", buffer.getBooleanProperty("xml.validate"));
                if (buffer.getBooleanProperty("xml.validate.ignore-dtd")) {
                    reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                }
                reader.setFeature("http://xml.org/sax/features/namespaces", !buffer.getBooleanProperty("xml.namespaces.disable"));
                reader.setFeature("http://xml.org/sax/features/use-entity-resolver2", true);
                reader.setFeature("http://apache.org/xml/features/xinclude", buffer.getBooleanProperty("xml.xinclude"));
                reader.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", buffer.getBooleanProperty("xml.xinclude.fixup-base-uris"));
                reader.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                schemaLoader = new SchemaAutoLoader((XMLReader)reader, mapping, buffer);
                schemaLoader.setErrorHandler(errorHandler);
                schemaLoader.setContentHandler(handler);
                schemaLoader.setEntityResolver(resolver);
                handler.setSchemaAutoLoader(schemaLoader);
                reader = schemaLoader;
                if (!SchemaMappingManager.isSchemaMappingEnabled(buffer) && (schemaFromProp = buffer.getStringProperty("xml.validation.schema")) != null) {
                    String baseURI = PathUtilities.pathToURL(buffer.getPath());
                    Log.log((int)5, (Object)((Object)this), (Object)("forcing schema to {" + baseURI + "," + schemaFromProp + "}"));
                    try {
                        schemaLoader.forceSchema(baseURI, schemaFromProp);
                    }
                    catch (IOException ioe) {
                        Log.log((int)7, (Object)((Object)this), (Object)("I/O error loading forced schema: " + ioe.getClass() + ": " + ioe.getMessage()));
                    }
                    catch (URISyntaxException e) {
                        Log.log((int)7, (Object)((Object)this), (Object)("forced schema URL is invalid: " + e.getMessage()));
                    }
                }
            }
            catch (SAXException se) {
                Log.log((int)9, (Object)((Object)this), (Object)"unexpected error preparing XML parser, please report", (Throwable)se);
            }
            CompletionInfo info = CompletionInfo.getCompletionInfoForBuffer(buffer);
            if (info != null) {
                data.setCompletionInfo("", info);
            }
            Exception errorParsing = null;
            InputSource source = new InputSource();
            String rootDocument = buffer.getStringProperty("xml.root");
            if (rootDocument != null) {
                Log.log((int)5, (Object)((Object)this), (Object)("rootDocument specified; parsing " + rootDocument));
                rootDocument = MiscUtilities.constructPath((String)MiscUtilities.getParentOfPath((String)buffer.getPath()), (String)rootDocument);
                source.setSystemId(PathUtilities.pathToURL(rootDocument));
            } else {
                source.setCharacterStream(new CharSequenceReader(text));
                source.setSystemId(PathUtilities.pathToURL(buffer.getPath()));
            }
            try {
                reader.parse(source);
            }
            catch (StoppedException e) {
                errorParsing = e;
            }
            catch (MyEntityResolver.IOExceptionWithLocation ioe) {
                msg = "I/O error while parsing: " + ioe.getMessage() + ", caused by " + ioe.getCause().getClass().getName() + ": " + ioe.getCause().getMessage();
                errorSource.addError(0, ioe.path, ioe.line, 0, 0, msg);
                errorParsing = ioe;
            }
            catch (IOException ioe) {
                errorSource.addError(0, buffer.getPath(), 0, 0, 0, ioe.getClass() + ": " + ioe.getMessage());
                errorParsing = ioe;
            }
            catch (SAXParseException spe) {
                errorParsing = spe;
            }
            catch (SAXException se) {
                msg = "SAX exception while parsing";
                Exception t = se.getException();
                if (msg != null) {
                    msg = msg + ": " + se.getMessage();
                }
                if (t != null) {
                    msg = msg + " caused by " + t;
                }
                errorSource.addError(0, buffer.getPath(), 0, 0, 0, msg);
                errorParsing = se;
            }
            finally {
                String url = null;
                if (schemaLoader != null && schemaLoader.getSchemaURL() != null) {
                    url = schemaLoader.getSchemaURL();
                } else if (handler.xsdSchemaURLs != null && !handler.xsdSchemaURLs.isEmpty()) {
                    url = handler.xsdSchemaURLs.get(0);
                }
                if (url != null) {
                    buffer.setStringProperty("xml.validation.schema-auto", url);
                }
            }
            if (!(errorParsing instanceof StoppedException)) {
                if (!handler.seenBuffer && rootDocument != null) {
                    String msg2 = "Buffer is not reachable from root document. Check that you didn't forget to xi:include it.";
                    errorSource.addError(1, buffer.getPath(), 0, 0, 0, msg2);
                }
                ConstructTreeHandler treeHandler = new ConstructTreeHandler(this, buffer, text, errorHandler, data, resolver);
                reader = null;
                try {
                    reader = new SAXParser((XMLParserConfiguration)new EntityMgrFixerConfiguration(null, new CachedGrammarPool(buffer)));
                    reader.setFeature("http://xml.org/sax/features/validation", false);
                    reader.setFeature("http://xml.org/sax/features/namespaces", !buffer.getBooleanProperty("xml.namespaces.disable"));
                    reader.setFeature("http://xml.org/sax/features/use-entity-resolver2", true);
                    reader.setFeature("http://apache.org/xml/features/xinclude", false);
                    reader.setContentHandler(treeHandler);
                    reader.setEntityResolver(resolver);
                    if (!handler.seenBuffer && rootDocument != null) {
                        reader.setErrorHandler(errorHandler);
                    }
                }
                catch (SAXException se) {
                    Log.log((int)9, (Object)((Object)this), (Object)"error preparing to parse 2nd pass), please report !", (Throwable)se);
                }
                source = new InputSource();
                source.setCharacterStream(new CharSequenceReader(text));
                source.setSystemId(PathUtilities.pathToURL(buffer.getPath()));
                try {
                    reader.parse(source);
                }
                catch (StoppedException e) {
                }
                catch (IOException e) {
                    if (errorParsing == null || !e.getClass().equals(errorParsing.getClass()) || !e.toString().equals(errorParsing.toString())) {
                        Log.log((int)9, (Object)((Object)this), (Object)("I/O error upon snd reparse :" + e.getClass() + ": " + e.getMessage()));
                    }
                }
                catch (SAXParseException se) {
                }
                catch (SAXException se) {
                    if (errorParsing != null && se.getClass().equals(errorParsing.getClass()) && se.toString().equals(errorParsing.toString())) break block45;
                    String msg3 = "SAX exception while parsing (constructing sidekick tree)";
                    Exception t = se.getException();
                    if (msg3 != null) {
                        msg3 = msg3 + ": " + se.getMessage();
                    }
                    if (t != null) {
                        msg3 = msg3 + " caused by " + t;
                    }
                    errorSource.addError(0, buffer.getPath(), 0, 0, 0, msg3);
                }
            }
        }
        if ("project".equals((rootAsset = (IAsset)(root = data.root).getUserObject()).getName())) {
            buffer.setMode("ant");
            AntXmlParsedData pd = new AntXmlParsedData(buffer.getName(), false);
            pd.root = data.root;
            pd.tree = data.tree;
            pd.expansionModel = data.expansionModel;
            data = pd;
        }
        data.done(this.view);
        long end = System.currentTimeMillis();
        Log.log((int)5, XercesParserImpl.class, (Object)("parsing has taken " + (end - start) + "ms"));
        return data;
    }

    private XmlParsedData createXmlParsedData(String filename, String modeName, boolean html) {
        String dataClassName = jEdit.getProperty((String)("xml.xmlparseddata." + modeName));
        if (dataClassName != null) {
            try {
                Class<?> dataClass = Class.forName(dataClassName);
                Constructor<?> con = dataClass.getConstructor(String.class, Boolean.TYPE);
                return (XmlParsedData)((Object)con.newInstance(filename, html));
            }
            catch (Exception e) {
                Log.log((int)9, (Object)((Object)this), (Object)"createXmlParsedData()", (Throwable)e);
            }
        }
        return new XmlParsedData(filename, html);
    }

    public JPanel getPanel() {
        if (this.view != null) {
            String mode = this.view.getBuffer().getMode().toString();
            String supported = jEdit.getProperty((String)"xml.xmltoolbar.modes");
            if (supported.indexOf(mode) > -1) {
                JPanel panel = this.panels.get(this.view);
                if (panel != null) {
                    return panel;
                }
                XmlModeToolBar toolbar = new XmlModeToolBar(this.view);
                this.panels.put(this.view, toolbar);
                return toolbar;
            }
        }
        return null;
    }

    static class StoppedException
    extends SAXException {
        StoppedException() {
            super("Parsing stopped");
        }
    }
}

