/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.util.Log;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import xml.Resolver;
import xml.cache.Cache;
import xml.cache.CacheEntry;
import xml.completion.CompletionInfo;
import xml.completion.ElementDecl;
import xml.parser.SchemaLoader;
import xml.parser.XercesParserImpl;

public class XSDSchemaToCompletion {
    private static void xsElementToElementDecl(XSNamedMap elements, Map<String, CompletionInfo> infos, XSElementDeclaration element, ElementDecl parent, Map<XSComplexTypeDefinition, List<ElementDecl>> seenComplexTypes) {
        CompletionInfo info;
        if (parent != null && parent.content == null) {
            parent.content = new HashSet<String>();
        }
        if (parent != null && parent.elementHash == null) {
            parent.elementHash = new HashMap<String, ElementDecl>();
        }
        String name = element.getName();
        String namespace = element.getNamespace();
        if (namespace == null) {
            namespace = "";
        }
        if (infos.containsKey(namespace)) {
            info = infos.get(namespace);
        } else {
            info = new CompletionInfo();
            info.namespace = namespace;
            infos.put(namespace, info);
        }
        if (info.elementHash.containsKey(name)) {
            if (parent != null) {
                parent.content.add(name);
                parent.elementHash.put(name, info.elementHash.get(name));
            }
            return;
        }
        ElementDecl elementDecl = null;
        if (element.getAbstract()) {
            if (parent != null) {
                for (int j = 0; j < elements.getLength(); ++j) {
                    XSElementDeclaration decl = (XSElementDeclaration)elements.item(j);
                    XSElementDeclaration group = decl.getSubstitutionGroupAffiliation();
                    if (group == null || !group.getName().equals(name)) continue;
                    XSDSchemaToCompletion.xsElementToElementDecl(elements, infos, decl, parent, seenComplexTypes);
                }
            }
            return;
        }
        elementDecl = new ElementDecl(info, name, null);
        XSTypeDefinition typedef = element.getTypeDefinition();
        XSComplexTypeDefinition complex = null;
        boolean needToCalcContent = true;
        if (typedef.getTypeCategory() == 15 && seenComplexTypes.containsKey(complex = (XSComplexTypeDefinition)typedef)) {
            ElementDecl same = null;
            for (ElementDecl decl : seenComplexTypes.get(complex)) {
                if (decl.completionInfo != info || !decl.name.equals(name)) continue;
                same = decl;
                break;
            }
            if (same == null) {
                ElementDecl sameContent = seenComplexTypes.get(complex).get(0);
                elementDecl.attributes = sameContent.attributes;
                elementDecl.attributeHash = sameContent.attributeHash;
                elementDecl.content = sameContent.content;
                elementDecl.elementHash = sameContent.elementHash;
                needToCalcContent = false;
            } else {
                if (parent != null) {
                    parent.elementHash.put(name, same);
                    parent.content.add(name);
                }
                return;
            }
        }
        if (element.getScope() == 2) {
            if (!info.nameConflict) {
                for (ElementDecl e : info.elements) {
                    if (!e.name.equals(name)) continue;
                    info.nameConflict = true;
                }
            }
            info.elements.add(elementDecl);
        } else {
            info.addElement(elementDecl);
        }
        if (parent != null) {
            parent.elementHash.put(name, elementDecl);
            parent.content.add(name);
        }
        if (complex != null && needToCalcContent) {
            ArrayList<ElementDecl> l = new ArrayList<ElementDecl>();
            l.add(elementDecl);
            seenComplexTypes.put(complex, l);
            XSParticle particle = complex.getParticle();
            if (particle != null) {
                XSTerm particleTerm = particle.getTerm();
                if (particleTerm instanceof XSWildcard) {
                    elementDecl.any = true;
                } else {
                    XSDSchemaToCompletion.xsTermToElementDecl(elements, infos, particleTerm, elementDecl, seenComplexTypes);
                }
            }
            XSObjectList attributes = complex.getAttributeUses();
            for (int i = 0; i < attributes.getLength(); ++i) {
                XSAttributeUse attr = (XSAttributeUse)attributes.item(i);
                XSDSchemaToCompletion.xsAttributeToElementDecl(elementDecl, attr.getAttrDeclaration(), attr.getRequired());
            }
        }
    }

    private static void xsAttributeToElementDecl(ElementDecl elementDecl, XSAttributeDeclaration decl, boolean required) {
        String attrName = decl.getName();
        String attrNamespace = decl.getNamespace();
        String value = decl.getConstraintValue();
        XSSimpleTypeDefinition typeDef = decl.getTypeDefinition();
        String type = typeDef.getName();
        StringList valueStringList = typeDef.getLexicalEnumeration();
        ArrayList<String> values = new ArrayList<String>();
        for (int j = 0; j < valueStringList.getLength(); ++j) {
            values.add(valueStringList.item(j));
        }
        if (type == null) {
            type = "CDATA";
        }
        elementDecl.addAttribute(new ElementDecl.AttributeDecl(attrName, attrNamespace, value, values, type, required));
    }

    private static void xsTermToElementDecl(XSNamedMap elements, Map<String, CompletionInfo> infos, XSTerm term, ElementDecl parent, Map<XSComplexTypeDefinition, List<ElementDecl>> seenComplexTypes) {
        if (term instanceof XSElementDeclaration) {
            XSDSchemaToCompletion.xsElementToElementDecl(elements, infos, (XSElementDeclaration)term, parent, seenComplexTypes);
        } else if (term instanceof XSModelGroup) {
            XSObjectList content = ((XSModelGroup)term).getParticles();
            for (int i = 0; i < content.getLength(); ++i) {
                XSTerm childTerm = ((XSParticleDecl)content.item(i)).getTerm();
                XSDSchemaToCompletion.xsTermToElementDecl(elements, infos, childTerm, parent, seenComplexTypes);
            }
        }
    }

    public static Map<String, CompletionInfo> modelToCompletionInfo(XSModel model) {
        HashMap<String, CompletionInfo> infos = new HashMap<String, CompletionInfo>();
        XSNamedMap elements = model.getComponents((short)2);
        HashMap<XSComplexTypeDefinition, List<ElementDecl>> seenComplexTypes = new HashMap<XSComplexTypeDefinition, List<ElementDecl>>();
        for (int i = 0; i < elements.getLength(); ++i) {
            XSElementDeclaration element = (XSElementDeclaration)elements.item(i);
            XSDSchemaToCompletion.xsElementToElementDecl(elements, infos, element, null, seenComplexTypes);
        }
        return infos;
    }

    public static Map<String, CompletionInfo> getCompletionInfoFromSchema(String location, String schemaLocation, String nonsSchemaLocation, ErrorHandler errorHandler, Buffer buffer) throws IOException, SAXException {
        String realLocation = Resolver.instance().resolveEntityToPath(null, null, buffer.getPath(), location);
        if (realLocation == null) {
            throw new IOException("unable to resolve grammar location for : " + location);
        }
        CacheEntry entry = Cache.instance().get(realLocation, XercesParserImpl.COMPLETION_INFO_CACHE_ENTRY);
        if (entry == null) {
            entry = Cache.instance().get(realLocation, "http://www.w3.org/2001/XMLSchema");
            Grammar grammar = null;
            grammar = entry == null ? SchemaLoader.instance().loadXercesGrammar(buffer, location, schemaLocation, nonsSchemaLocation, errorHandler) : (Grammar)entry.getCachedItem();
            if (grammar == null) {
                throw new SAXException("couldn't load grammar " + location + " from " + realLocation);
            }
            XSModel model = ((XSGrammar)grammar).toXSModel();
            XSNamespaceItemList namespaces = model.getNamespaceItems();
            ArrayList<CacheEntry> related = new ArrayList<CacheEntry>(namespaces.getLength());
            for (int i = 0; i < namespaces.getLength(); ++i) {
                XSNamespaceItem namespace = namespaces.item(i);
                StringList l = namespace.getDocumentLocations();
                for (int j = 0; j < l.getLength(); ++j) {
                    String loc = l.item(j);
                    try {
                        String realLoc = Resolver.instance().resolveEntityToPath(null, null, buffer.getPath(), l.item(j));
                        CacheEntry ce = Cache.instance().put(realLoc, "GrammarComponent", "Dummy");
                        related.add(ce);
                        continue;
                    }
                    catch (IOException ioe) {
                        Log.log((int)9, XSDSchemaToCompletion.class, (Object)("error resolving path for " + loc), (Throwable)ioe);
                    }
                }
            }
            Map<String, CompletionInfo> infos = XSDSchemaToCompletion.modelToCompletionInfo(model);
            related.add(Cache.instance().put(realLocation, XercesParserImpl.COMPLETION_INFO_CACHE_ENTRY, infos));
            for (CacheEntry ce : related) {
                ce.getRelated().addAll(related);
                ce.getRelated().remove(ce);
                ce.getRequestingBuffers().add(buffer);
            }
            return infos;
        }
        entry.addRequestingBuffer(buffer);
        Map infos = (Map)entry.getCachedItem();
        return infos;
    }
}

