/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import xml.XmlParsedData;
import xml.completion.ElementDecl;

public class TagParser {
    public static final int T_STANDALONE_TAG = 0;
    public static final int T_START_TAG = 1;
    public static final int T_END_TAG = 2;

    public static Tag getTagAtOffset(CharSequence text, int pos) {
        if (pos < 0 || pos > text.length()) {
            return null;
        }
        int startTag = TagParser.lastIndexOf(text, 60, pos - 1);
        if (startTag == -1 || startTag + 2 >= text.length()) {
            return null;
        }
        int len = text.length();
        int endTag = 0;
        for (int i = startTag + 1; i < len; ++i) {
            char ch = text.charAt(i);
            if (ch == '>') {
                endTag = i + 1;
                break;
            }
            if (ch != '\'' && ch != '\"') continue;
            int nextQuote = TagParser.indexOf(text, ch, i + 1);
            if (nextQuote == -1) {
                System.err.println("quote is not closed !");
                return null;
            }
            i = nextQuote;
        }
        if (endTag == 0 || endTag < pos) {
            return null;
        }
        int tagType = 1;
        int startTagName = startTag + 1;
        if (text.charAt(startTagName) == '/') {
            tagType = 2;
            ++startTagName;
        } else if (text.charAt(startTagName) == '?' || text.charAt(startTagName) == '!' || text.charAt(startTagName) == '%') {
            return null;
        }
        int endTagName = endTag - 1;
        for (int i = startTagName; i < endTag - 1; ++i) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (endTagName != endTag - 1) continue;
                endTagName = i;
                continue;
            }
            if (ch == '<') {
                return null;
            }
            if (ch != '/' || i != endTag - 2) continue;
            if (endTagName == endTag - 1) {
                endTagName = i;
            }
            tagType = 0;
        }
        Tag tag = new Tag(startTag, endTag);
        tag.tag = ((Object)text.subSequence(startTagName, endTagName)).toString();
        tag.type = tagType;
        return tag;
    }

    public static Tag getMatchingTag(CharSequence text, Tag tag) {
        if (tag.type == 1) {
            return TagParser.findEndTag(text, tag);
        }
        if (tag.type == 2) {
            return TagParser.findStartTag(text, tag);
        }
        return null;
    }

    public static Tag findLastOpenTag(CharSequence text, int pos, XmlParsedData data) {
        Stack<String> tagStack = new Stack<String>();
        boolean notATag = false;
        for (int i = Math.min(text.length() - 1, pos); i >= 0; --i) {
            ElementDecl decl;
            String tagName;
            char ch2;
            char ch = text.charAt(i);
            if (ch == '<') {
                char ch22;
                if (i == text.length() - 1 || (ch22 = text.charAt(i + 1)) == '/' || ch22 == '\'' || ch22 == '\"' || Character.isWhitespace(ch22) || Character.isLetterOrDigit(ch22)) continue;
                notATag = false;
                continue;
            }
            if (ch != '>' || notATag) continue;
            if (i != 0 && (ch2 = text.charAt(i - 1)) != '/' && ch2 != '\'' && ch2 != '\"' && !Character.isWhitespace(ch2) && !Character.isLetterOrDigit(ch2)) {
                notATag = true;
                continue;
            }
            Tag tag = TagParser.getTagAtOffset(text, i + 1);
            if (tag == null) continue;
            if (data == null) {
                tagName = tag.tag;
                decl = null;
            } else if (data.html) {
                tagName = tag.tag.toLowerCase();
                decl = data.getElementDecl(tag.tag, tag.start + 1);
            } else {
                tagName = tag.tag;
                decl = null;
            }
            if (tag.type == 0 || decl != null && decl.empty) continue;
            if (tag.type == 1) {
                if (tagStack.empty()) {
                    return tag;
                }
                int unwindIndex = -1;
                for (int j = tagStack.size() - 1; j >= 0; --j) {
                    if (!((String)tagStack.get(j)).equals(tagName)) continue;
                    unwindIndex = j;
                    break;
                }
                if (unwindIndex == -1) {
                    return tag;
                }
                while (unwindIndex != tagStack.size()) {
                    tagStack.remove(unwindIndex);
                }
                continue;
            }
            if (tag.type != 2) continue;
            tagStack.push(tagName);
        }
        return null;
    }

    public static boolean isInsideTag(CharSequence text, int pos) {
        int start = TagParser.lastIndexOf(text, 60, pos);
        if (start > -1 && start < pos) {
            int end = -1;
            int len = text.length();
            for (int i = start + 1; i < len && i < pos; ++i) {
                char ch = text.charAt(i);
                if (ch == '>') {
                    end = i;
                    break;
                }
                if (ch != '\'' && ch != '\"') continue;
                int nextQuote = TagParser.indexOf(text, ch, i + 1);
                if (nextQuote == -1) {
                    System.err.println("quote is not closed !");
                    return false;
                }
                i = nextQuote;
            }
            if (end == -1) {
                return true;
            }
            return end < start;
        }
        return false;
    }

    private static Tag findEndTag(CharSequence text, Tag startTag) {
        int tagCounter = 0;
        boolean notATag = false;
        for (int i = startTag.end; i < text.length(); ++i) {
            char ch2;
            char ch = text.charAt(i);
            if (ch == '<') {
                if (notATag) continue;
                if (i != text.length() - 1 && (ch2 = text.charAt(i + 1)) != '/' && !Character.isWhitespace(ch2) && !Character.isLetterOrDigit(ch2)) {
                    notATag = true;
                    continue;
                }
                Tag tag = TagParser.getTagAtOffset(text, i + 1);
                if (tag == null) continue;
                if (tag.tag.equals(startTag.tag)) {
                    if (tag.type == 2) {
                        if (tagCounter == 0) {
                            return tag;
                        }
                        --tagCounter;
                    } else if (tag.type == 1) {
                        ++tagCounter;
                    }
                }
                i = tag.end - 1;
                continue;
            }
            if (ch != '>' || i == 0 || (ch2 = text.charAt(i - 1)) == '\"' || ch2 == '\'' || Character.isWhitespace(ch2) || Character.isLetterOrDigit(ch2)) continue;
            notATag = false;
        }
        return null;
    }

    private static Tag findStartTag(CharSequence text, Tag endTag) {
        int tagCounter = 0;
        boolean notATag = false;
        for (int i = endTag.start - 1; i >= 0; --i) {
            char ch2;
            char ch = text.charAt(i);
            if (ch == '<') {
                char ch22;
                if (i == text.length() - 1 || (ch22 = text.charAt(i + 1)) == '/' || ch22 == '\'' || ch22 == '\"' || Character.isWhitespace(ch22) || Character.isLetterOrDigit(ch22)) continue;
                notATag = false;
                continue;
            }
            if (ch != '>' || notATag) continue;
            if (i != 0 && (ch2 = text.charAt(i - 1)) != '/' && ch2 != '\'' && ch2 != '\"' && !Character.isWhitespace(ch2) && !Character.isLetterOrDigit(ch2)) {
                notATag = true;
                continue;
            }
            Tag tag = TagParser.getTagAtOffset(text, i + 1);
            if (tag == null) continue;
            if (tag.tag.equals(endTag.tag)) {
                if (tag.type == 1) {
                    if (tagCounter == 0) {
                        return tag;
                    }
                    --tagCounter;
                } else if (tag.type == 2) {
                    ++tagCounter;
                }
            }
            i = tag.start;
        }
        return null;
    }

    public static List<Attr> getAttrs(CharSequence text, Tag tag) {
        if (tag.type == 1 || tag.type == 0) {
            ArrayList<Attr> attrs = new ArrayList<Attr>();
            int end = tag.end;
            if (tag.type == 0) {
                --end;
            }
            if (text.length() < end) {
                end = text.length();
            }
            int startAttrName = -1;
            int endAttrName = -1;
            boolean inName = false;
            for (int i = tag.start + tag.tag.length() + 1; i < end; ++i) {
                char ch = text.charAt(i);
                if (Character.isWhitespace((int)ch)) {
                    if (!inName) continue;
                    endAttrName = i;
                    inName = false;
                    continue;
                }
                if (startAttrName == -1) {
                    startAttrName = i;
                    inName = true;
                    continue;
                }
                if (ch == '=') {
                    if (!inName) continue;
                    endAttrName = i;
                    inName = false;
                    continue;
                }
                if (ch != '\'' && ch != '\"') continue;
                int nextQuote = TagParser.indexOf(text, ch, i + 1);
                if (nextQuote == -1) {
                    System.err.println("quote is not closed !");
                    break;
                }
                Attr a = new Attr(startAttrName, nextQuote + 1);
                a.name = ((Object)text.subSequence(startAttrName, endAttrName)).toString();
                a.val = ((Object)text.subSequence(i, nextQuote + 1)).toString();
                attrs.add(a);
                startAttrName = -1;
                endAttrName = -1;
                inName = false;
                i = nextQuote;
            }
            return attrs;
        }
        return Collections.emptyList();
    }

    public static int lastIndexOf(CharSequence text, int c, int pos) {
        int len = text.length();
        if (pos >= len) {
            pos = len - 1;
        }
        for (int i = pos; i >= 0; --i) {
            if (text.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence text, int c, int pos) {
        int len = text.length();
        if (pos >= len) {
            return -1;
        }
        for (int i = pos; i < len; ++i) {
            if (text.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static class Attr {
        public String name = null;
        public String val = null;
        public int start;
        public int end;

        Attr(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.name + "=" + this.val;
        }
    }

    public static class Tag
    extends StructureMatcher.Match {
        public String tag = null;
        public int type = -1;

        Tag(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "<" + this.tag + ">";
                }
                case 0: {
                    return "<" + this.tag + "/>";
                }
                case 2: {
                    return "</" + this.tag + ">";
                }
            }
            throw new InternalError();
        }
    }
}

