/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import com.thaiopensource.relaxng.edit.AbstractPatternVisitor;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameClassVisitor;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.ParentRefPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextAnnotation;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.util.Log;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import xml.Resolver;
import xml.cache.Cache;
import xml.cache.CacheEntry;
import xml.completion.CompletionInfo;
import xml.completion.ElementDecl;
import xml.translate.BufferCompactParseInputFormat;
import xml.translate.BufferSAXParseInputFormat;
import xml.translate.EntityResolverWrapper;

public class SchemaToCompletion {
    private static final String RNG_DTD_COMPATIBILITY_NS = "http://relaxng.org/ns/compatibility/annotations/1.0";
    private static final String INHERIT = "#inherit";
    private static final String ANY = "__WHAT_YOU_WANT_IN_NS__";

    public static Map<String, CompletionInfo> rngSchemaToCompletionInfo(String current, String schemaFileNameOrURL, ErrorHandler handler, Buffer requestingBuffer) {
        Map<String, CompletionInfo> infos = new HashMap<String, CompletionInfo>();
        String realLocation = null;
        try {
            realLocation = Resolver.instance().resolveEntityToPath(null, null, current, schemaFileNameOrURL);
        }
        catch (IOException ioe) {
            Log.log((int)9, SchemaToCompletion.class, (Object)"error resolving schema location", (Throwable)ioe);
            return infos;
        }
        CacheEntry en = Cache.instance().get(realLocation, "CompletionInfo");
        if (en == null) {
            Object pif = schemaFileNameOrURL.endsWith(".rnc") ? new BufferCompactParseInputFormat() : new BufferSAXParseInputFormat();
            try {
                InputSource is = Resolver.instance().resolveEntity(null, null, current, schemaFileNameOrURL);
                SchemaCollection schemas = pif.load(is.getSystemId(), new String[0], "unused", handler, (com.thaiopensource.resolver.Resolver)new EntityResolverWrapper(Resolver.instance(), false));
                SchemaDocument mainSchema = (SchemaDocument)schemas.getSchemaDocumentMap().get(schemas.getMainUri());
                Pattern p = mainSchema.getPattern();
                MyPatternVisitor v = new MyPatternVisitor(infos, schemas);
                List roots = (List)p.accept((PatternVisitor)v);
                v.addRootsToCompletionInfos(roots);
                v.resolveRefs();
                if (infos.containsKey(INHERIT)) {
                    CompletionInfo nons = infos.get(INHERIT);
                    nons.namespace = "";
                    infos.put("", nons);
                    infos.remove(INHERIT);
                }
                ArrayList<CacheEntry> related = new ArrayList<CacheEntry>(schemas.getSchemaDocumentMap().size());
                for (String url : schemas.getSchemaDocumentMap().keySet()) {
                    try {
                        String realLoc = Resolver.instance().resolveEntityToPath(null, null, current, url);
                        CacheEntry ce = Cache.instance().put(realLoc, "GrammarComponent", "Dummy");
                        related.add(ce);
                    }
                    catch (IOException ioe) {
                        Log.log((int)9, SchemaToCompletion.class, (Object)("error resolving path for " + url), (Throwable)ioe);
                    }
                }
                related.add(Cache.instance().put(realLocation, "CompletionInfo", infos));
                for (CacheEntry ce : related) {
                    ce.getRelated().addAll(related);
                    ce.getRelated().remove(ce);
                    ce.getRequestingBuffers().add(requestingBuffer);
                }
            }
            catch (Exception e) {
                Log.log((int)9, SchemaToCompletion.class, (Object)e);
            }
        } else {
            infos = (Map)en.getCachedItem();
        }
        return infos;
    }

    private static class MyPatternVisitor
    extends AbstractPatternVisitor<List>
    implements ComponentVisitor<List> {
        private Map<String, CompletionInfo> info;
        private SchemaCollection schemas;
        private StackableMap<String, List<DefineComponent>> defines;
        private Map<DefineComponent, List> definesContents;
        private boolean empty = false;
        private boolean required = true;
        private ElementDecl parent;

        MyPatternVisitor(Map<String, CompletionInfo> info, SchemaCollection schemas) {
            this.info = info;
            this.schemas = schemas;
            this.parent = null;
            this.defines = new StackableMap(2);
            this.definesContents = new HashMap<DefineComponent, List>();
        }

        public List visitAttribute(AttributeAnnotation a) {
            throw new UnsupportedOperationException("visitAttribute(Annotation)");
        }

        public List visitAttribute(AttributePattern p) {
            MyAttributeVisitor visitor = new MyAttributeVisitor(this.defines, this.required);
            List attrs = (List)p.accept((PatternVisitor)visitor);
            if (this.parent != null) {
                for (ElementDecl.AttributeDecl d : attrs) {
                    this.parent.addAttribute(d);
                }
            }
            return attrs;
        }

        public List visitChoice(ChoicePattern p) {
            boolean savedRequired = this.required;
            this.required = false;
            ArrayList res = new ArrayList();
            for (Pattern c : p.getChildren()) {
                res.addAll((Collection)c.accept((PatternVisitor)this));
            }
            this.required = savedRequired;
            return res;
        }

        public List visitComment(Comment c) {
            return Collections.emptyList();
        }

        public List visitComponent(Component c) {
            throw new UnsupportedOperationException(" visitComponent() should not be called");
        }

        public List visitData(DataPattern p) {
            return Collections.emptyList();
        }

        public List visitDefine(DefineComponent c) {
            return Collections.emptyList();
        }

        public List visitDiv(DivComponent p) {
            ArrayList res = new ArrayList();
            for (Component c : p.getComponents()) {
                res.addAll((Collection)c.accept((ComponentVisitor)this));
            }
            return res;
        }

        public List visitElement(ElementAnnotation ea) {
            throw new UnsupportedOperationException("visitElement(Annotation)");
        }

        public List visitElement(ElementPattern p) {
            ElementDecl myParent = this.parent;
            this.empty = false;
            MyNameClassVisitor nameVisitor = new MyNameClassVisitor();
            List myNames = (List)p.getNameClass().accept((NameClassVisitor)nameVisitor);
            boolean isEmpty = this.empty;
            boolean isRequired = this.required;
            this.required = true;
            if (this.parent != null && this.parent.content == null) {
                this.parent.content = new HashSet<String>();
            }
            if (this.parent != null && this.parent.elementHash == null) {
                this.parent.elementHash = new HashMap<String, ElementDecl>();
            }
            ArrayList<ElementDecl> res = new ArrayList<ElementDecl>();
            for (Name name : myNames) {
                ElementDecl me;
                CompletionInfo myInfo = this.info.get(name.getNamespaceUri());
                if (myInfo == null) {
                    myInfo = new CompletionInfo();
                    myInfo.namespace = name.getNamespaceUri();
                    this.info.put(name.getNamespaceUri(), myInfo);
                }
                if ((me = myInfo.elementHash.get(name.getLocalName())) == null) {
                    me = new ElementDecl(myInfo, name.getLocalName(), "");
                    if (this.parent == null) {
                        myInfo.addElement(me);
                    } else {
                        myInfo.elements.add(me);
                    }
                    this.parent = me;
                    p.getChild().accept((PatternVisitor)this);
                    this.parent = myParent;
                }
                res.add(me);
                if (myParent == null) continue;
                myParent.content.add(name.getLocalName());
                myParent.elementHash.put(name.getLocalName(), me);
            }
            if (myParent != null) {
                myParent.any = nameVisitor.any;
                myParent.empty = isEmpty;
            }
            this.required = isRequired;
            return res;
        }

        public List visitEmpty(EmptyPattern p) {
            this.empty = true;
            return Collections.emptyList();
        }

        public List visitExternalRef(ExternalRefPattern p) {
            SchemaDocument sc = (SchemaDocument)this.schemas.getSchemaDocumentMap().get(p.getUri());
            return (List)sc.getPattern().accept((PatternVisitor)this);
        }

        public List visitGrammar(GrammarPattern p) {
            this.defines.push((Map)p.accept((PatternVisitor)new GrabDefinesVisitor()));
            p.componentsAccept((ComponentVisitor)this);
            ArrayList res = new ArrayList();
            if (this.defines.containsKey(DefineComponent.START)) {
                for (DefineComponent dc : this.defines.get(DefineComponent.START)) {
                    res.addAll((Collection)dc.getBody().accept((PatternVisitor)this));
                }
            } else {
                throw new IllegalArgumentException("Grammar without a start element !");
            }
            this.defines.pop();
            return res;
        }

        public List visitGroup(GroupPattern p) {
            ArrayList res = new ArrayList();
            for (Pattern c : p.getChildren()) {
                res.addAll((Collection)c.accept((PatternVisitor)this));
            }
            return res;
        }

        public List visitInclude(IncludeComponent c) {
            SchemaDocument sc = (SchemaDocument)this.schemas.getSchemaDocumentMap().get(c.getUri());
            GrammarPattern g = (GrammarPattern)sc.getPattern();
            Map grammarDefinitions = (Map)g.accept((PatternVisitor)new GrabDefinesVisitor());
            GrabDefinesVisitor v = new GrabDefinesVisitor();
            c.componentsAccept((ComponentVisitor)v);
            Map includeDefinitions = v.comps;
            grammarDefinitions.putAll(includeDefinitions);
            Map<String, List<DefineComponent>> parentDefinitions = this.defines.pop();
            for (Map.Entry e : grammarDefinitions.entrySet()) {
                if (!parentDefinitions.containsKey(e.getKey())) {
                    parentDefinitions.put((String)e.getKey(), new ArrayList());
                }
                parentDefinitions.get(e.getKey()).addAll((Collection)e.getValue());
            }
            this.defines.push(parentDefinitions);
            if (this.defines.containsKey(DefineComponent.START)) {
                ArrayList res = new ArrayList();
                for (DefineComponent dc : this.defines.get(DefineComponent.START)) {
                    res.addAll((Collection)dc.getBody().accept((PatternVisitor)this));
                }
                return res;
            }
            throw new UnsupportedOperationException("included grammar without a start element !");
        }

        public List visitInterleave(InterleavePattern p) {
            ArrayList res = new ArrayList();
            for (Pattern c : p.getChildren()) {
                res.addAll((Collection)c.accept((PatternVisitor)this));
            }
            return res;
        }

        public List visitZeroOrMore(ZeroOrMorePattern p) {
            boolean savedRequired = this.required;
            this.required = false;
            List res = (List)p.getChild().accept((PatternVisitor)this);
            savedRequired = this.required;
            return res;
        }

        public List visitList(ListPattern p) {
            return Collections.emptyList();
        }

        public List visitMixed(MixedPattern p) {
            return Collections.emptyList();
        }

        public List visitNameClass(NameClass nc) {
            throw new UnsupportedOperationException("visitNameClass() shouldn't be called");
        }

        public List visitNotAllowed(NotAllowedPattern p) {
            return Collections.emptyList();
        }

        public List visitOneOrMore(OneOrMorePattern p) {
            return (List)p.getChild().accept((PatternVisitor)this);
        }

        public List visitOptional(OptionalPattern p) {
            boolean savedRequired = this.required;
            this.required = false;
            List res = (List)p.getChild().accept((PatternVisitor)this);
            this.required = savedRequired;
            return res;
        }

        public List visitParentRef(ParentRefPattern p) {
            if (!this.defines.parentContainsKey(p.getName())) {
                throw new IllegalArgumentException("Undefined reference :" + p.getName());
            }
            List<DefineComponent> parentRef = this.defines.getFromParent(p.getName());
            Map<String, List<DefineComponent>> myDefinitions = this.defines.pop();
            List res = this.handleRef(parentRef);
            this.defines.push(myDefinitions);
            return res;
        }

        private List handleRef(List<DefineComponent> refs) {
            ArrayList<ElementRefDecl> res = new ArrayList<ElementRefDecl>();
            for (DefineComponent dc : refs) {
                ElementRefDecl e = new ElementRefDecl(dc, this.required);
                res.add(e);
                if (!this.definesContents.containsKey(dc)) {
                    boolean savedRequired = this.required;
                    this.required = true;
                    this.definesContents.put(dc, null);
                    List r = (List)dc.getBody().accept((PatternVisitor)this);
                    this.definesContents.put(dc, r);
                    if (this.parent != null && !savedRequired) {
                        for (Object o : r) {
                            if (!(o instanceof ElementDecl.AttributeDecl)) continue;
                            ElementDecl.AttributeDecl newO = ((ElementDecl.AttributeDecl)o).copy();
                            newO.required = false;
                            this.parent.attributes.remove((ElementDecl.AttributeDecl)o);
                            this.parent.addAttribute(newO);
                        }
                    }
                    this.required = savedRequired;
                    continue;
                }
                if (this.parent == null) continue;
                if (this.parent.content == null) {
                    this.parent.content = new HashSet<String>();
                }
                if (this.parent.elementHash == null) {
                    this.parent.elementHash = new HashMap<String, ElementDecl>();
                }
                this.parent.elementHash.put(e.name, e);
                this.parent.content.add(e.name);
            }
            return res;
        }

        public List visitPattern(Pattern p) {
            if (p instanceof ZeroOrMorePattern) {
                return this.visitZeroOrMore((ZeroOrMorePattern)p);
            }
            throw new UnsupportedOperationException("visitPattern(" + p + ")");
        }

        public List visitRef(RefPattern p) {
            if (!this.defines.containsKey(p.getName())) {
                throw new IllegalArgumentException("Undefined reference :" + p.getName());
            }
            return this.handleRef(this.defines.get(p.getName()));
        }

        public List visitText(TextAnnotation ta) {
            throw new UnsupportedOperationException("visitText(Annotation)");
        }

        public List visitText(TextPattern p) {
            return Collections.emptyList();
        }

        public List visitValue(ValuePattern p) {
            return Collections.emptyList();
        }

        void resolveRefs() {
            for (CompletionInfo i : this.info.values()) {
                for (ElementDecl e : i.elements) {
                    this.resolveRefs(e);
                }
            }
            for (CompletionInfo i : this.info.values()) {
                for (ElementDecl e : i.elements) {
                    if (e.elementHash == null) continue;
                    for (ElementDecl d : e.elementHash.values()) {
                        if (!(d instanceof ElementRefDecl)) continue;
                        throw new IllegalStateException("still some undereferenced ElementRefDecl: " + d.name);
                    }
                }
            }
        }

        void addRootsToCompletionInfos(List roots) {
            for (Object o : roots) {
                if (!(o instanceof ElementRefDecl)) continue;
                ElementRefDecl e = (ElementRefDecl)o;
                List res = this.definesContents.get(e.ref);
                if (res == null) {
                    throw new IllegalArgumentException("can't find definitions for " + e.ref.getName() + "=" + e.ref);
                }
                for (Object r : res) {
                    if (!(r instanceof ElementDecl)) continue;
                    if (r instanceof ElementRefDecl) {
                        this.addRootsToCompletionInfos(Collections.singletonList(r));
                        continue;
                    }
                    ElementDecl oo = (ElementDecl)r;
                    if (oo.name == null) continue;
                    oo.completionInfo.elementHash.put(oo.name, oo);
                }
            }
        }

        private void resolveRefs(ElementDecl e) {
            if (e.elementHash != null) {
                List res = this.resolveRefs(new ArrayList<ElementDecl>(e.elementHash.values()), true);
                e.elementHash.clear();
                e.content.clear();
                for (Object o : res) {
                    Object oo;
                    if (o instanceof ElementDecl) {
                        oo = (ElementDecl)o;
                        if (((ElementDecl)oo).name == null) continue;
                        e.elementHash.put(((ElementDecl)oo).name, (ElementDecl)oo);
                        e.content.add(((ElementDecl)oo).name);
                        continue;
                    }
                    if (o instanceof ElementDecl.AttributeDecl) {
                        oo = (ElementDecl.AttributeDecl)o;
                        e.addAttribute((ElementDecl.AttributeDecl)oo);
                        continue;
                    }
                    throw new IllegalArgumentException("what's this : " + o);
                }
            }
        }

        private List resolveRefs(List res, boolean required) {
            ArrayList l = new ArrayList(res.size());
            for (Object o : res) {
                if (o instanceof ElementRefDecl) {
                    ElementRefDecl oref = (ElementRefDecl)o;
                    DefineComponent odc = oref.ref;
                    List ores = this.definesContents.get(odc);
                    if (ores == null) {
                        throw new IllegalArgumentException("can't find definitions for " + odc.getName() + "=" + odc);
                    }
                    l.addAll(this.resolveRefs(ores, required && oref.required));
                    continue;
                }
                if (o instanceof ElementDecl) {
                    l.add(o);
                    continue;
                }
                if (o instanceof ElementDecl.AttributeDecl) {
                    ElementDecl.AttributeDecl oo = (ElementDecl.AttributeDecl)o;
                    if (!required) {
                        oo = oo.copy();
                        oo.required = false;
                    }
                    l.add(oo);
                    continue;
                }
                throw new IllegalArgumentException("what's this : " + o);
            }
            return l;
        }

        private static class ElementRefDecl
        extends ElementDecl {
            DefineComponent ref;
            static int i = 0;
            boolean required;

            ElementRefDecl(DefineComponent ref, boolean required) {
                super(null, "_:" + ref.getName() + "_" + i++, null);
                this.ref = ref;
                this.required = required;
            }

            @Override
            public String toString() {
                return "ref to " + this.ref.getName() + "=" + this.ref.toString();
            }
        }
    }

    private static class MyNameClassVisitor
    implements NameClassVisitor<List<Name>> {
        private boolean any = false;
        private List<Name> names = new ArrayList<Name>();

        private MyNameClassVisitor() {
        }

        public List<Name> visitName(NameNameClass nc) {
            this.names.add(new Name(nc.getNamespaceUri(), nc.getLocalName()));
            return this.names;
        }

        public List<Name> visitNsName(NsNameNameClass nc) {
            this.names.add(new Name(nc.getNs(), SchemaToCompletion.ANY));
            Log.log((int)7, MyNameClassVisitor.class, (Object)("doesn't handle \"any element\" in namespace in RNG schema (namespace is " + nc.getNs() + ")"));
            if (nc.getExcept() != null) {
                Log.log((int)7, MyNameClassVisitor.class, (Object)"doesn't handle except clause in RNG schema");
            }
            return this.names;
        }

        public List<Name> visitAnyName(AnyNameNameClass nc) {
            this.any = true;
            return this.names;
        }

        public List<Name> visitChoice(ChoiceNameClass nc) {
            nc.childrenAccept((NameClassVisitor)this);
            return this.names;
        }
    }

    private static class MyAttributeVisitor
    extends AbstractPatternVisitor<List<ElementDecl.AttributeDecl>> {
        private Map<String, String> values;
        private List<String> data;
        private StackableMap<String, List<DefineComponent>> defined;
        private boolean required;

        MyAttributeVisitor(StackableMap<String, List<DefineComponent>> defined, boolean required) {
            this.defined = defined;
            this.required = required;
        }

        public List<ElementDecl.AttributeDecl> visitAttribute(AttributePattern p) {
            String value;
            String type;
            if (this.values != null) {
                throw new IllegalArgumentException("attribute//attribute isn't allowed");
            }
            this.values = new HashMap<String, String>();
            this.data = new ArrayList<String>();
            List names = (List)p.getNameClass().accept((NameClassVisitor)new MyNameClassVisitor());
            p.getChild().accept((PatternVisitor)this);
            ArrayList<ElementDecl.AttributeDecl> attrs = new ArrayList<ElementDecl.AttributeDecl>(names.size());
            if (this.values.isEmpty()) {
                type = this.data.isEmpty() ? "" : this.data.get(0);
                value = "";
            } else {
                value = this.values.keySet().iterator().next();
                type = this.values.get(value);
            }
            if (p.getAttributeAnnotation(SchemaToCompletion.RNG_DTD_COMPATIBILITY_NS, "defaultValue") != null) {
                value = p.getAttributeAnnotation(SchemaToCompletion.RNG_DTD_COMPATIBILITY_NS, "defaultValue");
            }
            this.required &= names.size() < 2;
            for (Name name : names) {
                attrs.add(new ElementDecl.AttributeDecl(name.getLocalName(), name.getNamespaceUri(), value, new ArrayList<String>(this.values.keySet()), type, this.required));
            }
            return attrs;
        }

        public List<ElementDecl.AttributeDecl> visitChoice(ChoicePattern p) {
            for (Pattern c : p.getChildren()) {
                c.accept((PatternVisitor)this);
            }
            return Collections.emptyList();
        }

        public List<ElementDecl.AttributeDecl> visitElement(ElementPattern p) {
            throw new IllegalArgumentException("attribute//element isn't allowed");
        }

        public List<ElementDecl.AttributeDecl> visitEmpty(EmptyPattern p) {
            return Collections.emptyList();
        }

        public List<ElementDecl.AttributeDecl> visitExternalRef(ExternalRefPattern p) {
            throw new IllegalArgumentException("attribute//externalRef isn't allowed");
        }

        public List<ElementDecl.AttributeDecl> visitGrammar(GrammarPattern p) {
            throw new IllegalArgumentException("attribute//grammar isn't allowed");
        }

        public List<ElementDecl.AttributeDecl> visitGroup(GroupPattern p) {
            for (Pattern c : p.getChildren()) {
                c.accept((PatternVisitor)this);
            }
            return Collections.emptyList();
        }

        public List<ElementDecl.AttributeDecl> visitInterleave(InterleavePattern p) {
            for (Pattern c : p.getChildren()) {
                c.accept((PatternVisitor)this);
            }
            return Collections.emptyList();
        }

        public List<ElementDecl.AttributeDecl> visitList(ListPattern p) {
            return (List)p.getChild().accept((PatternVisitor)this);
        }

        public List<ElementDecl.AttributeDecl> visitMixed(MixedPattern p) {
            throw new IllegalArgumentException("attribute//mixed doesn't make sense");
        }

        public List<ElementDecl.AttributeDecl> visitNotAllowed(NotAllowedPattern p) {
            return Collections.emptyList();
        }

        public List<ElementDecl.AttributeDecl> visitOneOrMore(OneOrMorePattern p) {
            throw new IllegalArgumentException("attribute//oneOrMore doesn't make sense to me");
        }

        public List<ElementDecl.AttributeDecl> visitOptional(OptionalPattern p) {
            throw new IllegalArgumentException("attribute//optional doesn't make sense to me");
        }

        public List<ElementDecl.AttributeDecl> visitParentRef(ParentRefPattern p) {
            throw new IllegalArgumentException("attribute//parentRef isn't allowed");
        }

        public List<ElementDecl.AttributeDecl> visitRef(RefPattern p) {
            if (this.defined.containsKey(p.getName())) {
                for (DefineComponent dc : this.defined.get(p.getName())) {
                    dc.getBody().accept((PatternVisitor)this);
                }
                return Collections.emptyList();
            }
            throw new IllegalArgumentException("unknown define : " + p.getName());
        }

        public List<ElementDecl.AttributeDecl> visitText(TextPattern p) {
            return Collections.emptyList();
        }

        public List<ElementDecl.AttributeDecl> visitValue(ValuePattern p) {
            this.values.put(p.getValue(), p.getType());
            return Collections.emptyList();
        }

        public List<ElementDecl.AttributeDecl> visitData(DataPattern p) {
            this.data.add(p.getType());
            return Collections.emptyList();
        }

        public List<ElementDecl.AttributeDecl> visitZeroOrMore(ZeroOrMorePattern p) {
            throw new IllegalArgumentException("attribute//zeroOrMore doesn't make sense to me");
        }

        public List<ElementDecl.AttributeDecl> visitPattern(Pattern p) {
            throw new IllegalArgumentException("which pattern did I forget ? " + p);
        }
    }

    private static class StackableMap<K, V> {
        private List<Map<K, V>> contents;

        StackableMap(int initialSize) {
            this.contents = new ArrayList<Map<K, V>>(initialSize);
        }

        public void push(Map<K, V> step) {
            this.contents.add(0, step);
        }

        public Map<K, V> pop() {
            return this.contents.remove(0);
        }

        public V get(K key) {
            if (this.contents.isEmpty()) {
                return null;
            }
            return this.contents.get(0).get(key);
        }

        public V getFromParent(K key) {
            if (this.contents.size() < 2) {
                return null;
            }
            return this.contents.get(1).get(key);
        }

        public boolean containsKey(K key) {
            if (this.contents.isEmpty()) {
                return false;
            }
            return this.contents.get(0).containsKey(key);
        }

        public boolean parentContainsKey(K key) {
            if (this.contents.size() < 2) {
                return false;
            }
            return this.contents.get(1).containsKey(key);
        }

        public String toString() {
            return "StackableMap{" + this.contents + "}";
        }
    }

    private static class GrabDefinesVisitor
    extends AbstractPatternVisitor<Map<String, List<DefineComponent>>>
    implements ComponentVisitor<Map<String, List<DefineComponent>>> {
        private Map<String, List<DefineComponent>> comps = new HashMap<String, List<DefineComponent>>();

        private GrabDefinesVisitor() {
        }

        public Map<String, List<DefineComponent>> visitGrammar(GrammarPattern p) {
            p.componentsAccept((ComponentVisitor)this);
            return this.comps;
        }

        public Map<String, List<DefineComponent>> visitDefine(DefineComponent c) {
            if (!this.comps.containsKey(c.getName())) {
                this.comps.put(c.getName(), new ArrayList());
            }
            this.comps.get(c.getName()).add(c);
            return this.comps;
        }

        public Map<String, List<DefineComponent>> visitDiv(DivComponent c) {
            c.componentsAccept((ComponentVisitor)this);
            return this.comps;
        }

        public Map<String, List<DefineComponent>> visitInclude(IncludeComponent c) {
            return this.comps;
        }

        public Map<String, List<DefineComponent>> visitPattern(Pattern p) {
            throw new UnsupportedOperationException("visitPattern(" + p + ")");
        }
    }
}

