/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.xml.validation.ValidatorHandler;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import xml.PathUtilities;
import xml.Resolver;
import xml.parser.SchemaLoader;

public final class SchemaMapping {
    private static final String LOCATING_RULES_NS = "http://thaiopensource.com/ns/locating-rules/1.0";
    public static final String SCHEMAS_FILE = "schemas.xml";
    private final List<TypeIdMapping> typeIds = new ArrayList<TypeIdMapping>();
    private final List<Mapping> rules = new ArrayList<Mapping>();
    private URI baseURI;

    public SchemaMapping() {
        this(null);
    }

    public SchemaMapping(URI baseURI) {
        this.baseURI = baseURI;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void insertRuleAt(int pos, Mapping m) {
        m.parent = this;
        if (m.getBaseURI() == null) {
            m.setBaseURI(this.getBaseURI());
        }
        this.rules.add(pos, m);
    }

    public void removeRule(Mapping m) {
        if (this.rules.contains(m)) {
            this.rules.remove(m);
            m.parent = null;
        }
    }

    public void removeRuleAt(int pos) {
        if (pos >= 0 && pos < this.rules.size()) {
            this.rules.get((int)pos).parent = null;
            this.rules.remove(pos);
        }
    }

    public void updateMapping(URIResourceRule newRule) {
        if (newRule == null) {
            throw new IllegalArgumentException("newRule==null");
        }
        newRule.parent = this;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!(this.rules.get(i) instanceof URIResourceRule) || !((URIResourceRule)this.rules.get(i)).resource.equals(newRule.resource)) continue;
            this.rules.set(i, newRule);
            return;
        }
        this.rules.add(0, newRule);
    }

    public boolean ensureIncluded(SchemaMapping mapping) {
        for (Mapping m : this.rules) {
            if (!(m instanceof IncludeMapping)) continue;
            SchemaMapping candidate = ((IncludeMapping)m).mapping;
            if (m.getBaseURI().equals(candidate.getBaseURI())) {
                return true;
            }
            if (!candidate.ensureIncluded(mapping)) continue;
            return true;
        }
        this.addRule(new IncludeMapping(null, mapping));
        return false;
    }

    public String getTypeIdForDocument(String resourceURL) {
        Result r = this.getSchemaForDocument(null, resourceURL, null, null, null, false);
        if (r == null) {
            return null;
        }
        return r.target;
    }

    public Result resolveTypeId(String tid) {
        for (TypeIdMapping typeIdMapping : this.typeIds) {
            if (!typeIdMapping.tid.equals(tid)) continue;
            if (typeIdMapping.targetIsTypeId) {
                return this.resolveTypeId(typeIdMapping.target);
            }
            Result r = new Result(typeIdMapping.getBaseURI(), typeIdMapping.target);
            return r;
        }
        for (Mapping mapping : this.rules) {
            Result r;
            if (!(mapping instanceof IncludeMapping) || (r = ((IncludeMapping)mapping).mapping.resolveTypeId(tid)) == null) continue;
            return r;
        }
        Log.log((int)7, SchemaMapping.class, (Object)("couldn't find typeId '" + tid + "'"));
        return null;
    }

    public void addRule(Mapping r) {
        this.insertRuleAt(this.rules.size(), r);
    }

    public void addTypeId(String tid, String target, boolean targetIsTypeId) {
        TypeIdMapping tidm = new TypeIdMapping(this.getBaseURI(), tid, target, targetIsTypeId);
        this.typeIds.add(tidm);
    }

    public List<TypeIdMapping> getTypeIds() {
        return Collections.unmodifiableList(this.typeIds);
    }

    public List<Mapping> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public Result getSchemaForDocument(String publicId, String systemId, String namespace, String prefix, String localName, boolean followTypeId) {
        Mapping r;
        Result res = null;
        Iterator<Mapping> i$ = this.rules.iterator();
        while (i$.hasNext() && (res = (r = i$.next()).getSchemaForDocument(publicId, systemId, namespace, prefix, localName, followTypeId)) == null) {
        }
        if (res != null) {
            // empty if block
        }
        return res;
    }

    public Mapping getMappingForDocument(String publicId, String systemId, String namespace, String prefix, String localName) {
        Mapping r;
        Mapping res = null;
        Iterator<Mapping> i$ = this.rules.iterator();
        while (i$.hasNext() && (res = (r = i$.next()).getMappingForDocument(publicId, systemId, namespace, prefix, localName)) == null) {
        }
        return res;
    }

    public static SchemaMapping fromDocument(String url, ErrorHandler errorHandler) throws IOException, SAXException, IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException("url can't be null");
        }
        SchemaMapping mapping = new SchemaMapping();
        try {
            mapping.baseURI = new URI(url);
        }
        catch (URISyntaxException mfue) {
            throw new IllegalArgumentException("malformed URL: " + url, mfue);
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setEntityResolver(Resolver.instance());
            MyHandler handler = new MyHandler(mapping, errorHandler);
            ValidatorHandler verifierFilter = SchemaLoader.instance().loadJaxpGrammar(null, "jeditresource:XML.jar!/xml/dtds/locate.rng", handler, null);
            reader.setContentHandler(verifierFilter);
            verifierFilter.setContentHandler(handler);
            reader.setErrorHandler(handler);
            verifierFilter.setErrorHandler(handler);
            InputSource input = Resolver.instance().resolveEntity(null, url);
            reader.parse(input);
        }
        catch (SAXException se) {
            return null;
        }
        catch (IOException e) {
            Log.log((int)9, SchemaMapping.class, (Object)("I/O error loading schema mapping '" + url + "': " + e.getClass() + ": " + e.getMessage()));
            return null;
        }
        return mapping;
    }

    public void toDocument(final String output) throws IOException {
        URI resource;
        if (output == null) {
            throw new IllegalArgumentException("url can't be null");
        }
        try {
            resource = new URI(output);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException("malformed URL: " + output, ue);
        }
        String scheme = resource.getScheme();
        if (scheme == null) {
            scheme = "file";
        }
        final VFS vfs = VFSManager.getVFSForProtocol((String)scheme);
        final Object[] sessionArray = new Object[1];
        final View view = jEdit.getActiveView();
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                sessionArray[0] = vfs.createVFSSession(output, (Component)view);
                Object session = sessionArray[0];
                if (session != null) {
                    try {
                        OutputStream vfsos = vfs._createOutputStream(session, PathUtilities.urlToPath(resource.toString()), (Component)view);
                        OutputStreamWriter out = new OutputStreamWriter(vfsos, "UTF-8");
                        out.write("<?xml version=\"1.0\" ?>\n");
                        out.write("<locatingRules xmlns=\"http://thaiopensource.com/ns/locating-rules/1.0\">\n");
                        for (Mapping r : SchemaMapping.this.rules) {
                            out.write(r.toString());
                        }
                        for (TypeIdMapping tid : SchemaMapping.this.typeIds) {
                            out.write(tid.toString());
                        }
                        out.write("</locatingRules>");
                        ((Writer)out).close();
                    }
                    catch (IOException ioe) {
                        Log.log((int)9, SchemaMapping.class, (Object)("unable to write document: " + ioe.getMessage()));
                    }
                    finally {
                        try {
                            vfs._endVFSSession(session, (Component)view);
                        }
                        catch (IOException ioe) {
                            Log.log((int)9, SchemaMapping.class, (Object)("ending VFS session in toDocument(" + output + ")"), (Throwable)ioe);
                        }
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public static boolean resourceExists(URI resource) {
        VFSFile f = null;
        String scheme = resource.getScheme();
        if (scheme == null) {
            scheme = "file";
        }
        VFS vfs = VFSManager.getVFSForProtocol((String)scheme);
        Object[] sessionArray = new Object[1];
        View view = jEdit.getActiveView();
        sessionArray[0] = vfs.createVFSSession(resource.toString(), (Component)view);
        Object session = sessionArray[0];
        if (session != null) {
            try {
                f = vfs._getFile(session, PathUtilities.urlToPath(resource.toString()), (Component)view);
            }
            catch (IOException ioe) {
                Log.log((int)9, SchemaMapping.class, (Object)("error in resourceExists(" + resource + ")"), (Throwable)ioe);
            }
            try {
                vfs._endVFSSession(session, (Component)view);
            }
            catch (IOException ioe) {
                Log.log((int)9, SchemaMapping.class, (Object)("ending VFS session in resourceExists(" + resource + ")"), (Throwable)ioe);
            }
        }
        return f != null;
    }

    public static final class TypeIdMapping {
        final String tid;
        final String target;
        final boolean targetIsTypeId;
        final URI baseURI;

        TypeIdMapping(URI baseURI, String tid, String target, boolean targetIsTypeId) {
            this.baseURI = baseURI;
            this.tid = tid;
            this.target = target;
            this.targetIsTypeId = targetIsTypeId;
        }

        public URI getBaseURI() {
            return this.baseURI;
        }

        public String getId() {
            return this.tid;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<typeId id=\"").append(this.tid).append("\" ");
            if (this.targetIsTypeId) {
                sb.append("typeId");
            } else {
                sb.append("uri");
            }
            sb.append("=\"").append(this.target).append("\"/>\n");
            return sb.toString();
        }
    }

    public static final class Result {
        public final URI baseURI;
        public final String target;

        public Result(URI baseURI, String target) {
            this.baseURI = baseURI;
            this.target = target;
        }

        public String toString() {
            return "(base=" + this.baseURI + ") " + this.target;
        }

        public int hashCode() {
            return 1253 + (this.baseURI == null ? 0 : this.baseURI.hashCode()) + (this.target == null ? 0 : this.target.hashCode());
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof Result) {
                Result o = (Result)other;
                return (this.baseURI == null && o.baseURI == null || this.baseURI.equals(o.baseURI)) && (this.target == null && o.target == null || this.target.equals(o.target));
            }
            return false;
        }
    }

    public static class IncludeMapping
    extends Mapping {
        private final String rules;
        private final SchemaMapping mapping;

        public IncludeMapping(URI baseURI, String rules, ErrorHandler errorHandler) throws SAXException, IllegalArgumentException {
            super(baseURI);
            if (rules == null) {
                throw new IllegalArgumentException("rules can't be null");
            }
            try {
                URI url;
                URI u = new URI(rules);
                if (u.isAbsolute()) {
                    url = u;
                } else {
                    if (baseURI == null) {
                        throw new IllegalArgumentException("relative rules '" + rules + "' with null baseURI");
                    }
                    url = baseURI.resolve(rules);
                }
                this.mapping = SchemaMapping.fromDocument(url.toURL().toExternalForm(), errorHandler);
            }
            catch (MalformedURLException mfue) {
                throw new IllegalArgumentException("rules '" + rules + "' must be an URL", mfue);
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException("rules '" + rules + "' must be an URL", use);
            }
            catch (IOException ioe) {
                throw new SAXException("error loading " + rules + "for inclusion from " + baseURI, ioe);
            }
            this.rules = rules;
        }

        public IncludeMapping(URI baseURI, SchemaMapping mapping) {
            super(baseURI);
            if (mapping == null) {
                throw new IllegalArgumentException("mapping can't be null");
            }
            this.mapping = mapping;
            this.rules = mapping.getBaseURI().toString();
        }

        @Override
        public Result getSchemaForDocument(String publicId, String systemId, String namespace, String prefix, String localName, boolean followTypeId) {
            return this.mapping.getSchemaForDocument(publicId, systemId, namespace, prefix, localName, followTypeId);
        }

        @Override
        public Mapping getMappingForDocument(String publicId, String systemId, String namespace, String prefix, String localName) {
            return this.mapping.getMappingForDocument(publicId, systemId, namespace, prefix, localName);
        }

        public String toString() {
            return "<include rules=\"" + this.rules + "\" " + (this.base == null ? "" : "xml:base=\"" + this.base + "\"") + "/>";
        }
    }

    public static abstract class Mapping {
        protected SchemaMapping parent;
        protected URI baseURI;
        protected String base;

        Mapping(URI baseURI) {
            this.baseURI = baseURI;
            this.parent = null;
        }

        public SchemaMapping getParent() {
            return this.parent;
        }

        public URI getBaseURI() {
            return this.baseURI;
        }

        void setBaseURI(URI baseURI) {
            this.baseURI = baseURI;
        }

        void setExplicitBase(String base) {
            this.base = base;
        }

        public abstract Result getSchemaForDocument(String var1, String var2, String var3, String var4, String var5, boolean var6);

        public abstract Mapping getMappingForDocument(String var1, String var2, String var3, String var4, String var5);
    }

    private static class MyHandler
    extends DefaultHandler {
        private SchemaMapping mapping;
        private Stack<URI> baseURIs;
        private ErrorHandler errorHandler;

        MyHandler(SchemaMapping mapping, ErrorHandler errorHandler) {
            this.mapping = mapping;
            this.errorHandler = errorHandler;
            this.baseURIs = new Stack();
            this.baseURIs.push(mapping.baseURI);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!SchemaMapping.LOCATING_RULES_NS.equals(uri)) {
                return;
            }
            String base = null;
            if (attributes.getIndex("xml:base") != -1) {
                base = attributes.getValue("xml:base");
                try {
                    URI buri = new URI(base);
                    URI burl = buri.isAbsolute() ? buri : this.baseURIs.peek().resolve(buri);
                    this.baseURIs.push(burl);
                }
                catch (URISyntaxException use) {
                    throw new SAXException("invalid xml:base " + base, use);
                }
            } else {
                this.baseURIs.push(this.baseURIs.peek());
            }
            String target = null;
            boolean targetIsTypeId = false;
            if (attributes.getIndex("", "typeId") != -1) {
                target = attributes.getValue("", "typeId");
                targetIsTypeId = true;
            } else if (attributes.getIndex("", "uri") != -1) {
                target = attributes.getValue("", "uri");
                targetIsTypeId = false;
            }
            Mapping newRule = null;
            if ("transformURI".equals(localName)) {
                if (attributes.getIndex("", "fromPattern") != -1 && attributes.getIndex("", "toPattern") != -1) {
                    String from = attributes.getValue("", "fromPattern");
                    String to = attributes.getValue("", "toPattern");
                    newRule = new TransformURI(this.baseURIs.peek(), from, to);
                }
            } else if ("uri".equals(localName)) {
                if (attributes.getIndex("", "pattern") != -1) {
                    newRule = new URIPatternRule(this.baseURIs.peek(), attributes.getValue("", "pattern"), target, targetIsTypeId);
                } else if (attributes.getIndex("", "resource") != -1) {
                    newRule = new URIResourceRule(this.baseURIs.peek(), attributes.getValue("", "resource"), target, targetIsTypeId);
                }
            } else if ("namespace".equals(localName)) {
                if (attributes.getIndex("", "ns") != -1) {
                    newRule = new NamespaceRule(this.baseURIs.peek(), attributes.getValue("", "ns"), target, targetIsTypeId);
                }
            } else if ("documentElement".equals(localName)) {
                String prefix = attributes.getValue("", "prefix");
                String name = attributes.getValue("", "localName");
                newRule = new DocumentElementRule(this.baseURIs.peek(), prefix, name, target, targetIsTypeId);
            } else if ("doctypePublicId".equals(localName)) {
                newRule = new DoctypeRule(this.baseURIs.peek(), attributes.getValue("", "publicId"), target, targetIsTypeId);
            } else if ("include".equals(localName)) {
                if (attributes.getIndex("", "rules") != -1) {
                    newRule = new IncludeMapping(this.baseURIs.peek(), attributes.getValue("", "rules"), this.errorHandler);
                }
            } else if ("default".equals(localName)) {
                newRule = new DefaultRule(this.baseURIs.peek(), target, targetIsTypeId);
            } else if ("typeId".equals(localName) && attributes.getIndex("", "id") != -1) {
                String id = attributes.getValue("", "id");
                TypeIdMapping tid = new TypeIdMapping(this.baseURIs.peek(), id, target, targetIsTypeId);
                this.mapping.typeIds.add(tid);
            }
            if (newRule != null) {
                if (base != null) {
                    newRule.setExplicitBase(base);
                }
                newRule.parent = this.mapping;
                this.mapping.rules.add(newRule);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.baseURIs.pop();
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.errorHandler.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.errorHandler.fatalError(e);
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.errorHandler.warning(e);
        }
    }

    static abstract class Rule
    extends Mapping {
        protected final String target;
        protected final boolean targetIsTypeId;

        Rule(URI baseURI, String target, boolean targetIsTypeId) {
            super(baseURI);
            if (target == null) {
                throw new IllegalArgumentException("target can't be null");
            }
            if ("".equals(target)) {
                throw new IllegalArgumentException("target can't be \"\"");
            }
            this.target = target;
            this.targetIsTypeId = targetIsTypeId;
        }

        boolean matchNamespace(String namespace) {
            return false;
        }

        boolean matchDocumentElement(String prefix, String localName) {
            return false;
        }

        boolean matchURL(String url) {
            return false;
        }

        boolean matchDoctype(String dt) {
            return false;
        }

        @Override
        public final Result getSchemaForDocument(String publicId, String systemId, String namespace, String prefix, String localName, boolean followTypeId) {
            if (this.matchURL(systemId) || this.matchNamespace(namespace) || this.matchDocumentElement(prefix, localName)) {
                if (this.targetIsTypeId && followTypeId) {
                    return this.parent.resolveTypeId(this.target);
                }
                return new Result(this.getBaseURI(), this.target);
            }
            return null;
        }

        @Override
        public final Mapping getMappingForDocument(String publicId, String systemId, String namespace, String prefix, String localName) {
            if (this.matchURL(systemId) || this.matchNamespace(namespace) || this.matchDocumentElement(prefix, localName)) {
                return this;
            }
            return null;
        }
    }

    public static class DoctypeRule
    extends Rule {
        private String doctype;

        public DoctypeRule(URI baseURI, String doctype, String target, boolean targetIsTypeId) {
            super(baseURI, target, targetIsTypeId);
            if (doctype == null) {
                throw new IllegalArgumentException("doctype can't be null");
            }
            if (doctype.length() == 0) {
                throw new IllegalArgumentException("doctype can't be \"\"");
            }
            this.doctype = doctype;
        }

        @Override
        boolean matchDoctype(String dt) {
            return this.doctype.equals(dt);
        }

        public String toString() {
            return "<doctypePublicId publicId=\"" + this.doctype + "\" " + (this.base == null ? "" : "xml:base=\"" + this.base + "\" ") + (this.targetIsTypeId ? "typeId" : "uri") + "=\"" + this.target + "\"/>";
        }
    }

    public static class DefaultRule
    extends Rule {
        public DefaultRule(URI baseURI, String target, boolean targetIsTypeId) {
            super(baseURI, target, targetIsTypeId);
        }

        @Override
        boolean matchNamespace(String namespace) {
            return true;
        }

        @Override
        boolean matchDocumentElement(String prefix, String localName) {
            return true;
        }

        @Override
        boolean matchURL(String url) {
            return true;
        }

        @Override
        boolean matchDoctype(String dt) {
            return true;
        }

        public String toString() {
            return "<default " + (this.base == null ? "" : "xml:base=\"" + this.base + "\" ") + (this.targetIsTypeId ? "typeId" : "uri") + "=\"" + this.target + "\"/>";
        }
    }

    public static class URIResourceRule
    extends Rule {
        private final String resource;
        private final URI resURL;

        public URIResourceRule(URI base, String resource, String target, boolean targetIsTypeId) {
            super(base, target, targetIsTypeId);
            if (resource == null) {
                throw new IllegalArgumentException("resource can't be null");
            }
            try {
                URI u = new URI(resource).normalize();
                if (u.isAbsolute()) {
                    this.resURL = u;
                } else {
                    if (base == null) {
                        throw new IllegalArgumentException("base can't be null when resource is relative :" + resource);
                    }
                    this.resURL = base.resolve(resource);
                }
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException("resource '" + resource + "' must be a valid url", use);
            }
            this.resource = resource;
        }

        @Override
        boolean matchURL(String url) {
            if (this.resURL != null) {
                try {
                    URI matchedURI = new URI(url).normalize();
                    URI matchedURL = matchedURI.isAbsolute() ? matchedURI : this.resURL.resolve(matchedURI);
                    return this.resURL.equals(matchedURL);
                }
                catch (URISyntaxException use) {
                    Log.log((int)7, SchemaMapping.class, (Object)("error looking for matching schema for " + url + ", invalid URL: " + use.getMessage()));
                }
            }
            return this.resource.equals(url);
        }

        public String toString() {
            return "<uri resource=\"" + this.resource + "\" " + (this.base == null ? "" : "xml:base=\"" + this.base + "\" ") + (this.targetIsTypeId ? "typeId" : "uri") + "=\"" + this.target + "\"/>";
        }
    }

    public static class TransformURI
    extends Mapping {
        private String fromPattern;
        private Pattern compPattern;
        private String toPattern;
        private String[] splitToPattern;
        private int starCount;

        public TransformURI(URI baseURI, String fromPattern, String toPattern) {
            super(baseURI);
            if (fromPattern == null) {
                throw new IllegalArgumentException("fromPattern can't be null");
            }
            if (toPattern == null) {
                throw new IllegalArgumentException("toPattern can't be null");
            }
            this.fromPattern = fromPattern;
            this.toPattern = toPattern;
            int i = fromPattern.indexOf(42, 0);
            while (i != -1) {
                ++this.starCount;
                i = fromPattern.indexOf(42, i + 1);
            }
            this.compPattern = Pattern.compile("(^.*?)" + fromPattern.replace(".", "\\.").replace("*", "([^/]*)"));
            this.splitToPattern = toPattern.split("\\*", -1);
            if (this.splitToPattern.length > this.starCount + 1) {
                throw new IllegalArgumentException("there may not be more stars in toPattern (='" + toPattern + ") than in fromPattern (=" + fromPattern + ") " + (this.splitToPattern.length - 1) + ">" + this.starCount);
            }
        }

        @Override
        public Result getSchemaForDocument(String ignoredPublicId, String url, String ignoredNamespace, String ignoredPrefix, String ignoredLocalName, boolean ignored) {
            try {
                Matcher m = this.compPattern.matcher(url);
                if (m.matches()) {
                    String result = m.group(1);
                    StringBuilder resultSb = new StringBuilder(result);
                    if (this.splitToPattern.length > 0) {
                        resultSb.append(this.splitToPattern[0]);
                        for (int i = 0; i < this.starCount; ++i) {
                            resultSb.append(m.group(i + 2));
                            if (i + 1 >= this.splitToPattern.length) continue;
                            resultSb.append(this.splitToPattern[i + 1]);
                        }
                    }
                    result = resultSb.toString();
                    URI resultURI = this.getBaseURI() == null ? new URI(result) : this.getBaseURI().resolve(result);
                    if (SchemaMapping.resourceExists(resultURI)) {
                        return new Result(this.getBaseURI(), result);
                    }
                }
            }
            catch (URISyntaxException use) {
                Log.log((int)9, SchemaMapping.class, (Object)("Malformed:" + url));
            }
            return null;
        }

        @Override
        public Mapping getMappingForDocument(String ignoredPublicId, String url, String ignoredNamespace, String ignoredPrefix, String ignoredLocalName) {
            if (this.getSchemaForDocument(ignoredPublicId, url, ignoredNamespace, ignoredPrefix, ignoredLocalName, false) == null) {
                return null;
            }
            return this;
        }

        public String toString() {
            return "<transformURI " + (this.base == null ? "" : "xml:base=\"" + this.base + "\" ") + "fromPattern=\"" + this.fromPattern + "\" toPattern=\"" + this.toPattern + "\"/>";
        }
    }

    public static class URIPatternRule
    extends Rule {
        private String pattern;
        private Pattern compPattern;

        public URIPatternRule(URI baseURI, String pattern, String target, boolean targetIsTypeId) {
            super(baseURI, target, targetIsTypeId);
            if (pattern == null) {
                throw new IllegalArgumentException("pattern can't be null");
            }
            this.pattern = pattern;
            this.compPattern = Pattern.compile("^.*?" + pattern.replace(".", "\\.").replace("*", "[^/]*"));
        }

        @Override
        boolean matchURL(String url) {
            try {
                URI u = new URI(url).normalize();
                if (u.isOpaque()) {
                    return this.compPattern.matcher(url).matches();
                }
                return this.compPattern.matcher(url).matches();
            }
            catch (URISyntaxException use) {
                Log.log((int)7, SchemaMapping.class, (Object)("error looking for matching schema for " + url + ", invalid url: " + use.getMessage()));
                return this.compPattern.matcher(url).matches();
            }
        }

        public String toString() {
            return "<uri pattern=\"" + this.pattern + "\" " + (this.base == null ? "" : "xml:base=\"" + this.base + "\" ") + (this.targetIsTypeId ? "typeId" : "uri") + "=\"" + this.target + "\"/>";
        }
    }

    public static class NamespaceRule
    extends Rule {
        private String namespace;

        public NamespaceRule(URI baseURI, String ns, String target, boolean targetIsTypeId) {
            super(baseURI, target, targetIsTypeId);
            if (ns == null) {
                throw new IllegalArgumentException("namespace can't be null");
            }
            this.namespace = ns;
        }

        @Override
        boolean matchNamespace(String namespace) {
            return this.namespace.equals(namespace);
        }

        public String toString() {
            return "<namespace ns=\"" + this.namespace + "\" " + (this.base == null ? "" : "xml:base=\"" + this.base + "\" ") + (this.targetIsTypeId ? "typeId" : "uri") + "=\"" + this.target + "\"/>";
        }
    }

    public static class DocumentElementRule
    extends Rule {
        private String prefix;
        private String localName;

        public DocumentElementRule(URI baseURI, String prefix, String localName, String target, boolean targetIsTypeId) {
            super(baseURI, target, targetIsTypeId);
            if ((prefix == null || "".equals(prefix)) && (localName == null || "".equals(localName))) {
                throw new IllegalArgumentException("prefix and localName can't both be null");
            }
            if ("".equals(localName)) {
                localName = null;
            }
            this.prefix = prefix;
            this.localName = localName;
        }

        @Override
        boolean matchDocumentElement(String prefix, String localName) {
            return !(this.prefix != null && !this.prefix.equals(prefix) || this.localName != null && !this.localName.equals(localName));
        }

        public String toString() {
            return "<documentElement " + (this.prefix != null ? "prefix=\"" + this.prefix + "\" " : "") + (this.localName != null ? "localName=\"" + this.localName + "\" " : "") + (this.base == null ? "" : "xml:base=\"" + this.base + "\" ") + (this.targetIsTypeId ? "typeId" : "uri") + "=\"" + this.target + "\"/>";
        }
    }
}

