/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import com.thaiopensource.relaxng.jaxp.CompactSyntaxSchemaFactory;
import com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory;
import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.apache.xerces.jaxp.validation.XMLSchemaFactory;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.EntityResolver2Wrapper;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.SAXInputSource;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.gjt.sp.jedit.Buffer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import xml.Resolver;
import xml.cache.Cache;
import xml.cache.CacheEntry;
import xml.parser.CachedGrammarPool;

public final class SchemaLoader {
    private final SchemaFactory xsdFactory = new XMLSchemaFactory();
    private final SchemaFactory rngFactory = new XMLSyntaxSchemaFactory();
    private final SchemaFactory rncFactory = new CompactSyntaxSchemaFactory();
    private static SchemaLoader instance;
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";

    private SchemaLoader() {
    }

    public ValidatorHandler loadJaxpGrammar(String current, String schemaFileNameOrURL, ErrorHandler handler, Buffer requestingBuffer) throws SAXException, IOException, IllegalArgumentException {
        Schema schema;
        if (schemaFileNameOrURL == null) {
            throw new IllegalArgumentException("schemaFileNameOrURL may not be null");
        }
        String realLocation = Resolver.instance().resolveEntityToPath(null, null, current, schemaFileNameOrURL);
        CacheEntry en = Cache.instance().get(realLocation, "Schema");
        if (en == null) {
            SchemaFactory factory;
            if (schemaFileNameOrURL.endsWith(".xsd")) {
                factory = this.xsdFactory;
            } else if (schemaFileNameOrURL.endsWith(".rnc")) {
                factory = this.rncFactory;
            } else if (schemaFileNameOrURL.endsWith(".rng") || schemaFileNameOrURL.endsWith(".xml")) {
                factory = this.rngFactory;
            } else {
                throw new IOException("can't guess schema type based on extension : " + schemaFileNameOrURL);
            }
            factory.setResourceResolver(Resolver.instance());
            factory.setErrorHandler(handler);
            InputSource is = Resolver.instance().resolveEntity(null, null, current, schemaFileNameOrURL);
            SAXSource s = new SAXSource(is);
            schema = factory.newSchema(s);
            en = Cache.instance().put(realLocation, "Schema", schema);
            if (en != null) {
                en.getRequestingBuffers().add(requestingBuffer);
            }
        } else {
            schema = (Schema)en.getCachedItem();
            en.getRequestingBuffers().add(requestingBuffer);
        }
        ValidatorHandler verifier = schema.newValidatorHandler();
        return verifier;
    }

    public Grammar loadXercesGrammar(Buffer current, String systemId, String schemaLocation, String nonsSchemaLocation, ErrorHandler handler) throws IOException, SAXException {
        SymbolTable sym = new SymbolTable(2031);
        XMLGrammarPreparser preparser = new XMLGrammarPreparser(sym);
        CachedGrammarPool grammarPool = new CachedGrammarPool(current);
        preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        preparser.setProperty(SCHEMA_LOCATION, (Object)schemaLocation);
        preparser.setProperty(SCHEMA_NONS_LOCATION, (Object)nonsSchemaLocation);
        preparser.setGrammarPool((XMLGrammarPool)grammarPool);
        preparser.setFeature(NAMESPACES_FEATURE_ID, true);
        preparser.setEntityResolver((XMLEntityResolver)new EntityResolver2Wrapper((EntityResolver2)Resolver.instance()));
        preparser.setErrorHandler((XMLErrorHandler)new ErrorHandlerWrapper(handler));
        InputSource in = Resolver.instance().resolveEntity(null, null, current.getPath(), systemId);
        Grammar g = preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", (XMLInputSource)new SAXInputSource(in));
        return g;
    }

    public static SchemaLoader instance() {
        if (instance == null) {
            instance = new SchemaLoader();
        }
        return instance;
    }
}

