/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Map;
import javax.xml.validation.ValidatorHandler;
import org.gjt.sp.jedit.Buffer;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;
import xml.PathUtilities;
import xml.Resolver;
import xml.completion.CompletionInfo;
import xml.parser.SchemaLoader;
import xml.parser.SchemaMapping;
import xml.parser.SchemaToCompletion;
import xml.parser.XSDSchemaToCompletion;

public class SchemaAutoLoader
extends XMLFilterImpl
implements EntityResolver2 {
    private boolean documentElement;
    private SchemaMapping mapping;
    private Buffer requestingBuffer;
    private String publicId;
    private String systemId;
    private Locator locator;
    private NamespaceSupport docElementNamespaces = new NamespaceSupport();
    private String schemaURL;
    private Map<String, CompletionInfo> completions;

    public SchemaAutoLoader(XMLReader parent, SchemaMapping mapping, Buffer requestingBuffer) {
        super(parent);
        this.mapping = mapping;
        this.requestingBuffer = requestingBuffer;
    }

    public void forceSchema(String baseURI, String schemaURI) throws SAXException, IOException, URISyntaxException {
        this.mapping = null;
        this.installJaxpGrammar(new URI(baseURI), schemaURI, false);
    }

    public String getSchemaURL() {
        return this.schemaURL;
    }

    public Map<String, CompletionInfo> getCompletionInfo() {
        return this.completions;
    }

    private void installJaxpGrammar(URI baseURI, String schemaURL, boolean needReplay) throws SAXException, IOException {
        String[] sids;
        ValidatorHandler verifierFilter = SchemaLoader.instance().loadJaxpGrammar(baseURI.toString(), schemaURL, this.getErrorHandler(), this.requestingBuffer);
        this.schemaURL = baseURI == null ? schemaURL : ((sids = Resolver.instance().resolveEntityToPathInternal(null, null, baseURI.toString(), schemaURL)) == null ? baseURI.resolve(schemaURL).toString() : sids[0]);
        if (needReplay) {
            verifierFilter.setContentHandler(new DefaultHandler());
            if (this.locator == null) {
                throw new IllegalStateException("LOCATOR");
            }
            verifierFilter.setDocumentLocator(this.locator);
            verifierFilter.startDocument();
        }
        verifierFilter.setContentHandler(this.getContentHandler());
        verifierFilter.setErrorHandler(this.getErrorHandler());
        verifierFilter.setResourceResolver(Resolver.instance());
        this.setContentHandler(verifierFilter);
        if (schemaURL.endsWith("rng") || schemaURL.endsWith("rnc")) {
            Map<String, CompletionInfo> info = SchemaToCompletion.rngSchemaToCompletionInfo(baseURI.toString(), this.schemaURL, this.getErrorHandler(), this.requestingBuffer);
            this.completions = info;
        } else if (schemaURL.endsWith("xsd")) {
            Map<String, CompletionInfo> infos = XSDSchemaToCompletion.getCompletionInfoFromSchema(this.schemaURL, null, null, this.getErrorHandler(), this.requestingBuffer);
            this.completions = infos;
        }
    }

    @Override
    public void parse(InputSource input) throws SAXException, IOException {
        this.documentElement = true;
        this.publicId = input.getPublicId();
        this.systemId = input.getSystemId();
        this.docElementNamespaces.pushContext();
        super.parse(input);
    }

    @Override
    public void parse(String systemId) throws SAXException, IOException {
        this.documentElement = true;
        this.publicId = null;
        this.docElementNamespaces.pushContext();
        super.parse(systemId);
    }

    @Override
    public void startPrefixMapping(String prefix, String ns) throws SAXException {
        if (this.documentElement && this.mapping != null) {
            this.docElementNamespaces.declarePrefix(prefix, ns);
        } else {
            super.startPrefixMapping(prefix, ns);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.documentElement && this.mapping != null) {
            String prefix = "".equals(localName) ? "" : (qName.equals(localName) ? "" : qName.substring(0, qName.indexOf(":")));
            String politeSystemId = PathUtilities.pathToURL(this.systemId);
            SchemaMapping.Result schema = this.mapping.getSchemaForDocument(this.publicId, politeSystemId, uri, prefix, localName, true);
            if (schema != null) {
                try {
                    this.installJaxpGrammar(schema.baseURI, schema.target, true);
                }
                catch (IOException ioe) {
                    throw new SAXException("unable to install schema " + schema, ioe);
                }
            }
            Enumeration<String> e = this.docElementNamespaces.getDeclaredPrefixes();
            while (e.hasMoreElements()) {
                String pre = e.nextElement();
                super.startPrefixMapping(pre, this.docElementNamespaces.getURI(pre));
            }
            this.docElementNamespaces.reset();
            this.documentElement = false;
        }
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        EntityResolver r = this.getEntityResolver();
        if (r instanceof EntityResolver2) {
            return ((EntityResolver2)r).resolveEntity(name, publicId, baseURI, systemId);
        }
        throw new UnsupportedOperationException("SchemaAutoLoader needs EntityResolver2");
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        EntityResolver r = this.getEntityResolver();
        if (r instanceof EntityResolver2) {
            return ((EntityResolver2)r).getExternalSubset(name, baseURI);
        }
        throw new UnsupportedOperationException("SchemaAutoLoader needs EntityResolver2");
    }

    @Override
    public void setDocumentLocator(Locator l) {
        this.locator = l;
        super.setDocumentLocator(l);
    }
}

