/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import java.io.IOException;
import java.io.StringReader;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import xml.PathUtilities;
import xml.Resolver;
import xml.parser.ErrorListErrorHandler;

class MyEntityResolver
implements EntityResolver2 {
    Buffer buffer;
    ErrorListErrorHandler errorHandler;
    Locator loc;

    MyEntityResolver(Buffer buffer, ErrorListErrorHandler errorHandler) {
        this.buffer = buffer;
        this.errorHandler = errorHandler;
    }

    public void setDocumentLocator(Locator locator) {
        this.loc = locator;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        InputSource source = null;
        try {
            source = Resolver.instance().resolveEntity(name, publicId, baseURI, systemId);
        }
        catch (IOException e) {
            String msg = "resource with ";
            if (publicId != null) {
                msg = msg + " publicId=" + publicId;
            }
            if (systemId != null) {
                msg = msg + " systemId=" + systemId;
            }
            msg = msg + " cannot be resolved";
            String path = this.loc.getSystemId() != null ? PathUtilities.urlToPath(this.loc.getSystemId()) : this.buffer.getPath();
            throw new IOExceptionWithLocation(msg, path, Math.max(0, this.loc.getLineNumber() - 1), e);
        }
        if (source == null) {
            String msg = "resource with ";
            if (publicId != null) {
                msg = msg + " publicId=" + publicId;
            }
            if (systemId != null) {
                msg = msg + " systemId=" + systemId;
            }
            msg = msg + " cannot be resolved";
            Log.log((int)7, MyEntityResolver.class, (Object)msg);
            InputSource dummy = new InputSource(systemId);
            dummy.setPublicId(publicId);
            dummy.setCharacterStream(new StringReader("<!-- -->"));
            return dummy;
        }
        return source;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    public static class IOExceptionWithLocation
    extends IOException {
        public final String path;
        public final int line;

        public IOExceptionWithLocation(String msg, String path, int line, IOException cause) {
            super(msg, cause);
            this.path = path;
            this.line = line;
        }
    }
}

