/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;
import xml.PathUtilities;
import xml.Resolver;
import xml.XmlParsedData;
import xml.cache.Cache;
import xml.cache.CacheEntry;
import xml.completion.CompletionInfo;
import xml.completion.ElementDecl;
import xml.completion.IDDecl;
import xml.parser.ErrorListErrorHandler;
import xml.parser.MyEntityResolver;
import xml.parser.SchemaAutoLoader;
import xml.parser.XSDSchemaToCompletion;
import xml.parser.XercesParserImpl;

class GrabIdsAndCompletionInfoHandler
extends DefaultHandler2
implements ContentHandler,
DeclHandler,
LexicalHandler {
    private final XercesParserImpl xercesParserImpl;
    Buffer buffer;
    ErrorListErrorHandler errorHandler;
    XmlParsedData data;
    Stack<ElementDecl> elementDeclStack;
    Locator loc;
    boolean root = true;
    boolean seenBuffer = false;
    SchemaAutoLoader schemaAutoLoader;
    CompletionInfo dtdCompletionInfo;
    private MyEntityResolver resolver;
    List<String> xsdSchemaURLs;

    GrabIdsAndCompletionInfoHandler(XercesParserImpl xercesParserImpl, Buffer buffer, ErrorListErrorHandler errorHandler, XmlParsedData data, MyEntityResolver resolver) {
        this.xercesParserImpl = xercesParserImpl;
        this.buffer = buffer;
        this.errorHandler = errorHandler;
        this.data = data;
        this.elementDeclStack = new Stack();
        this.schemaAutoLoader = null;
        this.dtdCompletionInfo = null;
        this.resolver = resolver;
        this.xsdSchemaURLs = new ArrayList<String>();
    }

    void setSchemaAutoLoader(SchemaAutoLoader sal) {
        this.schemaAutoLoader = sal;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.loc = locator;
        this.resolver.setDocumentLocator(locator);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (!this.root) {
            this.data.allNamespacesBindingsAtTop = false;
        }
        if (uri != null) {
            CompletionInfo info = CompletionInfo.getCompletionInfoForNamespace(uri);
            if (info != null) {
                Log.log((int)1, XercesParserImpl.class, (Object)("using built-in completion info for " + uri));
                this.data.setCompletionInfo(uri, info);
                return;
            }
            if (this.schemaAutoLoader != null && this.schemaAutoLoader.getCompletionInfo() != null && this.schemaAutoLoader.getCompletionInfo().containsKey(uri)) {
                info = this.schemaAutoLoader.getCompletionInfo().get(uri);
                Log.log((int)1, XercesParserImpl.class, (Object)("setting completionInfo for '" + prefix + "' : " + info.namespace + ")"));
                this.data.setCompletionInfo(uri, info);
            }
        }
    }

    private void setCompletionInfoFromSchema(String ns, String location, String schemaLocation, String nonsSchemaLocation) throws IOException, SAXException {
        URI baseURI;
        try {
            baseURI = new URI(PathUtilities.pathToURL(this.buffer.getPath()));
        }
        catch (URISyntaxException e) {
            throw new IOException("error getting buffer uri??", e);
        }
        String[] sids = Resolver.instance().resolveEntityToPathInternal(null, null, baseURI.toString(), location);
        if (sids == null) {
            this.xsdSchemaURLs.add(baseURI.resolve(location).toString());
        } else {
            this.xsdSchemaURLs.add(sids[0]);
        }
        Map<String, CompletionInfo> infos = XSDSchemaToCompletion.getCompletionInfoFromSchema(location, schemaLocation, nonsSchemaLocation, this.errorHandler, this.buffer);
        for (Map.Entry<String, CompletionInfo> en : infos.entrySet()) {
            String nsC = en.getKey();
            this.data.setCompletionInfo(nsC, en.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        block18: {
            if (this.xercesParserImpl.stopped) {
                throw new XercesParserImpl.StoppedException();
            }
            if (this.root) {
                if (this.schemaAutoLoader != null && this.schemaAutoLoader.getCompletionInfo() != null && this.schemaAutoLoader.getCompletionInfo().containsKey("")) {
                    this.data.setCompletionInfo("", this.schemaAutoLoader.getCompletionInfo().get(""));
                }
                String schemaLocation = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                String noNamespaceSchemaLocation = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
                try {
                    String[] nsLocationPairs;
                    if (schemaLocation != null && (nsLocationPairs = schemaLocation.split("\\s+")).length % 2 == 0) {
                        for (int i = 0; i < nsLocationPairs.length; i += 2) {
                            String ns = nsLocationPairs[i];
                            String location = nsLocationPairs[i + 1];
                            try {
                                this.setCompletionInfoFromSchema(ns, location, schemaLocation, noNamespaceSchemaLocation);
                                continue;
                            }
                            catch (IOException e) {
                                throw new SAXException("error setting completion info from " + location, e);
                            }
                        }
                    }
                    if (noNamespaceSchemaLocation == null) break block18;
                    try {
                        this.setCompletionInfoFromSchema(null, noNamespaceSchemaLocation, schemaLocation, noNamespaceSchemaLocation);
                    }
                    catch (IOException e) {
                        throw new SAXException("error setting completion info from " + noNamespaceSchemaLocation, e);
                    }
                }
                finally {
                    this.root = false;
                }
            }
        }
        String currentURI = PathUtilities.urlToPath(this.loc.getSystemId());
        if (this.loc.getLineNumber() == -1) {
            Log.log((int)7, XercesParserImpl.class, (Object)("no location for " + qName));
            return;
        }
        ElementDecl cDecl = null;
        if (this.elementDeclStack.isEmpty() || this.elementDeclStack.peek() == null || this.elementDeclStack.peek().elementHash == null) {
            CompletionInfo i = this.data.getCompletionInfo(namespaceURI);
            if (i == null && this.schemaAutoLoader != null && this.schemaAutoLoader.getCompletionInfo() != null && this.schemaAutoLoader.getCompletionInfo().containsKey(namespaceURI)) {
                i = this.schemaAutoLoader.getCompletionInfo().get(namespaceURI);
            }
            if (i != null && (cDecl = i.elementHash.get(lName)) == null) {
                cDecl = i.getElementDeclLocal(lName);
            }
        } else {
            cDecl = this.elementDeclStack.peek().elementHash.get(lName);
        }
        this.elementDeclStack.push(cDecl);
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (!attrs.getType(i).equals("ID") && !attrs.getQName(i).equals("xml:id") && (cDecl == null || cDecl.getAttribute(attrs.getLocalName(i)) == null || !"ID".equals(cDecl.getAttribute((String)attrs.getLocalName((int)i)).type))) continue;
            this.data.ids.put(attrs.getValue(i), new IDDecl(currentURI, attrs.getValue(i), qName, this.loc.getLineNumber() - 1, this.loc.getColumnNumber() - 1));
        }
        this.seenBuffer |= this.buffer.getPath().equals(currentURI);
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (this.xercesParserImpl.stopped) {
            throw new XercesParserImpl.StoppedException();
        }
        if (!this.buffer.getPath().equals(PathUtilities.urlToPath(this.loc.getSystemId()))) {
            return;
        }
        if (this.loc.getLineNumber() == -1) {
            return;
        }
        this.elementDeclStack.pop();
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (publicId == null && systemId == null) {
            this.dtdCompletionInfo = this.data.getNoNamespaceCompletionInfo();
        } else {
            try {
                String realLocation = Resolver.instance().resolveEntityToPath(null, publicId, this.buffer.getPath(), systemId);
                CacheEntry ce = Cache.instance().get(realLocation, XercesParserImpl.COMPLETION_INFO_CACHE_ENTRY);
                if (ce == null) {
                    this.dtdCompletionInfo = this.data.getNoNamespaceCompletionInfo();
                    ce = Cache.instance().put(realLocation, XercesParserImpl.COMPLETION_INFO_CACHE_ENTRY, this.dtdCompletionInfo);
                    ce.getRequestingBuffers().add(this.buffer);
                } else {
                    ce.getRequestingBuffers().add(this.buffer);
                    this.dtdCompletionInfo = (CompletionInfo)ce.getCachedItem();
                    this.data.setCompletionInfo("", this.dtdCompletionInfo);
                }
                this.seenBuffer |= this.buffer.getPath().equals(PathUtilities.urlToPath(realLocation));
            }
            catch (IOException ioe) {
                throw new SAXException("error resolving DTD path", ioe);
            }
        }
    }

    @Override
    public void endDTD() {
        this.data.setCompletionInfo("", this.dtdCompletionInfo);
    }

    @Override
    public void elementDecl(String name, String model) {
        ElementDecl element = this.data.getElementDecl(name, 0);
        if (element == null) {
            CompletionInfo info = this.data.getNoNamespaceCompletionInfo();
            element = new ElementDecl(info, name, model);
            info.addElement(element);
        } else {
            element.setContent(model);
        }
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
        ArrayList<String> values;
        ElementDecl element = this.data.getElementDecl(eName, 0);
        if (element == null) {
            CompletionInfo info = this.data.getNoNamespaceCompletionInfo();
            element = new ElementDecl(info, eName, null);
            info.addElement(element);
        }
        if (element.getAttribute(aName) != null) {
            return;
        }
        if (type.startsWith("(")) {
            values = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(type.substring(1, type.length() - 1), "|");
            while (st.hasMoreTokens()) {
                values.add(st.nextToken());
            }
        } else {
            values = null;
        }
        boolean required = "#REQUIRED".equals(valueDefault);
        element.addAttribute(new ElementDecl.AttributeDecl(aName, null, value, values, type, required));
    }

    @Override
    public void internalEntityDecl(String name, String value) {
        if (name.startsWith("%")) {
            return;
        }
        this.data.getNoNamespaceCompletionInfo().addEntity(0, name, value);
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) {
        if (name.startsWith("%")) {
            return;
        }
        this.data.getNoNamespaceCompletionInfo().addEntity(1, name, publicId, systemId);
    }
}

