/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import errorlist.DefaultErrorSource;
import org.gjt.sp.util.Log;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import xml.PathUtilities;

public class ErrorListErrorHandler
implements ErrorHandler {
    private DefaultErrorSource errorSource;
    private String defaultPath;

    public ErrorListErrorHandler(DefaultErrorSource errorSource, String defaultPath) {
        this.errorSource = errorSource;
        this.defaultPath = defaultPath;
    }

    private void addError(int type, SAXParseException exception) {
        String path;
        String systemId;
        int line = exception.getLineNumber() - 1;
        int col = exception.getColumnNumber() - 1;
        if (line < 0) {
            line = 0;
        }
        if (col < 0) {
            col = 0;
        }
        if ((systemId = exception.getSystemId()) == null) {
            Log.log((int)1, (Object)this, (Object)"NULL systemId");
            path = PathUtilities.urlToPath(this.defaultPath);
        } else {
            path = PathUtilities.urlToPath(systemId);
        }
        this.errorSource.addError(type, path, line, 0, col, exception.getMessage());
    }

    @Override
    public void error(SAXParseException spe) {
        this.addError(0, spe);
    }

    @Override
    public void warning(SAXParseException spe) {
        this.addError(1, spe);
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXParseException {
        this.addError(0, spe);
    }

    public void setDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public DefaultErrorSource getErrorSource() {
        return this.errorSource;
    }
}

