/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import java.io.IOException;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.gjt.sp.util.Log;

class EntityMgrFixerConfiguration
extends XIncludeAwareParserConfiguration {
    protected EntityMgrFixer fEntityMgrFixer;

    public EntityMgrFixerConfiguration(SymbolTable symbolTable, XMLGrammarPool cachedGrammarPool) {
        super(symbolTable, cachedGrammarPool);
        this.fCommonComponents.remove(this.fEntityManager);
        this.fEntityManager = new MyEntityManager();
        this.fProperties.put("http://apache.org/xml/properties/internal/entity-manager", this.fEntityManager);
        this.addCommonComponent((XMLComponent)this.fEntityManager);
        this.fErrorReporter.setDocumentLocator((XMLLocator)this.fEntityManager.getEntityScanner());
    }

    protected void configurePipeline() {
        super.configurePipeline();
        this.fEntityMgrFixer = new EntityMgrFixer();
        XMLDocumentSource prev = this.fLastComponent;
        this.fLastComponent = this.fEntityMgrFixer;
        XMLDocumentHandler next = prev.getDocumentHandler();
        prev.setDocumentHandler((XMLDocumentHandler)this.fEntityMgrFixer);
        this.fEntityMgrFixer.setDocumentSource(prev);
        if (next != null) {
            this.fEntityMgrFixer.setDocumentHandler(next);
            next.setDocumentSource((XMLDocumentSource)this.fEntityMgrFixer);
        }
    }

    private static class MyEntityManager
    extends XMLEntityManager {
        private MyEntityManager() {
        }

        private void copyEntitiesFromDTD(DTDGrammar grammar) {
            XMLEntityDecl entityDecl = new XMLEntityDecl();
            int i = 0;
            while (grammar.getEntityDecl(i, entityDecl)) {
                this.fInExternalSubset = entityDecl.inExternal;
                if (entityDecl.inExternal) {
                    if (entityDecl.publicId != null || entityDecl.systemId != null) {
                        try {
                            this.addExternalEntity(entityDecl.name, entityDecl.publicId, entityDecl.systemId, entityDecl.baseSystemId);
                        }
                        catch (IOException e) {
                            Log.log((int)7, EntityMgrFixerConfiguration.class, (Object)("error adding external entity from cached grammar (" + entityDecl + ")"), (Throwable)e);
                        }
                    } else {
                        this.addInternalEntity(entityDecl.name, entityDecl.value);
                    }
                }
                ++i;
            }
            this.fInExternalSubset = false;
        }
    }

    private class EntityMgrFixer
    implements XMLComponent,
    XMLDocumentFilter {
        protected XMLDocumentHandler fDocumentHandler;
        protected XMLDocumentSource fDocumentSource;
        protected XMLLocator fDocLocation;

        private EntityMgrFixer() {
        }

        public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            this.fDocLocation = locator;
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.startDocument(locator, encoding, namespaceContext, augs);
            }
        }

        public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.doctypeDecl(rootElement, publicId, systemId, augs);
            }
            if (EntityMgrFixerConfiguration.this.fValidationManager.isCachedDTD()) {
                String eid = null;
                try {
                    eid = XMLEntityManager.expandSystemId((String)systemId, (String)this.fDocLocation.getExpandedSystemId(), (boolean)false);
                }
                catch (IOException e) {
                    // empty catch block
                }
                XMLDTDDescription grammarDesc = new XMLDTDDescription(publicId, systemId, this.fDocLocation.getExpandedSystemId(), eid, rootElement);
                DTDGrammar grammar = (DTDGrammar)EntityMgrFixerConfiguration.this.fGrammarPool.retrieveGrammar((XMLGrammarDescription)grammarDesc);
                assert (grammar != null);
                ((MyEntityManager)EntityMgrFixerConfiguration.this.fEntityManager).copyEntitiesFromDTD(grammar);
            }
        }

        public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.xmlDecl(version, encoding, standalone, augs);
            }
        }

        public void comment(XMLString text, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.comment(text, augs);
            }
        }

        public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.processingInstruction(target, data, augs);
            }
        }

        public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.startElement(element, attributes, augs);
            }
        }

        public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.emptyElement(element, attributes, augs);
            }
        }

        public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.startGeneralEntity(name, identifier, encoding, augs);
            }
        }

        public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.textDecl(version, encoding, augs);
            }
        }

        public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endGeneralEntity(name, augs);
            }
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.characters(text, augs);
            }
        }

        public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.ignorableWhitespace(text, augs);
            }
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endElement(element, augs);
            }
        }

        public void startCDATA(Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.startCDATA(augs);
            }
        }

        public void endCDATA(Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endCDATA(augs);
            }
        }

        public void endDocument(Augmentations augs) throws XNIException {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endDocument(augs);
            }
        }

        public void setDocumentSource(XMLDocumentSource source) {
            this.fDocumentSource = source;
        }

        public XMLDocumentSource getDocumentSource() {
            return this.fDocumentSource;
        }

        public void setDocumentHandler(XMLDocumentHandler handler) {
            this.fDocumentHandler = handler;
        }

        public XMLDocumentHandler getDocumentHandler() {
            return this.fDocumentHandler;
        }

        public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        }

        public String[] getRecognizedFeatures() {
            return null;
        }

        public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        }

        public String[] getRecognizedProperties() {
            return null;
        }

        public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        }

        public Boolean getFeatureDefault(String featureId) {
            return null;
        }

        public Object getPropertyDefault(String propertyId) {
            return null;
        }
    }
}

