/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import java.lang.reflect.Constructor;
import java.util.Stack;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import xml.NamespaceBindings;
import xml.PathUtilities;
import xml.XmlParsedData;
import xml.parser.ErrorListErrorHandler;
import xml.parser.MyEntityResolver;
import xml.parser.XercesParserImpl;
import xml.parser.XmlTag;

class ConstructTreeHandler
extends DefaultHandler2
implements ContentHandler {
    private final XercesParserImpl xercesParserImpl;
    Buffer buffer;
    ErrorListErrorHandler errorHandler;
    CharSequence text;
    XmlParsedData data;
    NamespaceBindings declaredPrefixes;
    Stack<DefaultMutableTreeNode> currentNodeStack;
    Locator loc;
    boolean empty;
    private MyEntityResolver resolver;

    ConstructTreeHandler(XercesParserImpl xercesParserImpl, Buffer buffer, CharSequence text, ErrorListErrorHandler errorHandler, XmlParsedData data, MyEntityResolver resolver) {
        this.xercesParserImpl = xercesParserImpl;
        this.buffer = buffer;
        this.text = text;
        this.errorHandler = errorHandler;
        this.data = data;
        this.currentNodeStack = new Stack();
        this.empty = true;
        this.resolver = resolver;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.loc = locator;
        this.resolver.setDocumentLocator(locator);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.declaredPrefixes == null) {
            this.declaredPrefixes = new NamespaceBindings();
        }
        this.declaredPrefixes.put(uri, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        if (this.xercesParserImpl.stopped) {
            throw new XercesParserImpl.StoppedException();
        }
        this.empty = true;
        String currentURI = PathUtilities.urlToPath(this.loc.getSystemId());
        if (this.loc.getLineNumber() == -1) {
            Log.log((int)7, XercesParserImpl.class, (Object)("no location for " + qName));
            return;
        }
        if (!this.buffer.getPath().equals(currentURI)) {
            return;
        }
        this.buffer.readLock();
        try {
            int line = Math.min(this.buffer.getLineCount() - 1, this.loc.getLineNumber() - 1);
            int column = this.loc.getColumnNumber() - 1;
            int offset = Math.min(this.text.length() - 1, this.buffer.getLineStartOffset(line) + column - 1);
            offset = this.findTagStart(offset);
            Position pos = this.buffer.createPosition(offset);
            XmlTag newTag = this.createTag(qName, namespaceURI == null ? "" : namespaceURI, pos, attrs);
            newTag.namespaceBindings = this.declaredPrefixes;
            this.declaredPrefixes = null;
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode((Object)newTag);
            if (!this.currentNodeStack.isEmpty()) {
                DefaultMutableTreeNode node = this.currentNodeStack.peek();
                node.insert(newNode, node.getChildCount());
            } else {
                this.data.root.insert(newNode, 0);
            }
            this.currentNodeStack.push(newNode);
        }
        finally {
            this.buffer.readUnlock();
        }
    }

    private XmlTag createTag(String qname, String namespaceURI, Position pos, Attributes attrs) {
        String tagClassName = jEdit.getProperty((String)("xml.xmltag." + this.buffer.getMode().toString()));
        if (tagClassName != null) {
            try {
                Class<?> tagClass = Class.forName(tagClassName);
                Constructor<?> con = tagClass.getConstructor(String.class, String.class, Position.class, Attributes.class);
                return (XmlTag)((Object)con.newInstance(qname, namespaceURI, pos, attrs));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new XmlTag(qname, namespaceURI, pos, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (this.xercesParserImpl.stopped) {
            throw new XercesParserImpl.StoppedException();
        }
        if (!this.buffer.getPath().equals(PathUtilities.urlToPath(this.loc.getSystemId()))) {
            return;
        }
        if (this.loc.getLineNumber() == -1) {
            return;
        }
        this.buffer.readLock();
        try {
            DefaultMutableTreeNode node = this.currentNodeStack.peek();
            XmlTag tag = (XmlTag)((Object)node.getUserObject());
            if (tag.getName().equals(qName)) {
                int line = Math.min(this.buffer.getLineCount() - 1, this.loc.getLineNumber() - 1);
                int column = this.loc.getColumnNumber() - 1;
                int offset = Math.min(this.buffer.getLength(), this.buffer.getLineStartOffset(line) + column);
                tag.setEnd(this.buffer.createPosition(offset));
                tag.empty = this.empty;
                this.currentNodeStack.pop();
            }
        }
        finally {
            this.buffer.readUnlock();
        }
        this.empty = false;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        DefaultMutableTreeNode node;
        XmlTag tag;
        if (this.xercesParserImpl.stopped) {
            throw new XercesParserImpl.StoppedException();
        }
        this.empty = false;
        if (!this.currentNodeStack.isEmpty() && (tag = (XmlTag)((Object)(node = this.currentNodeStack.peek()).getUserObject())).canAddCharacters()) {
            char[] chBis = new char[length];
            System.arraycopy(ch, start, chBis, 0, length);
            tag.addCharacters(chBis);
        }
    }

    private int findTagStart(int offset) {
        for (int i = offset; i >= 0; --i) {
            if (this.text.charAt(i) != '<') continue;
            return i;
        }
        return 0;
    }
}

