/*
 * Decompiled with CFR 0.152.
 */
package xml.parser;

import java.util.ArrayList;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.util.Log;
import xml.Resolver;
import xml.cache.Cache;
import xml.cache.CacheEntry;

public class CachedGrammarPool
implements XMLGrammarPool {
    private Buffer buffer;

    public CachedGrammarPool(Buffer requestingBuffer) {
        this.buffer = requestingBuffer;
    }

    public Grammar[] retrieveInitialGrammarSet(String grammarType) {
        return new Grammar[0];
    }

    public void cacheGrammars(String grammarType, Grammar[] grammars) {
        Cache cache = Cache.instance();
        ArrayList<CacheEntry> myGrammars = new ArrayList<CacheEntry>(grammars.length);
        for (Grammar g : grammars) {
            XMLGrammarDescription desc = g.getGrammarDescription();
            String path = null;
            try {
                path = Resolver.instance().resolveEntityToPath(null, desc.getPublicId(), desc.getBaseSystemId(), desc.getLiteralSystemId());
            }
            catch (Exception e) {
                Log.log((int)9, CachedGrammarPool.class, (Object)("error caching " + desc), (Throwable)e);
            }
            if (path == null) continue;
            myGrammars.add(cache.put(path, grammarType, g));
        }
        for (CacheEntry en : myGrammars) {
            en.getRequestingBuffers().add(this.buffer);
            en.getRelated().addAll(myGrammars);
            en.getRelated().remove(en);
        }
    }

    public Grammar retrieveGrammar(XMLGrammarDescription desc) {
        if (desc.getPublicId() == null && desc.getLiteralSystemId() == null) {
            return null;
        }
        Cache cache = Cache.instance();
        String path = null;
        try {
            path = Resolver.instance().resolveEntityToPath(null, desc.getPublicId(), desc.getBaseSystemId(), desc.getLiteralSystemId());
        }
        catch (Exception e) {
            Log.log((int)9, CachedGrammarPool.class, (Object)("error retrieving " + desc));
            Log.log((int)9, CachedGrammarPool.class, (Object)e);
        }
        CacheEntry en = cache.get(path, desc.getGrammarType());
        if (en == null) {
            return null;
        }
        en.getRequestingBuffers().add(this.buffer);
        return (Grammar)en.getCachedItem();
    }

    public void lockPool() {
        throw new UnsupportedOperationException();
    }

    public void unlockPool() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }
}

