/*
 * Decompiled with CFR 0.152.
 */
package xml.options;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class CatalogsOptionPane
extends AbstractOptionPane {
    private JList catalogList;
    private DefaultListModel catalogListModel;
    private JButton add;
    private JButton remove;

    public CatalogsOptionPane() {
        super("xml.catalogs");
    }

    protected void _init() {
        String catalog;
        this.setLayout(new BorderLayout());
        JLabel label = new JLabel(jEdit.getProperty((String)"options.xml.catalogs.caption"));
        label.setBorder(new EmptyBorder(0, 0, 6, 0));
        this.add("North", label);
        this.catalogListModel = new DefaultListModel();
        int i = 0;
        while ((catalog = jEdit.getProperty((String)("xml.catalog." + i))) != null) {
            this.catalogListModel.addElement(catalog);
            ++i;
        }
        this.catalogList = new JList(this.catalogListModel);
        this.add("Center", new JScrollPane(this.catalogList));
        this.catalogList.addListSelectionListener(new ListHandler());
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(6, 0, 0, 0));
        this.add = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        this.add.setToolTipText(jEdit.getProperty((String)"options.xml.catalogs.add"));
        this.add.addActionListener(new ActionHandler());
        buttons.add(this.add);
        this.remove = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty((String)"options.xml.catalogs.remove"));
        this.remove.addActionListener(new ActionHandler());
        buttons.add(this.remove);
        buttons.add(Box.createGlue());
        this.add("South", buttons);
        this.updateEnabled();
    }

    protected void _save() {
        int i;
        for (i = 0; i < this.catalogListModel.getSize(); ++i) {
            jEdit.setProperty((String)("xml.catalog." + i), (String)((String)this.catalogListModel.getElementAt(i)));
        }
        jEdit.unsetProperty((String)("xml.catalog." + i));
    }

    private void updateEnabled() {
        boolean selected = this.catalogList.getSelectedValue() != null;
        this.remove.setEnabled(selected);
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            CatalogsOptionPane.this.updateEnabled();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == CatalogsOptionPane.this.add) {
                String[] files = GUIUtilities.showVFSFileDialog(null, null, (int)0, (boolean)true);
                if (files == null) {
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    CatalogsOptionPane.this.catalogListModel.addElement(files[i]);
                }
            } else if (evt.getSource() == CatalogsOptionPane.this.remove) {
                CatalogsOptionPane.this.catalogListModel.removeElementAt(CatalogsOptionPane.this.catalogList.getSelectedIndex());
                CatalogsOptionPane.this.updateEnabled();
            }
        }
    }
}

